/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.platform.resource;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.geoserver.platform.resource.Paths;
import org.geoserver.platform.resource.Resource;
import org.geoserver.platform.resource.ResourceListener;
import org.geoserver.platform.resource.ResourceNotification;
import org.geoserver.platform.resource.ResourceNotificationDispatcher;
import org.geoserver.platform.resource.Resources;

public class SimpleResourceNotificationDispatcher
implements ResourceNotificationDispatcher {
    private Map<String, List<ResourceListener>> handlers = new HashMap<String, List<ResourceListener>>();

    @Override
    public synchronized void addListener(String resource, ResourceListener listener) {
        List<ResourceListener> listeners = this.handlers.get(resource);
        if (listeners == null) {
            listeners = new ArrayList<ResourceListener>();
            this.handlers.put(resource, listeners);
        }
        listeners.add(listener);
    }

    @Override
    public synchronized boolean removeListener(String resource, ResourceListener listener) {
        List<ResourceListener> listeners = this.handlers.get(resource);
        if (listeners != null) {
            return listeners.remove(listener);
        }
        return false;
    }

    protected void changedInternal(ResourceNotification notification) {
        List<ResourceListener> listeners = this.handlers.get(notification.getPath());
        if (listeners != null) {
            listeners = new ArrayList<ResourceListener>(listeners);
            for (ResourceListener listener : listeners) {
                listener.changed(notification);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void changed(ResourceNotification notification) {
        void var3_7;
        this.changedInternal(notification);
        if (notification.getKind() == ResourceNotification.Kind.ENTRY_DELETE) {
            for (ResourceNotification.Event event : notification.events()) {
                if (notification.getPath().equals(event.getPath())) continue;
                this.changedInternal(new ResourceNotification(event.getPath(), ResourceNotification.Kind.ENTRY_DELETE, notification.getTimestamp(), notification.events()));
            }
        }
        HashSet<String> createdParents = new HashSet<String>();
        if (notification.getKind() == ResourceNotification.Kind.ENTRY_CREATE) {
            for (ResourceNotification.Event event : notification.events()) {
                if (notification.getPath().equals(event.getPath())) continue;
                createdParents.add(event.getPath());
            }
        }
        String string = Paths.parent(notification.getPath());
        while (var3_7 != null) {
            boolean isCreate = createdParents.contains(var3_7);
            this.changedInternal(new ResourceNotification((String)var3_7, isCreate ? ResourceNotification.Kind.ENTRY_CREATE : ResourceNotification.Kind.ENTRY_MODIFY, notification.getTimestamp(), this.relative(notification.events(), (String)var3_7)));
            String string2 = isCreate ? Paths.parent((String)var3_7) : null;
        }
    }

    private List<ResourceNotification.Event> relative(List<ResourceNotification.Event> events, String path) {
        ArrayList<ResourceNotification.Event> result = new ArrayList<ResourceNotification.Event>();
        for (ResourceNotification.Event event : events) {
            result.add(new ResourceNotification.Event(event.getPath().replace(path + "/", ""), event.getKind()));
        }
        return result;
    }

    public static List<ResourceNotification.Event> createEvents(Resource resource, ResourceNotification.Kind kind) {
        ArrayList<ResourceNotification.Event> events = new ArrayList<ResourceNotification.Event>();
        events.add(new ResourceNotification.Event(resource.path(), kind));
        if (resource.getType() == Resource.Type.DIRECTORY && kind == ResourceNotification.Kind.ENTRY_DELETE) {
            for (Resource child : Resources.listRecursively(resource)) {
                events.add(new ResourceNotification.Event(child.path(), kind));
            }
        }
        if (kind == ResourceNotification.Kind.ENTRY_CREATE) {
            for (Resource parent = resource.parent(); parent != null && !Resources.exists(parent); parent = parent.parent()) {
                events.add(new ResourceNotification.Event(parent.path(), kind));
            }
        }
        return events;
    }

    public static List<ResourceNotification.Event> createRenameEvents(Resource src, Resource dest) {
        ArrayList<ResourceNotification.Event> events = new ArrayList<ResourceNotification.Event>();
        events.add(new ResourceNotification.Event(dest.path(), Resources.exists(dest) ? ResourceNotification.Kind.ENTRY_MODIFY : ResourceNotification.Kind.ENTRY_CREATE));
        for (Resource child : Resources.listRecursively(src)) {
            Resource newChild = dest.get(child.path().substring(src.path().length() + 1));
            events.add(new ResourceNotification.Event(newChild.path(), Resources.exists(newChild) ? ResourceNotification.Kind.ENTRY_MODIFY : ResourceNotification.Kind.ENTRY_CREATE));
        }
        return events;
    }
}

