/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.platform;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.platform.ModuleStatus;
import org.geotools.util.logging.Logging;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class ModuleStatusImpl
implements ModuleStatus,
Serializable {
    private static final Logger LOGGER = Logging.getLogger(ModuleStatusImpl.class);
    private static final long serialVersionUID = -5759469520194940051L;
    private String module;
    private String name;
    private String component;
    private String version;
    private String documentation;
    private String message;
    private boolean isEnabled;
    private boolean isAvailable;
    private static Map<String, String> MAVEN_VERSIONS = new HashMap<String, String>();

    public ModuleStatusImpl() {
    }

    public ModuleStatusImpl(ModuleStatus status) {
        this.module = status.getModule();
        this.name = status.getName();
        this.component = status.getComponent().orElse(null);
        this.version = status.getVersion().orElse(this.getVersionInternal());
        this.documentation = status.getDocumentation().orElse(null);
        this.message = status.getMessage().orElse(null);
        this.isEnabled = status.isEnabled();
        this.isAvailable = status.isAvailable();
    }

    public ModuleStatusImpl(String module, String name) {
        this.module = module;
        this.name = name;
        this.isAvailable = true;
        this.isEnabled = true;
        this.version = this.getVersionInternal();
    }

    public ModuleStatusImpl(String module, String name, String component) {
        this(module, name);
        this.component = component;
    }

    @Override
    public String getModule() {
        return this.module;
    }

    public void setModule(String module) {
        this.module = module;
    }

    @Override
    public Optional<String> getComponent() {
        return Optional.ofNullable(this.component);
    }

    public void setComponent(String component) {
        this.component = component;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Optional<String> getVersion() {
        return Optional.ofNullable(this.version);
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @Override
    public boolean isAvailable() {
        return this.isAvailable;
    }

    public void setAvailable(boolean isAvailable) {
        this.isAvailable = isAvailable;
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void setEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    @Override
    public Optional<String> getMessage() {
        return Optional.ofNullable(this.message);
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @Override
    public Optional<String> getDocumentation() {
        return Optional.ofNullable(this.documentation);
    }

    public void setDocumentation(String documentation) {
        this.documentation = documentation;
    }

    public String toString() {
        return "ModuleStatusImpl [module=" + this.module + ", component=" + this.component + ", version=" + this.version + "]";
    }

    protected String getVersionInternal() {
        return ModuleStatusImpl.listVersionsInternal().get(this.module);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, String> listVersionsInternal() {
        Map<String, String> map = MAVEN_VERSIONS;
        synchronized (map) {
            if (MAVEN_VERSIONS.isEmpty()) {
                try {
                    Resource[] resources;
                    for (Resource resource : resources = new PathMatchingResourcePatternResolver().getResources("classpath*:META-INF/maven/*/*/pom.properties")) {
                        try (InputStream in = resource.getInputStream();){
                            Properties properties = new Properties();
                            properties.load(in);
                            String artifactId = properties.getProperty("artifactId");
                            String version = properties.getProperty("version");
                            MAVEN_VERSIONS.put(artifactId, version);
                        }
                        catch (IOException e) {
                            LOGGER.log(Level.FINE, "Error reading pom.properties: " + resource.getFilename(), e);
                        }
                    }
                }
                catch (IOException e) {
                    LOGGER.log(Level.WARNING, "Error listing pom.properties", e);
                }
            }
        }
        return MAVEN_VERSIONS;
    }
}

