/*
 * Decompiled with CFR 0.152.
 */
package net.sf.json.util;

import java.io.IOException;
import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.json.JSONException;
import net.sf.json.util.JSONUtils;

public class JSONBuilder {
    private static final int MAXDEPTH_DEFAULT = 100;
    private boolean comma = false;
    protected char mode;
    private char[] stack;
    private int top = 0;
    protected Writer writer;
    private final int maxDepth = JSONBuilder.getMaxDepth();
    static /* synthetic */ Class class$net$sf$json$util$JSONBuilder;

    public JSONBuilder(Writer w) {
        this.mode = (char)105;
        this.stack = new char[this.maxDepth];
        this.writer = w;
    }

    private JSONBuilder append(String s) {
        if (s == null) {
            throw new JSONException("Null pointer");
        }
        if (this.mode == 'o' || this.mode == 'a') {
            try {
                if (this.comma && this.mode == 'a') {
                    this.writer.write(44);
                }
                this.writer.write(s);
            }
            catch (IOException e) {
                throw new JSONException(e);
            }
            if (this.mode == 'o') {
                this.mode = (char)107;
            }
            this.comma = true;
            return this;
        }
        throw new JSONException("Value out of sequence.");
    }

    public JSONBuilder array() {
        if (this.mode == 'i' || this.mode == 'o' || this.mode == 'a') {
            this.push('a');
            this.append("[");
            this.comma = false;
            return this;
        }
        throw new JSONException("Misplaced array.");
    }

    private JSONBuilder end(char m, char c) {
        if (this.mode != m) {
            throw new JSONException(m == 'o' ? "Misplaced endObject." : "Misplaced endArray.");
        }
        this.pop(m);
        try {
            this.writer.write(c);
        }
        catch (IOException e) {
            throw new JSONException(e);
        }
        this.comma = true;
        return this;
    }

    public JSONBuilder endArray() {
        return this.end('a', ']');
    }

    public JSONBuilder endObject() {
        return this.end('k', '}');
    }

    public JSONBuilder key(String s) {
        if (s == null) {
            throw new JSONException("Null key.");
        }
        if (this.mode == 'k') {
            try {
                if (this.comma) {
                    this.writer.write(44);
                }
                this.writer.write(JSONUtils.quote(s));
                this.writer.write(58);
                this.comma = false;
                this.mode = (char)111;
                return this;
            }
            catch (IOException e) {
                throw new JSONException(e);
            }
        }
        throw new JSONException("Misplaced key.");
    }

    public JSONBuilder object() {
        if (this.mode == 'i') {
            this.mode = (char)111;
        }
        if (this.mode == 'o' || this.mode == 'a') {
            this.append("{");
            this.push('k');
            this.comma = false;
            return this;
        }
        throw new JSONException("Misplaced object.");
    }

    private void pop(char c) {
        if (this.top <= 0 || this.stack[this.top - 1] != c) {
            throw new JSONException("Nesting error.");
        }
        --this.top;
        this.mode = (char)(this.top == 0 ? 100 : this.stack[this.top - 1]);
    }

    private void push(char c) {
        if (this.top >= this.maxDepth) {
            throw new JSONException("Nesting too deep.");
        }
        this.stack[this.top] = c;
        this.mode = c;
        ++this.top;
    }

    public JSONBuilder value(boolean b) {
        return this.append(b ? "true" : "false");
    }

    public JSONBuilder value(double d) {
        return this.value(new Double(d));
    }

    public JSONBuilder value(long l) {
        return this.append(Long.toString(l));
    }

    public JSONBuilder value(Object o) {
        return this.append(JSONUtils.valueToString(o));
    }

    static int getMaxDepth() {
        String maxDepthProperty = System.getProperty("json.maxDepth");
        if (maxDepthProperty == null) {
            return 100;
        }
        try {
            int max = Integer.parseInt(maxDepthProperty.trim());
            if (max <= 0) {
                Logger logger = Logger.getLogger((class$net$sf$json$util$JSONBuilder == null ? (class$net$sf$json$util$JSONBuilder = JSONBuilder.class$("net.sf.json.util.JSONBuilder")) : class$net$sf$json$util$JSONBuilder).getName());
                if (logger.isLoggable(Level.WARNING)) {
                    logger.warning("Bad value for 'json.maxDepth' system property, it must be greater than zero. Current value: " + max);
                }
                return 100;
            }
            return max;
        }
        catch (NumberFormatException e) {
            Logger logger = Logger.getLogger((class$net$sf$json$util$JSONBuilder == null ? (class$net$sf$json$util$JSONBuilder = JSONBuilder.class$("net.sf.json.util.JSONBuilder")) : class$net$sf$json$util$JSONBuilder).getName());
            if (logger.isLoggable(Level.WARNING)) {
                logger.warning("Bad number format for 'json.maxDepth' system property: " + maxDepthProperty);
            }
            return 100;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

