/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.kml.builder;

import de.micromata.opengis.kml.v_2_2_0.Document;
import de.micromata.opengis.kml.v_2_2_0.Feature;
import de.micromata.opengis.kml.v_2_2_0.Kml;
import de.micromata.opengis.kml.v_2_2_0.LookAt;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.geoserver.kml.KmlEncodingContext;
import org.geoserver.kml.decorator.KmlDecoratorFactory;
import org.geoserver.platform.ServiceException;
import org.geoserver.wms.MapLayerInfo;
import org.geoserver.wms.WMSMapContent;
import org.geotools.api.data.FeatureSource;
import org.geotools.api.data.Query;
import org.geotools.api.filter.Filter;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.feature.FeatureCollection;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.Layer;
import org.geotools.referencing.CRS;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.Envelope;

public abstract class AbstractNetworkLinkBuilder {
    static final Logger LOGGER = Logging.getLogger(AbstractNetworkLinkBuilder.class);
    protected KmlEncodingContext context;

    public AbstractNetworkLinkBuilder(KmlEncodingContext context) {
        this.context = context;
    }

    public Kml buildKMLDocument() {
        Kml kml = new Kml();
        Document document = kml.createAndSetDocument();
        Map formatOptions = this.context.getRequest().getFormatOptions();
        String kmltitle = (String)formatOptions.get("kmltitle");
        if (kmltitle == null) {
            kmltitle = this.context.getMapContent().getTitle();
        }
        document.setName(kmltitle);
        List<KmlDecoratorFactory.KmlDecorator> decorators = this.context.getDecoratorsForClass(Document.class);
        for (KmlDecoratorFactory.KmlDecorator decorator : decorators) {
            document = (Document)decorator.decorate((Feature)document, this.context);
            if (document != null) continue;
            throw new ServiceException("Coding error in decorator " + decorator + ", document objects cannot be set to null");
        }
        this.encodeDocumentContents(document);
        return kml;
    }

    abstract void encodeDocumentContents(Document var1);

    protected ReferencedEnvelope computePerLayerQueryBounds(WMSMapContent context, List<ReferencedEnvelope> target, LookAt lookAt) {
        ReferencedEnvelope aggregatedBounds;
        boolean computeQueryBounds = lookAt == null;
        try {
            boolean longitudeFirst = true;
            aggregatedBounds = new ReferencedEnvelope(CRS.decode((String)"EPSG:4326", (boolean)longitudeFirst));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        aggregatedBounds.setToNull();
        List mapLayers = context.layers();
        List layerInfos = context.getRequest().getLayers();
        for (int i = 0; i < mapLayers.size(); ++i) {
            Layer Layer2 = (Layer)mapLayers.get(i);
            MapLayerInfo layerInfo = (MapLayerInfo)layerInfos.get(i);
            ReferencedEnvelope layerLatLongBbox = this.computeLayerBounds(Layer2, layerInfo, computeQueryBounds);
            try {
                layerLatLongBbox = layerLatLongBbox.transform(aggregatedBounds.getCoordinateReferenceSystem(), true);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            target.add(layerLatLongBbox);
            aggregatedBounds.expandToInclude((Envelope)layerLatLongBbox);
        }
        return aggregatedBounds;
    }

    protected ReferencedEnvelope computeLayerBounds(Layer layer, MapLayerInfo layerInfo, boolean computeQueryBounds) {
        Query layerQuery = layer.getQuery();
        Filter filter = layerQuery.getFilter();
        if (layerQuery.getFilter() == null || Filter.INCLUDE.equals(filter)) {
            computeQueryBounds = false;
        }
        if (!computeQueryBounds && !layerQuery.isMaxFeaturesUnlimited()) {
            computeQueryBounds = true;
        }
        ReferencedEnvelope layerLatLongBbox = null;
        if (computeQueryBounds) {
            FeatureSource featureSource = layer.getFeatureSource();
            try {
                CoordinateReferenceSystem targetCRS = CRS.decode((String)"EPSG:4326");
                FeatureCollection features = featureSource.getFeatures(layerQuery);
                layerLatLongBbox = features.getBounds();
                layerLatLongBbox = layerLatLongBbox.transform(targetCRS, true);
            }
            catch (Exception e) {
                LOGGER.info("Error computing bounds for " + featureSource.getName() + " with " + layerQuery);
            }
        }
        if (layerLatLongBbox == null) {
            try {
                layerLatLongBbox = layerInfo.getLatLongBoundingBox();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return layerLatLongBbox;
    }
}

