/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.kml;

import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.geoserver.kml.KMLReflector;
import org.geoserver.platform.ServiceException;
import org.geoserver.wms.GetMapRequest;
import org.geoserver.wms.WMS;
import org.geoserver.wms.WebMapService;

public class WebMapServiceKmlInterceptor
implements MethodInterceptor {
    private WMS wms;
    private WebMapService webMapService;

    public WebMapServiceKmlInterceptor(WMS wms, WebMapService webMapService) {
        this.wms = wms;
        this.webMapService = webMapService;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        if (invocation.getMethod().getName().equals("kml")) {
            try {
                GetMapRequest getMap = (GetMapRequest)invocation.getArguments()[0];
                return KMLReflector.doWms(getMap, this.webMapService, this.wms);
            }
            catch (Exception e) {
                if (e instanceof ServiceException) {
                    throw e;
                }
                throw new ServiceException((Throwable)e);
            }
        }
        return invocation.proceed();
    }
}

