/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.kml;

import de.micromata.opengis.kml.v_2_2_0.Kml;
import java.io.IOException;
import org.geoserver.kml.KMLMap;
import org.geoserver.kml.KMLMapOutputFormat;
import org.geoserver.kml.KmlEncodingContext;
import org.geoserver.kml.builder.StreamingKMLBuilder;
import org.geoserver.platform.ServiceException;
import org.geoserver.wms.MapProducerCapabilities;
import org.geoserver.wms.WMS;
import org.geoserver.wms.WMSMapContent;
import org.geoserver.wms.map.AbstractMapOutputFormat;

public class KMZMapOutputFormat
extends AbstractMapOutputFormat {
    public static final String MIME_TYPE = "application/vnd.google-earth.kmz";
    public static final String NL_KMZ_MIME_TYPE = "application/vnd.google-earth.kmz;mode=networklink";
    public static final String[] OUTPUT_FORMATS = new String[]{"application/vnd.google-earth.kmz", "application/vnd.google-earth.kmz+xml", "kmz", "application/vnd.google-earth.kmz xml"};
    private WMS wms;
    private StreamingKMLBuilder builder = new StreamingKMLBuilder();

    public KMZMapOutputFormat(WMS wms) {
        super(MIME_TYPE, OUTPUT_FORMATS);
        this.wms = wms;
    }

    public KMLMap produceMap(WMSMapContent mapContent) throws ServiceException, IOException {
        KmlEncodingContext context = new KmlEncodingContext(mapContent, this.wms, true);
        Kml kml = this.builder.buildKMLDocument(context);
        KMLMap map = new KMLMap(mapContent, context, kml, MIME_TYPE);
        map.setContentDispositionHeader(mapContent, ".kmz");
        return map;
    }

    public MapProducerCapabilities getCapabilities(String format) {
        return KMLMapOutputFormat.KML_CAPABILITIES;
    }
}

