/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.response.v2_0;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.geoserver.config.GeoServer;
import org.geoserver.ows.Dispatcher;
import org.geoserver.ows.Request;
import org.geoserver.ows.util.ResponseUtils;
import org.geoserver.platform.Operation;
import org.geoserver.platform.ServiceException;
import org.geotools.wfs.v2_0.WFSConfiguration;
import org.geotools.xsd.Configuration;
import org.geotools.xsd.EMFUtils;
import org.geotools.xsd.Encoder;

public abstract class WFSResponse
extends org.geoserver.wfs.response.WFSResponse {
    public WFSResponse(GeoServer gs, Class<?> binding, Set<String> outputFormats) {
        super(gs, binding, outputFormats);
    }

    public WFSResponse(GeoServer gs, Class<?> binding, String outputFormat) {
        super(gs, binding, outputFormat);
    }

    public WFSResponse(GeoServer gs, Class<?> binding) {
        super(gs, binding);
    }

    public String getMimeType(Object value, Operation operation) throws ServiceException {
        return "text/xml";
    }

    public void write(Object value, OutputStream output, Operation operation) throws IOException, ServiceException {
        Encoder encoder = new Encoder((Configuration)new WFSConfiguration());
        encoder.setEncoding(Charset.forName(this.getInfo().getGeoServer().getSettings().getCharset()));
        encoder.setOmitXMLDeclaration(((Request)Dispatcher.REQUEST.get()).isSOAP());
        String baseURL = (String)EMFUtils.get((EObject)((EObject)operation.getParameters()[0]), (String)"baseUrl");
        encoder.setSchemaLocation("http://www.opengis.net/wfs/2.0", ResponseUtils.buildSchemaURL((String)baseURL, (String)"wfs/2.0/wfs.xsd"));
        this.encode(encoder, value, output, operation);
    }

    protected void encode(Encoder encoder, Object value, OutputStream output, Operation operation) throws IOException, ServiceException {
    }
}

