/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs;

import java.net.URI;
import net.opengis.wfs20.DescribeStoredQueriesResponseType;
import net.opengis.wfs20.DescribeStoredQueriesType;
import net.opengis.wfs20.Wfs20Factory;
import org.eclipse.emf.ecore.EObject;
import org.geoserver.wfs.StoredQuery;
import org.geoserver.wfs.StoredQueryProvider;
import org.geoserver.wfs.WFSException;
import org.geoserver.wfs.WFSInfo;

public class DescribeStoredQueries {
    WFSInfo wfs;
    StoredQueryProvider storedQueryProvider;

    public DescribeStoredQueries(WFSInfo wfs, StoredQueryProvider storedQueryProvider) {
        this.wfs = wfs;
        this.storedQueryProvider = storedQueryProvider;
    }

    public DescribeStoredQueriesResponseType run(DescribeStoredQueriesType request) throws WFSException {
        Wfs20Factory factory = Wfs20Factory.eINSTANCE;
        DescribeStoredQueriesResponseType response = factory.createDescribeStoredQueriesResponseType();
        if (request.getStoredQueryId().isEmpty()) {
            for (StoredQuery query : this.storedQueryProvider.listStoredQueries()) {
                this.describeStoredQuery(query, response);
            }
        } else {
            for (URI id : request.getStoredQueryId()) {
                StoredQuery query = this.storedQueryProvider.getStoredQuery(id.toString());
                if (query == null) {
                    WFSException exception = new WFSException((EObject)request, "No such stored query: " + id, "InvalidParameterValue");
                    exception.setLocator("STOREDQUERY_ID");
                    throw exception;
                }
                this.describeStoredQuery(query, response);
            }
        }
        return response;
    }

    void describeStoredQuery(StoredQuery query, DescribeStoredQueriesResponseType response) {
        response.getStoredQueryDescription().add((Object)query.getQuery());
    }
}

