/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.web.data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.markup.repeater.ReuseIfModelsEqualStrategy;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.geoserver.catalog.CoverageDimensionInfo;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.web.wicket.GeoServerDataProvider;
import org.geoserver.web.wicket.GeoServerTablePanel;
import org.geoserver.web.wicket.ParamResourceModel;
import org.geotools.api.coverage.SampleDimensionType;
import org.geotools.util.logging.Logging;

public class BandsPanel
extends Panel {
    static final Logger LOGGER = Logging.getLogger(BandsPanel.class);
    private GeoServerTablePanel<CoverageDimensionInfo> bands = new GeoServerTablePanel<CoverageDimensionInfo>("bands", (GeoServerDataProvider)new CoverageDimensionsProvider(), true){

        protected GeoServerTablePanel<CoverageDimensionInfo> getComponentForProperty(String id, IModel<CoverageDimensionInfo> itemModel, GeoServerDataProvider.Property<CoverageDimensionInfo> property) {
            return null;
        }
    };

    public BandsPanel(String id, CoverageInfo coverage) {
        super(id, (IModel)new Model((Serializable)coverage));
        this.bands.setFilterVisible(false);
        this.bands.setSortable(false);
        this.bands.getTopPager().setVisible(false);
        this.bands.getBottomPager().setVisible(false);
        this.bands.setOutputMarkupId(true);
        this.bands.setItemReuseStrategy(ReuseIfModelsEqualStrategy.getInstance());
        this.bands.setFilterable(false);
        this.bands.setSelectable(false);
        this.add(new Component[]{this.bands});
    }

    class CoverageDimensionsProvider
    extends GeoServerDataProvider<CoverageDimensionInfo> {
        CoverageDimensionsProvider() {
        }

        protected List<GeoServerDataProvider.Property<CoverageDimensionInfo>> getProperties() {
            ArrayList<GeoServerDataProvider.Property<CoverageDimensionInfo>> result = new ArrayList<GeoServerDataProvider.Property<CoverageDimensionInfo>>();
            result.add((GeoServerDataProvider.Property<CoverageDimensionInfo>)new GeoServerDataProvider.BeanProperty("band", "name"));
            result.add((GeoServerDataProvider.Property<CoverageDimensionInfo>)new GeoServerDataProvider.AbstractProperty<CoverageDimensionInfo>("dimensionType"){

                public Object getPropertyValue(CoverageDimensionInfo item) {
                    SampleDimensionType type = item.getDimensionType();
                    if (type == null) {
                        return "-";
                    }
                    String name = type.name();
                    try {
                        String key = BandsPanel.class.getSimpleName() + "." + name;
                        ParamResourceModel rm = new ParamResourceModel(key, null, new Object[0]);
                        return rm.getString();
                    }
                    catch (Exception e) {
                        return name;
                    }
                }
            });
            result.add((GeoServerDataProvider.Property<CoverageDimensionInfo>)new GeoServerDataProvider.AbstractProperty<CoverageDimensionInfo>("nullValues"){

                public Object getPropertyValue(CoverageDimensionInfo item) {
                    List values = item.getNullValues();
                    if (values == null || values.isEmpty()) {
                        return "-";
                    }
                    StringBuilder sb = new StringBuilder();
                    int size = values.size();
                    for (int i = 0; i < size; ++i) {
                        sb.append(values.get(i));
                        if (i >= size - 1) continue;
                        sb.append(", ");
                    }
                    return sb.toString();
                }
            });
            result.add((GeoServerDataProvider.Property<CoverageDimensionInfo>)new GeoServerDataProvider.BeanProperty("unit", "unit"));
            return result;
        }

        protected List<CoverageDimensionInfo> getItems() {
            CoverageInfo ci = (CoverageInfo)BandsPanel.this.getDefaultModelObject();
            if (ci.getDimensions() != null) {
                return ci.getDimensions();
            }
            return Collections.emptyList();
        }
    }
}

