/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.classbreaks;

import it.geosolutions.jaiext.classbreaks.Classification;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.util.LinkedList;
import java.util.ListIterator;
import javax.media.jai.PixelAccessor;
import javax.media.jai.ROI;
import javax.media.jai.StatisticsOpImage;
import javax.media.jai.UnpackedImageData;

public abstract class ClassBreaksOpImage
extends StatisticsOpImage {
    protected Integer numClasses;
    protected Double[][] extrema;
    protected Integer[] bands;
    protected Double noData;
    protected Boolean percentages;

    public ClassBreaksOpImage(RenderedImage image, Integer numClasses, Double[][] extrema, ROI roi, Integer[] bands, Integer xStart, Integer yStart, Integer xPeriod, Integer yPeriod, Double noData, Boolean percentages) {
        super(image, roi, xStart.intValue(), yStart.intValue(), xPeriod.intValue(), yPeriod.intValue());
        this.numClasses = numClasses;
        this.extrema = extrema;
        this.bands = bands;
        this.noData = noData;
        this.percentages = percentages;
    }

    protected String[] getStatisticsNames() {
        return new String[]{"Classification"};
    }

    public Object getProperty(String name) {
        Classification c;
        Object obj = this.properties.getProperty("Classification");
        if (obj == Image.UndefinedProperty && (c = this.preCalculate()) != null) {
            this.properties.setProperty("Classification", (Object)c);
        }
        return super.getProperty(name);
    }

    public void setProperty(String name, Object value) {
        if (value instanceof Classification) {
            Classification c = (Classification)value;
            for (int b = 0; b < this.bands.length; ++b) {
                this.postCalculate(c, b);
            }
        }
        super.setProperty(name, value);
    }

    protected Object createStatistics(String name) {
        if ("Classification".equals(name)) {
            return this.createClassification();
        }
        return Image.UndefinedProperty;
    }

    protected void accumulateStatistics(String name, Raster raster, Object obj) {
        LinkedList rectList;
        if (!"Classification".equals(name)) {
            return;
        }
        Classification c = (Classification)obj;
        SampleModel sampleModel = raster.getSampleModel();
        Rectangle bounds = raster.getBounds();
        if (this.roi == null) {
            rectList = new LinkedList();
            rectList.addLast(bounds);
        } else {
            rectList = this.roi.getAsRectangleList(bounds.x, bounds.y, bounds.width, bounds.height);
            if (rectList == null) {
                return;
            }
        }
        PixelAccessor accessor = new PixelAccessor(sampleModel, null);
        ListIterator iterator = rectList.listIterator(0);
        while (iterator.hasNext()) {
            Rectangle r = (Rectangle)iterator.next();
            int tx = r.x;
            int ty = r.y;
            r.x = this.startPosition(tx, this.xStart, this.xPeriod);
            r.y = this.startPosition(ty, this.yStart, this.yPeriod);
            r.width = tx + r.width - r.x;
            r.height = ty + r.height - r.y;
            if (r.width <= 0 || r.height <= 0) continue;
            switch (accessor.sampleType) {
                default: 
            }
            this.calculate(accessor, raster, r, this.xPeriod, this.yPeriod, c);
        }
    }

    void calculate(PixelAccessor accessor, Raster raster, Rectangle rect, int xPeriod, int yPeriod, Classification c) {
        UnpackedImageData uid = accessor.getPixels(raster, rect, 5, false);
        double[][] doubleData = uid.getDoubleData();
        int pixelStride = uid.pixelStride * xPeriod;
        int lineStride = uid.lineStride * yPeriod;
        int[] offsets = uid.bandOffsets;
        for (int i = 0; i < this.bands.length; ++i) {
            int b = this.bands[i];
            double[] data = doubleData[b];
            int lineOffset = offsets[b];
            for (int h = 0; h < rect.height; h += yPeriod) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                for (int w = 0; w < rect.width; w += xPeriod) {
                    double d = data[pixelOffset];
                    pixelOffset += pixelStride;
                    if (this.noData != null && this.noData.equals(d)) continue;
                    this.handleValue(d, c, i);
                }
            }
        }
    }

    protected abstract void handleValue(double var1, Classification var3, int var4);

    protected abstract Classification createClassification();

    protected Classification preCalculate() {
        return null;
    }

    protected abstract void postCalculate(Classification var1, int var2);

    private int startPosition(int pos, int start, int Period) {
        int t = (pos - start) % Period;
        return t == 0 ? pos : pos + (Period - t);
    }
}

