/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.georss;

import java.io.IOException;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.geotools.util.logging.Logging;
import org.geowebcache.georss.Entry;
import org.geowebcache.georss.GML31ParsingUtils;
import org.geowebcache.georss.GeoRSSParsingUtils;
import org.geowebcache.georss.GeoRSSReader;
import org.locationtech.jts.geom.Geometry;

class StaxGeoRSSReader
implements GeoRSSReader {
    private static final Logger LOGGER = Logging.getLogger((String)StaxGeoRSSReader.class.getName());
    private XMLStreamReader reader;
    private final GML31ParsingUtils gmlParser;

    public StaxGeoRSSReader(Reader feed) throws XMLStreamException, FactoryConfigurationError {
        XMLInputFactory factory = XMLInputFactory.newInstance();
        this.reader = factory.createXMLStreamReader(feed);
        this.reader.nextTag();
        this.reader.require(1, null, null);
        QName name = this.reader.getName();
        if (!"http://www.w3.org/2005/Atom".equals(name.getNamespaceURI()) && !"feed".equals(name.getLocalPart())) {
            throw new IllegalArgumentException("Document is not a GeoRSS feed. Root element: " + name);
        }
        this.findFirstEntry();
        this.gmlParser = new GML31ParsingUtils();
    }

    private void findFirstEntry() throws XMLStreamException {
        int event;
        while (!((event = this.reader.next()) == 8 || event == 1 && ATOM.entry.equals(this.reader.getName()))) {
        }
        if (event == 8) {
            this.reader.close();
            this.reader = null;
        }
    }

    @Override
    public Entry nextEntry() throws IOException {
        if (this.reader == null) {
            return null;
        }
        try {
            return this.parseEntry();
        }
        catch (XMLStreamException e) {
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
    }

    private Entry parseEntry() throws XMLStreamException {
        QName nextTag;
        this.reader.require(1, "http://www.w3.org/2005/Atom", ATOM.entry.getLocalPart());
        Entry entry = new Entry();
        LOGGER.finer("Parsing GeoRSS entry...");
        while (true) {
            this.reader.next();
            if (this.reader.isStartElement()) {
                QName name = this.reader.getName();
                this.parseEntryMember(this.reader, name, entry);
                continue;
            }
            if (this.reader.isEndElement() && ATOM.entry.equals(this.reader.getName())) break;
        }
        LOGGER.finer("Done parsing GeoRSS entry.");
        this.reader.require(2, "http://www.w3.org/2005/Atom", ATOM.entry.getLocalPart());
        while (!((nextTag = GeoRSSParsingUtils.nextTag(this.reader)) == null || this.reader.isStartElement() && nextTag.equals(ATOM.entry))) {
        }
        if (8 == this.reader.getEventType()) {
            this.reader.close();
            this.reader = null;
        }
        return entry;
    }

    private void parseEntryMember(XMLStreamReader reader, QName memberName, Entry entry) throws XMLStreamException {
        reader.require(1, memberName.getNamespaceURI(), memberName.getLocalPart());
        if (ATOM.id.equals(memberName)) {
            String id = GeoRSSParsingUtils.text(reader);
            entry.setId(id);
        } else if (ATOM.link.equals(memberName)) {
            String uri = GeoRSSParsingUtils.text(reader);
            try {
                URI link = new URI(uri);
                entry.setLink(link);
            }
            catch (URISyntaxException e) {
                LOGGER.info("Feed contains illegal 'link' element content:" + uri);
            }
        } else if (ATOM.title.equals(memberName)) {
            String title = GeoRSSParsingUtils.text(reader);
            entry.setTitle(title);
        } else if (ATOM.subtitle.equals(memberName)) {
            String subtitle = GeoRSSParsingUtils.text(reader);
            entry.setSubtitle(subtitle);
        } else if (ATOM.updated.equals(memberName)) {
            String upd = GeoRSSParsingUtils.text(reader);
            if (upd != null && upd.length() > 0) {
                entry.setUpdated(upd);
            }
        } else if (GEORSS.where.equals(memberName)) {
            QName nextTag = GeoRSSParsingUtils.nextTag(reader);
            if (reader.isStartElement() && "http://www.opengis.net/gml".equals(nextTag.getNamespaceURI())) {
                Geometry where = this.geometry(reader);
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.finer("Got geometry from feed: " + where);
                }
                entry.setWhere(where);
            }
        }
        GeoRSSParsingUtils.consume(reader, memberName);
        reader.require(2, memberName.getNamespaceURI(), memberName.getLocalPart());
    }

    private Geometry geometry(XMLStreamReader reader) throws XMLStreamException {
        reader.require(1, "http://www.opengis.net/gml", null);
        QName name = reader.getName();
        Geometry geometry = this.gmlParser.parseGeometry(reader);
        reader.require(2, name.getNamespaceURI(), name.getLocalPart());
        return geometry;
    }

    private static final class GEORSS {
        public static final String GEORSS_NSURI = "http://www.georss.org/georss";
        public static final QName where = new QName("http://www.georss.org/georss", "where");

        private GEORSS() {
        }
    }

    private static final class ATOM {
        public static final String NSURI = "http://www.w3.org/2005/Atom";
        public static final QName feed = new QName("http://www.w3.org/2005/Atom", "feed");
        public static final QName title = new QName("http://www.w3.org/2005/Atom", "title");
        public static final QName subtitle = new QName("http://www.w3.org/2005/Atom", "subtitle");
        public static final QName updated = new QName("http://www.w3.org/2005/Atom", "updated");
        public static final QName link = new QName("http://www.w3.org/2005/Atom", "link");
        public static final QName summary = new QName("http://www.w3.org/2005/Atom", "summary");
        public static final QName author = new QName("http://www.w3.org/2005/Atom", "author");
        public static final QName name = new QName("http://www.w3.org/2005/Atom", "name");
        public static final QName email = new QName("http://www.w3.org/2005/Atom", "email");
        public static final QName id = new QName("http://www.w3.org/2005/Atom", "id");
        public static final QName entry = new QName("http://www.w3.org/2005/Atom", "entry");

        private ATOM() {
        }
    }
}

