/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.georss;

import java.util.ArrayList;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.geowebcache.georss.GeoRSSParsingUtils;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

class GML31ParsingUtils {
    private final GeometryFactory geomFac;

    public GML31ParsingUtils() {
        this(new GeometryFactory());
    }

    public GML31ParsingUtils(GeometryFactory gFac) {
        this.geomFac = gFac;
    }

    public Geometry parseGeometry(XMLStreamReader reader) throws XMLStreamException {
        Point geom;
        reader.require(1, "http://www.opengis.net/gml", null);
        QName startingGeometryTagName = reader.getName();
        int dimension = this.crsDimension(reader, 2);
        if (GML.Point.equals(startingGeometryTagName)) {
            geom = this.parsePoint(reader, dimension);
        } else if (GML.LineString.equals(startingGeometryTagName)) {
            geom = this.parseLineString(reader, dimension);
        } else if (GML.Polygon.equals(startingGeometryTagName)) {
            geom = this.parsePolygon(reader, dimension);
        } else if (GML.MultiPoint.equals(startingGeometryTagName)) {
            geom = this.parseMultiPoint(reader, dimension);
        } else if (GML.MultiLineString.equals(startingGeometryTagName)) {
            geom = this.parseMultiLineString(reader, dimension);
        } else if (GML.MultiSurface.equals(startingGeometryTagName)) {
            geom = this.parseMultiSurface(reader, dimension);
        } else if (GML.MultiPolygon.equals(startingGeometryTagName)) {
            geom = this.parseMultiPolygon(reader, dimension);
        } else {
            throw new IllegalStateException("Unrecognized geometry element " + startingGeometryTagName);
        }
        reader.require(2, startingGeometryTagName.getNamespaceURI(), startingGeometryTagName.getLocalPart());
        return geom;
    }

    private Geometry parseMultiPoint(XMLStreamReader reader, int dimension) throws XMLStreamException {
        GeoRSSParsingUtils.nextTag(reader);
        QName memberTag = reader.getName();
        ArrayList<Point> points = new ArrayList<Point>(4);
        if (GML.pointMembers.equals(memberTag)) {
            while (true) {
                GeoRSSParsingUtils.nextTag(reader);
                if (2 == reader.getEventType() && GML.pointMembers.equals(reader.getName())) break;
                Point p = this.parsePoint(reader, dimension);
                points.add(p);
            }
            GeoRSSParsingUtils.nextTag(reader);
        } else if (GML.pointMember.equals(memberTag)) {
            do {
                GeoRSSParsingUtils.nextTag(reader);
                reader.require(1, "http://www.opengis.net/gml", GML.Point.getLocalPart());
                Point p = this.parsePoint(reader, dimension);
                points.add(p);
                GeoRSSParsingUtils.nextTag(reader);
                reader.require(2, "http://www.opengis.net/gml", GML.pointMember.getLocalPart());
                GeoRSSParsingUtils.nextTag(reader);
            } while (2 != reader.getEventType() || !GML.MultiPoint.equals(reader.getName()));
        }
        reader.require(2, "http://www.opengis.net/gml", GML.MultiPoint.getLocalPart());
        MultiPoint geom = this.geomFac.createMultiPoint(points.toArray(new Point[points.size()]));
        return geom;
    }

    private MultiLineString parseMultiLineString(XMLStreamReader reader, int dimension) throws XMLStreamException {
        reader.require(1, "http://www.opengis.net/gml", GML.MultiLineString.getLocalPart());
        ArrayList<LineString> lines = new ArrayList<LineString>(2);
        while (true) {
            GeoRSSParsingUtils.nextTag(reader);
            if (2 == reader.getEventType() && GML.MultiLineString.equals(reader.getName())) break;
            reader.require(1, "http://www.opengis.net/gml", GML.lineStringMember.getLocalPart());
            GeoRSSParsingUtils.nextTag(reader);
            reader.require(1, "http://www.opengis.net/gml", GML.LineString.getLocalPart());
            LineString line = this.parseLineString(reader, dimension);
            lines.add(line);
            GeoRSSParsingUtils.nextTag(reader);
            reader.require(2, "http://www.opengis.net/gml", GML.lineStringMember.getLocalPart());
        }
        reader.require(2, "http://www.opengis.net/gml", GML.MultiLineString.getLocalPart());
        MultiLineString geom = this.geomFac.createMultiLineString(lines.toArray(new LineString[lines.size()]));
        return geom;
    }

    private Geometry parseMultiSurface(XMLStreamReader reader, int dimension) throws XMLStreamException {
        GeoRSSParsingUtils.nextTag(reader);
        QName memberTag = reader.getName();
        ArrayList<Polygon> polygons = new ArrayList<Polygon>(2);
        if (GML.surfaceMembers.equals(memberTag)) {
            while (true) {
                GeoRSSParsingUtils.nextTag(reader);
                if (2 == reader.getEventType() && GML.surfaceMembers.equals(reader.getName())) break;
                Polygon p = this.parsePolygon(reader, dimension);
                polygons.add(p);
            }
            GeoRSSParsingUtils.nextTag(reader);
        } else if (GML.surfaceMember.equals(memberTag)) {
            do {
                GeoRSSParsingUtils.nextTag(reader);
                Polygon p = this.parsePolygon(reader, dimension);
                polygons.add(p);
                GeoRSSParsingUtils.nextTag(reader);
                reader.require(2, "http://www.opengis.net/gml", GML.surfaceMember.getLocalPart());
                GeoRSSParsingUtils.nextTag(reader);
            } while (2 != reader.getEventType() || !GML.MultiSurface.equals(reader.getName()));
        }
        reader.require(2, "http://www.opengis.net/gml", GML.MultiSurface.getLocalPart());
        MultiPolygon geom = this.geomFac.createMultiPolygon(polygons.toArray(new Polygon[polygons.size()]));
        return geom;
    }

    private Geometry parseMultiPolygon(XMLStreamReader reader, int dimension) throws XMLStreamException {
        reader.require(1, "http://www.opengis.net/gml", GML.MultiPolygon.getLocalPart());
        ArrayList<Polygon> polygons = new ArrayList<Polygon>(2);
        GeoRSSParsingUtils.nextTag(reader);
        do {
            reader.require(1, "http://www.opengis.net/gml", GML.polygonMember.getLocalPart());
            GeoRSSParsingUtils.nextTag(reader);
            reader.require(1, "http://www.opengis.net/gml", GML.Polygon.getLocalPart());
            Polygon p = this.parsePolygon(reader, dimension);
            polygons.add(p);
            GeoRSSParsingUtils.nextTag(reader);
            reader.require(2, "http://www.opengis.net/gml", GML.polygonMember.getLocalPart());
            GeoRSSParsingUtils.nextTag(reader);
        } while (2 != reader.getEventType() || !GML.MultiPolygon.equals(reader.getName()));
        reader.require(2, "http://www.opengis.net/gml", GML.MultiPolygon.getLocalPart());
        MultiPolygon geom = this.geomFac.createMultiPolygon(polygons.toArray(new Polygon[polygons.size()]));
        return geom;
    }

    private Polygon parsePolygon(XMLStreamReader reader, int dimension) throws XMLStreamException {
        ArrayList<LinearRing> holes = null;
        GeoRSSParsingUtils.nextTag(reader);
        reader.require(1, "http://www.opengis.net/gml", GML.exterior.getLocalPart());
        GeoRSSParsingUtils.nextTag(reader);
        LinearRing shell = this.parseLinearRing(reader, dimension);
        GeoRSSParsingUtils.nextTag(reader);
        reader.require(2, "http://www.opengis.net/gml", GML.exterior.getLocalPart());
        GeoRSSParsingUtils.nextTag(reader);
        if (GML.interior.equals(reader.getName())) {
            holes = new ArrayList<LinearRing>(2);
            do {
                GeoRSSParsingUtils.nextTag(reader);
                LinearRing hole = this.parseLinearRing(reader, dimension);
                holes.add(hole);
                GeoRSSParsingUtils.nextTag(reader);
                reader.require(2, "http://www.opengis.net/gml", GML.interior.getLocalPart());
                GeoRSSParsingUtils.nextTag(reader);
            } while (2 != reader.getEventType());
            reader.require(2, "http://www.opengis.net/gml", GML.Polygon.getLocalPart());
        }
        reader.require(2, "http://www.opengis.net/gml", GML.Polygon.getLocalPart());
        LinearRing[] holesArray = null;
        if (holes != null) {
            holesArray = holes.toArray(new LinearRing[holes.size()]);
        }
        Polygon geom = this.geomFac.createPolygon(shell, holesArray);
        return geom;
    }

    private LinearRing parseLinearRing(XMLStreamReader reader, int dimension) throws XMLStreamException {
        Coordinate[] shellCoords;
        reader.require(1, "http://www.opengis.net/gml", GML.LinearRing.getLocalPart());
        GeoRSSParsingUtils.nextTag(reader);
        QName tagName = reader.getName();
        if (GML.pos.equals(tagName)) {
            int eventType;
            ArrayList<Coordinate> coords = new ArrayList<Coordinate>();
            do {
                Coordinate[] point = this.parseCoordListContent(reader, dimension);
                coords.add(point[0]);
                GeoRSSParsingUtils.nextTag(reader);
                tagName = reader.getName();
            } while ((eventType = reader.getEventType()) == 1 && GML.pos.equals(tagName));
            shellCoords = coords.toArray(new Coordinate[coords.size()]);
        } else if (GML.posList.equals(tagName)) {
            shellCoords = this.parseCoordListContent(reader, dimension);
            GeoRSSParsingUtils.nextTag(reader);
        } else {
            throw new IllegalStateException("Expected posList or pos inside LinearRing: " + tagName);
        }
        reader.require(2, "http://www.opengis.net/gml", GML.LinearRing.getLocalPart());
        LinearRing linearRing = this.geomFac.createLinearRing(shellCoords);
        return linearRing;
    }

    private LineString parseLineString(XMLStreamReader reader, int dimension) throws XMLStreamException {
        GeoRSSParsingUtils.nextTag(reader);
        reader.require(1, "http://www.opengis.net/gml", GML.posList.getLocalPart());
        Coordinate[] coords = this.parseCoordListContent(reader, dimension);
        LineString geom = this.geomFac.createLineString(coords);
        GeoRSSParsingUtils.nextTag(reader);
        reader.require(2, "http://www.opengis.net/gml", GML.LineString.getLocalPart());
        return geom;
    }

    private Point parsePoint(XMLStreamReader reader, int dimension) throws XMLStreamException {
        reader.require(1, "http://www.opengis.net/gml", GML.Point.getLocalPart());
        GeoRSSParsingUtils.nextTag(reader);
        reader.require(1, "http://www.opengis.net/gml", GML.pos.getLocalPart());
        Coordinate[] coords = this.parseCoordListContent(reader, dimension);
        Point geom = this.geomFac.createPoint(coords[0]);
        GeoRSSParsingUtils.consume(reader, GML.Point);
        reader.require(2, "http://www.opengis.net/gml", GML.Point.getLocalPart());
        return geom;
    }

    private int crsDimension(XMLStreamReader reader, int defaultValue) {
        String srsDimension = reader.getAttributeValue(null, "srsDimension");
        if (srsDimension == null) {
            return defaultValue;
        }
        int dimension = Integer.valueOf(srsDimension);
        return dimension;
    }

    private Coordinate[] parseCoordListContent(XMLStreamReader reader, int dimension) throws XMLStreamException {
        reader.require(1, null, null);
        QName tagName = reader.getName();
        dimension = this.crsDimension(reader, dimension);
        String rawTextValue = GeoRSSParsingUtils.text(reader);
        Coordinate[] coords = this.toCoordList(rawTextValue, dimension);
        GeoRSSParsingUtils.consume(reader, tagName);
        return coords;
    }

    private Coordinate[] toCoordList(String rawTextValue, int dimension) {
        rawTextValue = rawTextValue.trim();
        rawTextValue = rawTextValue.replaceAll("\n", " ");
        String[] split = (rawTextValue = rawTextValue.replaceAll("\r", " ")).trim().split(" +");
        int ordinatesLength = split.length;
        if (ordinatesLength % dimension != 0) {
            throw new IllegalArgumentException("Number of ordinates (" + ordinatesLength + ") does not match crs dimension: " + dimension);
        }
        int nCoords = ordinatesLength / dimension;
        Coordinate[] coords = new Coordinate[nCoords];
        int currCoordIdx = 0;
        for (int i = 0; i < ordinatesLength; i += dimension) {
            Coordinate coord;
            double x = Double.valueOf(split[i]);
            double y = Double.valueOf(split[i + 1]);
            if (dimension > 2) {
                double z = Double.valueOf(split[i + 2]);
                coord = new Coordinate(x, y, z);
            } else {
                coord = new Coordinate(x, y);
            }
            coords[currCoordIdx] = coord;
            ++currCoordIdx;
        }
        return coords;
    }

    public static final class GML {
        public static final String GML_NS_URI = "http://www.opengis.net/gml";
        public static final QName Point = new QName("http://www.opengis.net/gml", "Point");
        public static final QName LineString = new QName("http://www.opengis.net/gml", "LineString");
        public static final QName Polygon = new QName("http://www.opengis.net/gml", "Polygon");
        public static final QName MultiPoint = new QName("http://www.opengis.net/gml", "MultiPoint");
        public static final QName MultiLineString = new QName("http://www.opengis.net/gml", "MultiLineString");
        public static final QName MultiSurface = new QName("http://www.opengis.net/gml", "MultiSurface");
        public static final QName MultiPolygon = new QName("http://www.opengis.net/gml", "MultiPolygon");
        public static final QName pointMembers = new QName("http://www.opengis.net/gml", "pointMembers");
        public static final QName pointMember = new QName("http://www.opengis.net/gml", "pointMember");
        public static final QName lineStringMember = new QName("http://www.opengis.net/gml", "lineStringMember");
        public static final QName surfaceMembers = new QName("http://www.opengis.net/gml", "surfaceMembers");
        public static final QName surfaceMember = new QName("http://www.opengis.net/gml", "surfaceMember");
        public static final QName polygonMember = new QName("http://www.opengis.net/gml", "polygonMember");
        public static final QName exterior = new QName("http://www.opengis.net/gml", "exterior");
        public static final QName interior = new QName("http://www.opengis.net/gml", "interior");
        public static final QName LinearRing = new QName("http://www.opengis.net/gml", "LinearRing");
        public static final QName pos = new QName("http://www.opengis.net/gml", "pos");
        public static final QName posList = new QName("http://www.opengis.net/gml", "posList");
    }
}

