/*
 * Decompiled with CFR 0.152.
 */
package wicketdnd.util;

import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.protocol.http.PageExpiredException;
import org.apache.wicket.util.visit.IVisit;
import org.apache.wicket.util.visit.IVisitor;

public class MarkupIdVisitor
implements IVisitor<Component, Component> {
    private final String id;

    public MarkupIdVisitor(String id) {
        if (id == null) {
            throw new IllegalArgumentException("id must not be null");
        }
        this.id = id;
    }

    public void component(Component component, IVisit<Component> visit) {
        if (this.id.equals(component.getMarkupId(false))) {
            visit.stop((Object)component);
        }
    }

    public static Component getComponent(MarkupContainer container, String id) {
        if (id.equals(container.getMarkupId(false))) {
            return container;
        }
        Component component = (Component)container.visitChildren((IVisitor)new MarkupIdVisitor(id));
        if (component == null) {
            throw new PageExpiredException("No component with markup id " + id);
        }
        return component;
    }
}

