/*
 * Decompiled with CFR 0.152.
 */
package wicketdnd.test;

import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.behavior.AbstractAjaxBehavior;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.protocol.http.mock.MockHttpServletRequest;
import org.apache.wicket.util.tester.WicketTester;
import wicketdnd.DragSource;
import wicketdnd.DropTarget;
import wicketdnd.Location;
import wicketdnd.Operation;

public class DnDTester {
    private WicketTester tester;

    public DnDTester(WicketTester tester) {
        this.tester = tester;
    }

    public void executeDrag(Component dropTarget, Location location) {
        this.executeDrag(this.getBehavior(dropTarget, DropTarget.class), location);
    }

    public void executeDrag(DropTarget dropTarget, Location location) {
        MockHttpServletRequest request = this.tester.getRequest();
        request.setParameter("phase", "drag");
        request.setParameter("component", location.getComponent().getMarkupId());
        request.setParameter("anchor", location.getAnchor().name());
        this.tester.executeBehavior((AbstractAjaxBehavior)dropTarget);
    }

    public void executeDrop(Component dropTarget, Location location, Operation operation, Component dragSource, Component drag) {
        this.executeDrop(this.getBehavior(dropTarget, DropTarget.class), location, operation, this.getBehavior(dragSource, DragSource.class), drag);
    }

    public void executeDrop(DropTarget dropTarget, Location location, Operation operation, DragSource dragSource, Component drag) {
        MockHttpServletRequest request = this.tester.getRequest();
        request.setParameter("phase", "drop");
        request.setParameter("component", location.getComponent().getMarkupId());
        request.setParameter("anchor", location.getAnchor().name());
        request.setParameter("operation", operation.name());
        request.setParameter("path", dragSource.getPath());
        request.setParameter("behavior", "" + dragSource.getBehaviorId());
        request.setParameter("drag", drag.getMarkupId());
        this.tester.executeBehavior((AbstractAjaxBehavior)dropTarget);
    }

    private <T extends Behavior> T getBehavior(Component component, Class<T> clazz) {
        List behaviors = component.getBehaviors(clazz);
        if (behaviors.size() == 0) {
            throw new WicketRuntimeException("no behavior of type " + clazz.getName());
        }
        if (behaviors.size() > 1) {
            throw new WicketRuntimeException("multiple behaviors of type " + clazz.getName());
        }
        return (T)((Behavior)behaviors.get(0));
    }
}

