/*
 * Decompiled with CFR 0.152.
 */
package wicketdnd;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.ajax.AbstractDefaultAjaxBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.resource.ResourceReference;
import wicketdnd.Anchor;
import wicketdnd.DragSource;
import wicketdnd.Location;
import wicketdnd.Operation;
import wicketdnd.Reject;
import wicketdnd.Transfer;
import wicketdnd.util.CollectionFormattable;
import wicketdnd.util.MarkupIdVisitor;

public class DropTarget
extends AbstractDefaultAjaxBehavior {
    private static final long serialVersionUID = 1L;
    private String centerSelector = "undefined";
    private String topSelector = "undefined";
    private String bottomSelector = "undefined";
    private String leftSelector = "undefined";
    private String rightSelector = "undefined";
    private Set<Operation> operations;

    public DropTarget(Operation ... operations) {
        this(Operation.of(operations));
    }

    public DropTarget(Set<Operation> operations) {
        this.operations = operations;
    }

    public String[] getTypes() {
        return new String[]{""};
    }

    public DropTarget dropCenter(String selector) {
        this.centerSelector = selector;
        return this;
    }

    public DropTarget dropTop(String selector) {
        this.topSelector = selector;
        return this;
    }

    public DropTarget dropRight(String selector) {
        this.rightSelector = selector;
        return this;
    }

    public DropTarget dropBottom(String selector) {
        this.bottomSelector = selector;
        return this;
    }

    public DropTarget dropLeft(String selector) {
        this.leftSelector = selector;
        return this;
    }

    public DropTarget dropTopAndBottom(String selector) {
        this.topSelector = selector;
        this.bottomSelector = selector;
        return this;
    }

    public DropTarget dropLeftAndRight(String selector) {
        this.leftSelector = selector;
        this.rightSelector = selector;
        return this;
    }

    public final void renderHead(Component component, IHeaderResponse response) {
        super.renderHead(component, response);
        this.renderDropHead(response);
    }

    private void renderDropHead(IHeaderResponse response) {
        response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)Transfer.JS));
        String id = this.getComponent().getMarkupId();
        String initJS = String.format("new wicketdnd.dropTarget('%s',%s,%s,%s,{'center':'%s','top':'%s','right':'%s','bottom':'%s','left':'%s'});", id, this.renderAjaxAttributes(this.getComponent()), new CollectionFormattable(this.getOperations()), new CollectionFormattable(this.getTypes()), this.centerSelector, this.topSelector, this.rightSelector, this.bottomSelector, this.leftSelector);
        response.render((HeaderItem)OnDomReadyHeaderItem.forScript((CharSequence)initJS));
    }

    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        tag.append("class", (CharSequence)"dnd-drop-target", " ");
    }

    public Set<Operation> getOperations() {
        return this.operations;
    }

    protected final void respond(AjaxRequestTarget target) {
        Request request = this.getComponent().getRequest();
        String phase = this.readPhase(request);
        Location location = this.readLocation(request);
        if ("drag".equals(phase)) {
            this.onDrag(target, location);
        } else if ("drop".equals(phase)) {
            try {
                DragSource source = DragSource.read(this.getComponent().getPage(), request);
                Transfer transfer = this.readTransfer(request, source);
                source.beforeDrop(request, transfer);
                this.onDrop(target, transfer, location);
                source.afterDrop(target, transfer);
            }
            catch (Reject reject) {
                this.onRejected(target);
            }
        } else {
            throw new WicketRuntimeException("unkown phase '" + phase + "'");
        }
    }

    private String readPhase(Request request) {
        return request.getRequestParameters().getParameterValue("phase").toString();
    }

    private Transfer readTransfer(Request request, DragSource source) {
        Operation operation = Operation.valueOf(request.getRequestParameters().getParameterValue("operation").toString());
        if (!this.hasOperation(operation) || !source.hasOperation(operation)) {
            throw new Reject();
        }
        ArrayList<String> transfers = new ArrayList<String>();
        for (String transfer : this.getTypes()) {
            transfers.add(transfer);
        }
        transfers.retainAll(Arrays.asList(source.getTypes()));
        if (transfers.size() == 0) {
            throw new Reject();
        }
        return new Transfer((String)transfers.get(0), operation);
    }

    final boolean hasOperation(Operation operation) {
        return this.getOperations().contains((Object)operation);
    }

    private Location readLocation(Request request) {
        String id = this.getComponent().getRequest().getRequestParameters().getParameterValue("component").toString();
        Component component = MarkupIdVisitor.getComponent((MarkupContainer)this.getComponent(), id);
        Anchor anchor = Anchor.valueOf(request.getRequestParameters().getParameterValue("anchor").toString());
        return new Location(component, anchor);
    }

    public void onDrag(AjaxRequestTarget target, Location location) {
    }

    public void onDrop(AjaxRequestTarget target, Transfer transfer, Location location) throws Reject {
        transfer.reject();
    }

    public void onRejected(AjaxRequestTarget target) {
    }
}

