/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.map;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.ServiceException;
import org.geoserver.wms.GetMapOutputFormat;
import org.geoserver.wms.GetMapRequest;
import org.geoserver.wms.MapProducerCapabilities;
import org.geoserver.wms.WMSMapContent;
import org.geoserver.wms.map.AbstractOpenLayersMapOutputFormat;
import org.geoserver.wms.map.OpenLayers2MapOutputFormat;
import org.geoserver.wms.map.OpenLayers3MapOutputFormat;
import org.geoserver.wms.map.RawMap;
import org.geotools.util.Converters;

public class OpenLayersMapOutputFormat
implements GetMapOutputFormat {
    public static final String MIME_TYPE = "text/html; subtype=openlayers";
    public static final String ENABLE_OL3 = "ENABLE_OL3";
    private static final Set<String> OUTPUT_FORMATS = new HashSet<String>(Arrays.asList("application/openlayers", "openlayers", "text/html; subtype=openlayers"));
    private final OpenLayers2MapOutputFormat ol2Format;
    private final OpenLayers3MapOutputFormat ol3Format;

    public OpenLayersMapOutputFormat(OpenLayers2MapOutputFormat ol2Format, OpenLayers3MapOutputFormat ol3Format) {
        this.ol2Format = ol2Format;
        this.ol3Format = ol3Format;
    }

    @Override
    public Set<String> getOutputFormatNames() {
        return OUTPUT_FORMATS;
    }

    @Override
    public String getMimeType() {
        return MIME_TYPE;
    }

    @Override
    public MapProducerCapabilities getCapabilities(String format) {
        return AbstractOpenLayersMapOutputFormat.CAPABILITIES;
    }

    @Override
    public RawMap produceMap(WMSMapContent mapContent) throws ServiceException, IOException {
        if (this.isOL3Enabled(mapContent) && this.ol3Format.browserSupportsOL3(mapContent)) {
            return this.ol3Format.produceMap(mapContent);
        }
        return this.ol2Format.produceMap(mapContent);
    }

    protected boolean isOL3Enabled(WMSMapContent mapContent) {
        GetMapRequest req = mapContent.getRequest();
        Object enableOL3 = Converters.convert((Object)req.getFormatOptions().get(ENABLE_OL3), Boolean.class);
        if (enableOL3 == null) {
            enableOL3 = GeoServerExtensions.getProperty((String)ENABLE_OL3);
        }
        return enableOL3 == null || (Boolean)Converters.convert((Object)enableOL3, Boolean.class) != false;
    }
}

