/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.map;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.geoserver.ows.Response;
import org.geoserver.ows.util.OwsUtils;
import org.geoserver.platform.Operation;
import org.geoserver.platform.ServiceException;
import org.geoserver.wms.GetMapRequest;
import org.geoserver.wms.WebMap;
import org.springframework.util.Assert;

public abstract class AbstractMapResponse
extends Response {
    protected AbstractMapResponse(Class<? extends WebMap> responseBinding, String mime) {
        this(responseBinding, new String[]{mime});
    }

    protected AbstractMapResponse(Class<? extends WebMap> responseBinding, String[] outputFormats) {
        this(responseBinding, (Set<String>)(outputFormats == null ? Collections.emptySet() : new HashSet<String>(Arrays.asList(outputFormats))));
    }

    protected AbstractMapResponse(Class<? extends WebMap> responseBinding, Set<String> outputFormats) {
        super(responseBinding, AbstractMapResponse.caseInsensitiveOutputFormats(outputFormats));
    }

    private static Set<String> caseInsensitiveOutputFormats(Set<String> outputFormats) {
        if (outputFormats == null) {
            return Collections.emptySet();
        }
        TreeSet<String> caseInsensitiveFormats = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        caseInsensitiveFormats.addAll(outputFormats);
        return caseInsensitiveFormats;
    }

    protected AbstractMapResponse() {
        this(null, (String[])null);
    }

    public String getMimeType(Object value, Operation operation) throws ServiceException {
        Assert.isInstanceOf(WebMap.class, (Object)value);
        return ((WebMap)value).getMimeType();
    }

    public String getAttachmentFileName(Object value, Operation operation) {
        Assert.isInstanceOf(WebMap.class, (Object)value);
        return ((WebMap)value).getAttachmentFileName();
    }

    public String getPreferredDisposition(Object value, Operation operation) {
        Assert.isInstanceOf(WebMap.class, (Object)value);
        return ((WebMap)value).getDisposition();
    }

    public boolean canHandle(Operation operation) {
        Object[] parameters = operation.getParameters();
        GetMapRequest request = (GetMapRequest)OwsUtils.parameter((Object[])parameters, GetMapRequest.class);
        if (request == null) {
            return false;
        }
        Set outputFormats = this.getOutputFormats();
        if (outputFormats.isEmpty()) {
            return true;
        }
        String outputFormat = request.getFormat();
        boolean match = outputFormats.contains(outputFormat);
        return match;
    }

    public String[][] getHeaders(Object value, Operation operation) throws ServiceException {
        Assert.isInstanceOf(WebMap.class, (Object)value);
        WebMap map = (WebMap)value;
        String[][] responseHeaders = map.getResponseHeaders();
        return responseHeaders;
    }
}

