/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.legendgraphic;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import org.apache.commons.collections4.map.CaseInsensitiveMap;
import org.geoserver.wms.legendgraphic.Cell;
import org.geoserver.wms.legendgraphic.ImageList;
import org.geoserver.wms.legendgraphic.ImageQueue;
import org.geoserver.wms.legendgraphic.LegendMerger;
import org.geoserver.wms.legendgraphic.LegendUtils;
import org.geoserver.wms.legendgraphic.PackagedUtils;
import org.geoserver.wms.legendgraphic.Tally;
import org.geoserver.wms.map.ImageUtils;
import org.geotools.api.style.ColorMapEntry;
import org.geotools.api.style.SelectedChannelType;

public class ColorMapLegendCreator {
    private ColorMapType colorMapType;
    private boolean extended = false;
    private boolean transparent;
    private Dimension requestedDimension;
    private Color backgroundColor;
    private Font labelFont;
    private Color labelFontColor;
    private final Queue<Cell.ColorMapEntryLegendBuilder> bodyRows = new LinkedList<Cell.ColorMapEntryLegendBuilder>();
    private final List<Cell> footerRows = new ArrayList<Cell>();
    private LegendUtils.HAlign hAlign = LegendUtils.HAlign.LEFT;
    private LegendUtils.VAlign vAlign = LegendUtils.VAlign.BOTTOM;
    private double vMarginPercentage = 0.015f;
    private double hMarginPercentage = 0.015f;
    private double rowMarginPercentage = 0.15f;
    private double columnMarginPercentage = 0.15f;
    private boolean absoluteMargins = true;
    private Color borderColor = LegendUtils.DEFAULT_BORDER_COLOR;
    private boolean borderLabel = false;
    private boolean borderRule = false;
    private double margin;
    private double rowH;
    private double colorW;
    private double ruleW;
    private double labelW;
    private double footerW;
    private String grayChannelName = "1";
    private boolean fontAntiAliasing = true;
    private boolean forceRule = false;
    private BufferedImage legend;
    private boolean border = false;
    private double dx;
    private double dy;
    private boolean bandInformation;
    private LegendUtils.LegendLayout layout;
    private int columnHeight;
    private int rowWidth;
    private int columns;
    private int rows;
    private boolean wrap = false;

    public ColorMapLegendCreator(Builder builder) {
        this.backgroundColor = builder.backgroundColor;
        this.bodyRows.addAll(builder.bodyRows);
        this.border = builder.border;
        this.borderColor = builder.borderColor;
        this.borderLabel = builder.borderLabel;
        this.borderRule = builder.borderRule;
        this.colorMapType = builder.colorMapType;
        this.columnMarginPercentage = builder.columnMarginPercentage;
        this.extended = builder.extended;
        this.fontAntiAliasing = builder.fontAntiAliasing;
        this.forceRule = builder.forceRule;
        this.grayChannelName = builder.grayChannelName;
        this.hAlign = builder.hAlign;
        this.vAlign = builder.vAlign;
        this.labelFont = builder.labelFont;
        this.labelFontColor = builder.labelFontColor;
        this.rowMarginPercentage = builder.rowMarginPercentage;
        this.columnMarginPercentage = builder.columnMarginPercentage;
        this.absoluteMargins = builder.absoluteMargins;
        this.hMarginPercentage = builder.hMarginPercentage;
        this.vMarginPercentage = builder.vMarginPercentage;
        this.requestedDimension = (Dimension)builder.requestedDimension.clone();
        this.transparent = builder.transparent;
        this.bandInformation = builder.bandInformation;
        this.layout = builder.layout;
        this.rowWidth = builder.rowWidth;
        this.rows = builder.rows;
        this.columnHeight = builder.columnHeight;
        this.columns = builder.columns;
        this.wrap = builder.isWrap();
    }

    public synchronized BufferedImage getLegend(Tally tally) {
        if (this.legend == null) {
            this.init();
            ImageQueue body = this.createBody(tally);
            if (this.bandInformation) {
                ImageQueue footer = this.createFooter(tally);
                body.addAll(footer);
            }
            this.legend = this.mergeRows(body, tally);
        }
        return this.legend;
    }

    private void init() {
        BufferedImage image = ImageUtils.createImage(1, 1, null, this.transparent);
        HashMap<RenderingHints.Key, Object> hintsMap = new HashMap<RenderingHints.Key, Object>();
        Graphics2D graphics = ImageUtils.prepareTransparency(this.transparent, this.backgroundColor, image, hintsMap);
        this.rowH = 0.0;
        this.colorW = 0.0;
        this.ruleW = 0.0;
        this.labelW = 0.0;
        this.cycleBodyRows(graphics);
        if (this.bandInformation) {
            String bandNameString = "Band selection is " + this.grayChannelName;
            this.footerRows.add(new Cell.TextManager(bandNameString, this.vAlign, this.hAlign, this.backgroundColor, this.requestedDimension, this.labelFont, this.labelFontColor, this.fontAntiAliasing, this.borderColor, this.wrap));
            String colorMapTypeString = "ColorMap type is " + this.colorMapType.toString();
            this.footerRows.add(new Cell.TextManager(colorMapTypeString, this.vAlign, this.hAlign, this.backgroundColor, this.requestedDimension, this.labelFont, this.labelFontColor, this.fontAntiAliasing, this.borderColor, this.wrap));
            String extendedCMapString = "ColorMap is " + (this.extended ? "" : "not") + " extended";
            this.footerRows.add(new Cell.TextManager(extendedCMapString, this.vAlign, this.hAlign, this.backgroundColor, this.requestedDimension, this.labelFont, this.labelFontColor, this.fontAntiAliasing, this.borderColor, this.wrap));
            this.cycleFooterRows(graphics);
        }
        double maxW = Math.max(this.colorW + this.ruleW + this.labelW, this.footerW);
        this.dx = this.absoluteMargins ? this.columnMarginPercentage : maxW * this.columnMarginPercentage;
        this.dy = this.colorMapType == ColorMapType.RAMP ? 0.0 : this.rowH * this.rowMarginPercentage;
        double mx = maxW * this.hMarginPercentage;
        double my = this.rowH * this.vMarginPercentage;
        this.margin = Math.max(mx, my);
    }

    private void cycleFooterRows(Graphics2D graphics) {
        int numRows = this.footerRows.size();
        int i = 0;
        this.footerW = Double.NEGATIVE_INFINITY;
        for (i = 0; i < numRows; ++i) {
            Cell cell = this.footerRows.get(i);
            Dimension cellDim = cell.getPreferredDimension(graphics);
            this.rowH = Math.max(this.rowH, cellDim.getHeight());
            this.footerW = Math.max(this.footerW, cellDim.getWidth());
        }
    }

    private void cycleBodyRows(Graphics2D graphics) {
        for (Cell.ColorMapEntryLegendBuilder row : this.bodyRows) {
            Cell labelM;
            Cell cm = row.getColorManager();
            Dimension colorDim = cm.getPreferredDimension(graphics);
            this.rowH = Math.max(this.rowH, colorDim.getHeight());
            this.colorW = Math.max(this.colorW, colorDim.getWidth());
            if (this.forceRule) {
                Cell ruleM = row.getRuleManager();
                Dimension ruleDim = ruleM.getPreferredDimension(graphics);
                this.rowH = Math.max(this.rowH, ruleDim.getHeight());
                this.ruleW = Math.max(this.ruleW, ruleDim.getWidth());
            }
            if ((labelM = row.getLabelManager()) == null) continue;
            Dimension labelDim = labelM.getPreferredDimension(graphics);
            this.rowH = Math.max(this.rowH, labelDim.getHeight());
            this.labelW = Math.max(this.labelW, labelDim.getWidth());
        }
    }

    private ImageQueue createFooter(Tally tally) {
        BufferedImage image = ImageUtils.createImage(1, 1, null, this.transparent);
        HashMap<RenderingHints.Key, Object> hintsMap = new HashMap<RenderingHints.Key, Object>();
        Graphics2D graphics = ImageUtils.prepareTransparency(this.transparent, this.backgroundColor, image, hintsMap);
        ImageQueue queue = new ImageQueue(tally);
        int rowWidth = (int)Math.round(this.footerW);
        for (Cell cell : this.footerRows) {
            Dimension dim = cell.getPreferredDimension(graphics);
            int rowHeight = (int)Math.round(dim.getHeight());
            Rectangle clipboxA = new Rectangle(0, 0, rowWidth, rowHeight);
            BufferedImage colorCellLegend = new BufferedImage(rowWidth, rowHeight, 2);
            Graphics2D rlg = colorCellLegend.createGraphics();
            rlg.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            cell.draw(rlg, clipboxA, this.border);
            rlg.dispose();
            queue.add(colorCellLegend);
        }
        graphics.dispose();
        return queue;
    }

    private ImageQueue createBody(Tally tally) {
        ImageQueue queue = new ImageQueue(tally);
        int rowHeight = (int)Math.round(this.rowH);
        int colorWidth = (int)Math.round(this.colorW);
        int ruleWidth = (int)Math.round(this.ruleW);
        int labelWidth = (int)Math.round(this.labelW);
        Rectangle clipboxA = new Rectangle(0, 0, colorWidth, rowHeight);
        Rectangle clipboxB = new Rectangle(0, 0, ruleWidth, rowHeight);
        Rectangle clipboxC = new Rectangle(0, 0, labelWidth, rowHeight);
        for (Cell.ColorMapEntryLegendBuilder row : this.bodyRows) {
            Cell colorCell = row.getColorManager();
            BufferedImage colorCellLegend = new BufferedImage(colorWidth, rowHeight, 2);
            Graphics2D rlg = colorCellLegend.createGraphics();
            rlg.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            rlg.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            colorCell.draw(rlg, clipboxA, this.border);
            rlg.dispose();
            BufferedImage ruleCellLegend = null;
            if (this.forceRule) {
                Cell ruleCell = row.getRuleManager();
                ruleCellLegend = new BufferedImage(ruleWidth, rowHeight, 2);
                rlg = ruleCellLegend.createGraphics();
                rlg.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                rlg.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                ruleCell.draw(rlg, clipboxB, this.borderRule);
                rlg.dispose();
            }
            if (labelWidth > 0) {
                Cell labelCell = row.getLabelManager();
                if (labelCell != null) {
                    BufferedImage labelCellLegend = new BufferedImage(labelWidth, rowHeight, 2);
                    rlg = labelCellLegend.createGraphics();
                    rlg.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    rlg.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                    labelCell.draw(rlg, clipboxC, this.borderLabel);
                    rlg.dispose();
                    HashMap<RenderingHints.Key, Object> hintsMap = new HashMap<RenderingHints.Key, Object>();
                    queue.add(LegendUtils.hMergeBufferedImages(colorCellLegend, ruleCellLegend, labelCellLegend, hintsMap, this.transparent, this.backgroundColor, this.dx));
                    continue;
                }
                HashMap<RenderingHints.Key, Object> hintsMap = new HashMap<RenderingHints.Key, Object>();
                queue.add(LegendUtils.hMergeBufferedImages(colorCellLegend, ruleCellLegend, null, hintsMap, this.transparent, this.backgroundColor, this.dx));
                continue;
            }
            HashMap<RenderingHints.Key, Object> hintsMap = new HashMap<RenderingHints.Key, Object>();
            queue.add(LegendUtils.hMergeBufferedImages(colorCellLegend, ruleCellLegend, null, hintsMap, this.transparent, this.backgroundColor, this.dx));
        }
        return queue;
    }

    private BufferedImage mergeRows(ImageQueue legendsQueue, Tally tally) {
        Dimension finalDimension = new Dimension();
        int numRows = legendsQueue.size();
        finalDimension.setSize(Math.max(this.footerW, this.colorW + this.ruleW + this.labelW) + 2.0 * this.dx + 2.0 * this.margin, this.rowH * (double)numRows + 2.0 * this.margin + (double)(numRows - 1) * this.dy);
        int totalWidth = (int)finalDimension.getWidth();
        int totalHeight = (int)finalDimension.getHeight();
        BufferedImage finalLegend = ImageUtils.createImage(totalWidth, totalHeight, null, this.transparent);
        if (this.colorMapType == ColorMapType.RAMP) {
            HashMap<RenderingHints.Key, Object> hintsMap = new HashMap<RenderingHints.Key, Object>();
            Graphics2D finalGraphics = ImageUtils.prepareTransparency(this.transparent, this.backgroundColor, finalLegend, hintsMap);
            hintsMap.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            finalGraphics.setRenderingHints(hintsMap);
            int topOfRow = (int)(this.margin + 0.5);
            for (int i = 0; i < numRows; ++i) {
                BufferedImage img = legendsQueue.remove();
                finalGraphics.drawImage((Image)img, (int)(this.margin + 0.5), topOfRow, null);
                topOfRow = (int)((double)topOfRow + ((double)img.getHeight() + this.dy));
            }
            if (this.layout == LegendUtils.LegendLayout.HORIZONTAL) {
                BufferedImage newImage = new BufferedImage(totalHeight, totalWidth, finalLegend.getType());
                Graphics2D g2 = newImage.createGraphics();
                g2.rotate(-1.5707963267948966, 0.0, 0.0);
                g2.drawImage(finalLegend, null, -totalWidth, 0);
                finalLegend = newImage;
                g2.dispose();
                finalGraphics.dispose();
            }
        } else {
            ImageList imgs = new ImageList(tally, legendsQueue);
            LegendMerger.MergeOptions options = new LegendMerger.MergeOptions(imgs, (int)this.dx, (int)this.dy, (int)this.margin, 0, this.backgroundColor, this.transparent, true, this.layout, this.rowWidth, this.rows, this.columnHeight, this.columns, null, false, false, false);
            finalLegend = LegendMerger.mergeRasterLegends(options);
        }
        return finalLegend;
    }

    protected Queue<Cell.ColorMapEntryLegendBuilder> getBodyRows() {
        return this.bodyRows;
    }

    static enum ColorMapType {
        UNIQUE_VALUES,
        RAMP,
        CLASSES;


        public static ColorMapType create(String value) {
            if (value.equalsIgnoreCase("intervals")) {
                return CLASSES;
            }
            if (value.equalsIgnoreCase("ramp")) {
                return RAMP;
            }
            if (value.equalsIgnoreCase("values")) {
                return UNIQUE_VALUES;
            }
            return ColorMapType.valueOf(value);
        }

        public static ColorMapType create(int value) {
            switch (value) {
                case 2: {
                    return CLASSES;
                }
                case 1: {
                    return RAMP;
                }
                case 3: {
                    return UNIQUE_VALUES;
                }
            }
            throw new IllegalArgumentException("Unable to create ColorMapType for value " + value);
        }
    }

    public static class Builder {
        private final Queue<Cell.ColorMapEntryLegendBuilder> bodyRows = new LinkedList<Cell.ColorMapEntryLegendBuilder>();
        private boolean wrap = false;
        private ColorMapType colorMapType;
        private ColorMapEntry previousCMapEntry;
        private final CaseInsensitiveMap<String, Object> additionalOptions = new CaseInsensitiveMap();
        private Color backgroundColor;
        private LegendUtils.LegendLayout layout;
        private int columnHeight;
        private int rowWidth;
        private int columns;
        private int rows;
        private String grayChannelName = "1";
        private boolean extended = false;
        private Color borderColor = LegendUtils.DEFAULT_BORDER_COLOR;
        private boolean fontAntiAliasing = true;
        private LegendUtils.HAlign hAlign = LegendUtils.HAlign.LEFT;
        private Font labelFont;
        private Color labelFontColor;
        private Dimension requestedDimension;
        private boolean transparent;
        private LegendUtils.VAlign vAlign = LegendUtils.VAlign.BOTTOM;
        private boolean forceRule = false;
        private double rowMarginPercentage = 0.15f;
        private double vMarginPercentage = 0.015f;
        private double columnMarginPercentage = 0.15f;
        private double hMarginPercentage = 0.015f;
        private boolean absoluteMargins = true;
        private boolean border = false;
        private boolean borderLabel = false;
        private boolean borderRule = false;
        private boolean bandInformation = false;
        private String unit = "";
        private int digits;
        private boolean alternativeColorMapEntryBuilder = false;

        public Cell.ColorMapEntryLegendBuilder addColorMapEntry(ColorMapEntry cEntry) {
            Cell.ColorMapEntryLegendBuilder element;
            PackagedUtils.ensureNotNull(cEntry, "cEntry");
            switch (this.colorMapType) {
                case UNIQUE_VALUES: {
                    element = new Cell.SingleColorMapEntryLegendBuilder(Arrays.asList(cEntry), this.hAlign, this.vAlign, this.backgroundColor, 1.0, this.grayChannelName, this.requestedDimension, this.labelFont, this.labelFontColor, this.extended, this.borderColor, this.unit, this.digits, this.alternativeColorMapEntryBuilder, this.wrap);
                    break;
                }
                case RAMP: {
                    element = new Cell.RampColorMapEntryLegendBuilder(Arrays.asList(this.previousCMapEntry, cEntry), this.hAlign, this.vAlign, this.backgroundColor, 1.0, this.grayChannelName, this.requestedDimension, this.labelFont, this.labelFontColor, this.extended, this.borderColor, this.unit, this.digits, this.alternativeColorMapEntryBuilder, this.wrap);
                    break;
                }
                case CLASSES: {
                    element = new Cell.ClassesEntryLegendBuilder(Arrays.asList(this.previousCMapEntry, cEntry), this.hAlign, this.vAlign, this.backgroundColor, 1.0, this.grayChannelName, this.requestedDimension, this.labelFont, this.labelFontColor, this.extended, this.borderColor, this.unit, this.digits, this.alternativeColorMapEntryBuilder, this.wrap);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unrecognized colormap type");
                }
            }
            this.bodyRows.add(element);
            this.previousCMapEntry = cEntry;
            return element;
        }

        public void setAdditionalOptions(Map<String, Object> legendOptions) {
            this.additionalOptions.putAll(legendOptions);
        }

        public void setBackgroundColor(Color backGroundColor) {
            PackagedUtils.ensureNotNull(backGroundColor, "backGroundColor");
            this.backgroundColor = backGroundColor;
        }

        public void setBand(SelectedChannelType grayChannel) {
            if (grayChannel != null) {
                this.grayChannelName = (String)grayChannel.getChannelName().evaluate(null, String.class);
            }
            if (this.grayChannelName == null) {
                this.grayChannelName = "1";
            }
        }

        public void setColorMapType(ColorMapType colorMapType) {
            this.colorMapType = colorMapType;
        }

        public void setColorMapType(int type) {
            this.colorMapType = ColorMapType.create(type);
        }

        public void setExtended(boolean extended) {
            this.extended = extended;
        }

        public void setLabelFont(Font labelFont) {
            PackagedUtils.ensureNotNull(labelFont, "labelFont");
            this.labelFont = labelFont;
        }

        public void setLabelFontColor(Color labelFontColor) {
            PackagedUtils.ensureNotNull(labelFontColor, "labelFontColor");
            this.labelFontColor = labelFontColor;
        }

        public void setRequestedDimension(Dimension dimension) {
            this.requestedDimension = (Dimension)dimension.clone();
        }

        public void setTransparent(boolean transparent) {
            this.transparent = transparent;
        }

        public void setBorderLabel(boolean borderLabel) {
            this.borderLabel = borderLabel;
        }

        public void setBorderRule(boolean borderRule) {
            this.borderRule = borderRule;
        }

        public void setLayout(LegendUtils.LegendLayout layout) {
            this.layout = layout;
        }

        public void setColumnHeight(int columnHeight) {
            this.columnHeight = columnHeight;
        }

        public void setRowWidth(int rowWidth) {
            this.rowWidth = rowWidth;
        }

        public void setColumns(int columns) {
            this.columns = columns;
        }

        public void setRows(int rows) {
            this.rows = rows;
        }

        public ColorMapLegendCreator create() {
            return new ColorMapLegendCreator(this);
        }

        public void checkAdditionalOptions() {
            String aaVal;
            this.fontAntiAliasing = false;
            if (this.additionalOptions.get((Object)"fontAntiAliasing") instanceof String && ((aaVal = (String)this.additionalOptions.get((Object)"fontAntiAliasing")).equalsIgnoreCase("on") || aaVal.equalsIgnoreCase("true") || aaVal.equalsIgnoreCase("yes") || aaVal.equalsIgnoreCase("1"))) {
                this.fontAntiAliasing = true;
            }
            if (this.additionalOptions.get((Object)"dx") instanceof String) {
                this.columnMarginPercentage = Double.parseDouble((String)this.additionalOptions.get((Object)"dx"));
            }
            if (this.additionalOptions.get((Object)"absoluteMargins") instanceof String) {
                this.absoluteMargins = Boolean.parseBoolean((String)this.additionalOptions.get((Object)"absoluteMargins"));
            }
            if (this.additionalOptions.get((Object)"bandInfo") instanceof String) {
                this.bandInformation = Boolean.parseBoolean((String)this.additionalOptions.get((Object)"bandInfo"));
            }
            if (this.additionalOptions.get((Object)"dy") instanceof String) {
                this.rowMarginPercentage = Double.parseDouble((String)this.additionalOptions.get((Object)"dy"));
            }
            if (this.additionalOptions.get((Object)"mx") instanceof String) {
                this.hMarginPercentage = Double.parseDouble((String)this.additionalOptions.get((Object)"mx"));
            }
            if (this.additionalOptions.get((Object)"my") instanceof String) {
                this.vMarginPercentage = Double.parseDouble((String)this.additionalOptions.get((Object)"my"));
            }
            if (this.additionalOptions.get((Object)"borderColor") instanceof String) {
                this.borderColor = LegendUtils.color((String)this.additionalOptions.get((Object)"borderColor"));
            }
            if (this.additionalOptions.get((Object)"border") instanceof String) {
                this.border = Boolean.valueOf((String)this.additionalOptions.get((Object)"border"));
            }
            if (this.additionalOptions.get((Object)"forceRule") instanceof String) {
                this.forceRule = Boolean.parseBoolean((String)this.additionalOptions.get((Object)"forceRule"));
            }
            if (!this.forceRule) {
                for (Cell.ColorMapEntryLegendBuilder row : this.bodyRows) {
                    Cell labelM = row.getLabelManager();
                    if (labelM == null) {
                        this.forceRule = true;
                        continue;
                    }
                    this.forceRule = false;
                    break;
                }
            }
        }

        public void setBandInformation(boolean bandInformation) {
            this.bandInformation = bandInformation;
        }

        public void setUnit(String unit) {
            this.unit = unit;
        }

        public void setDigits(int digits) {
            this.digits = digits;
        }

        public void setAlternativeColorMapEntryBuilder(boolean alternativeColorMapEntryBuilder) {
            this.alternativeColorMapEntryBuilder = alternativeColorMapEntryBuilder;
        }

        public Queue<Cell.ColorMapEntryLegendBuilder> getBodyRows() {
            return this.bodyRows;
        }

        public boolean isWrap() {
            return this.wrap;
        }

        public void setWrap(boolean wrap) {
            this.wrap = wrap;
        }
    }
}

