/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.georss;

import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import org.geoserver.wms.WMS;
import org.geoserver.wms.WMSMapContent;
import org.geoserver.wms.georss.AtomUtils;
import org.geoserver.wms.georss.GeoRSSTransformerBase;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.xml.transform.Translator;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.xml.sax.ContentHandler;
import org.xml.sax.helpers.AttributesImpl;

public class RSSGeoRSSTransformer
extends GeoRSSTransformerBase {
    private WMS wms;

    public RSSGeoRSSTransformer(WMS wms) {
        this.wms = wms;
    }

    public Translator createTranslator(ContentHandler handler) {
        return new RSSGeoRSSTranslator(this.wms, handler);
    }

    class RSSGeoRSSTranslator
    extends GeoRSSTransformerBase.GeoRSSTranslatorSupport {
        private WMS wms;

        public RSSGeoRSSTranslator(WMS wms, ContentHandler contentHandler) {
            super(RSSGeoRSSTransformer.this, contentHandler, null, null);
            this.wms = wms;
            this.nsSupport.declarePrefix("georss", "http://www.georss.org/georss");
            this.nsSupport.declarePrefix("atom", "http://www.w3.org/2005/Atom");
        }

        public void encode(Object o) throws IllegalArgumentException {
            WMSMapContent map = (WMSMapContent)((Object)o);
            AttributesImpl atts = new AttributesImpl();
            atts.addAttribute(null, "version", "version", null, "2.0");
            this.start("rss", atts);
            this.start("channel");
            this.element("title", AtomUtils.getFeedTitle(map));
            this.element("description", AtomUtils.getFeedDescription(map));
            this.start("link");
            this.cdata(AtomUtils.getFeedURL(map));
            this.end("link");
            atts = new AttributesImpl();
            atts.addAttribute(null, "href", "href", null, AtomUtils.getFeedURL(map));
            atts.addAttribute(null, "rel", "rel", null, "self");
            this.element("atom:link", null, atts);
            try {
                this.encodeItems(map);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.end("channel");
            this.end("rss");
        }

        void encodeItems(WMSMapContent map) throws IOException {
            List featureCollections = this.loadFeatureCollections(map);
            block7: for (Object featureCollection : featureCollections) {
                SimpleFeatureCollection features = (SimpleFeatureCollection)featureCollection;
                SimpleFeatureIterator iterator = features.features();
                block8: while (true) {
                    while (iterator.hasNext()) {
                        SimpleFeature feature = (SimpleFeature)iterator.next();
                        try {
                            this.encodeItem(feature, map);
                            continue block8;
                        }
                        catch (Exception e) {
                            GeoRSSTransformerBase.LOGGER.warning("Encoding failed for feature: " + feature.getID());
                            GeoRSSTransformerBase.LOGGER.log(Level.FINE, "", e);
                        }
                    }
                    continue block7;
                    {
                        continue block8;
                        break;
                    }
                    break;
                }
                finally {
                    if (iterator == null) continue;
                    iterator.close();
                }
            }
        }

        void encodeItem(SimpleFeature feature, WMSMapContent map) throws IOException {
            GeometryCollection col;
            this.start("item");
            String title = feature.getID();
            String link = null;
            try {
                title = AtomUtils.getFeatureTitle(feature);
                link = AtomUtils.getEntryURL(this.wms, feature, map);
            }
            catch (Exception e) {
                String msg = "Error occured executing title template for: " + feature.getID();
                GeoRSSTransformerBase.LOGGER.log(Level.WARNING, msg, e);
            }
            this.element("title", title);
            this.start("link");
            this.cdata(link);
            this.end("link");
            this.start("guid");
            this.cdata(link);
            this.end("guid");
            this.start("description");
            this.cdata(AtomUtils.getFeatureDescription(feature));
            this.end("description");
            GeometryCollection geometryCollection = col = feature.getDefaultGeometry() instanceof GeometryCollection ? (GeometryCollection)feature.getDefaultGeometry() : null;
            if (RSSGeoRSSTransformer.this.geometryEncoding == GeoRSSTransformerBase.GeometryEncoding.LATLONG || col == null && feature.getDefaultGeometry() != null) {
                RSSGeoRSSTransformer.this.geometryEncoding.encode((Geometry)feature.getDefaultGeometry(), this);
                this.end("item");
            } else if (col == null) {
                this.end("item");
            } else {
                RSSGeoRSSTransformer.this.geometryEncoding.encode(col.getGeometryN(0), this);
                this.end("item");
                for (int i = 1; i < col.getNumGeometries(); ++i) {
                    this.encodeRelatedGeometryItem(col.getGeometryN(i), title, link, i);
                }
            }
        }

        void encodeRelatedGeometryItem(Geometry g, String title, String link, int count) {
            this.start("item");
            this.element("title", "Continuation of " + title);
            this.element("link", link);
            this.element("guid", link + "#" + count);
            this.element("description", "Continuation of " + title);
            RSSGeoRSSTransformer.this.geometryEncoding.encode(g, this);
            this.end("item");
        }
    }
}

