/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.wms.WMSMapContent;
import org.geotools.filter.function.EnvFunction;
import org.geotools.util.logging.Logging;

public class RenderingVariables {
    static final Logger LOGGER = Logging.getLogger(RenderingVariables.class);
    public static final String WMS_BBOX = "wms_bbox";
    private static final String WMS_SRS = "wms_srs";
    private static final String WMS_WIDTH = "wms_width";
    private static final String WMS_HEIGHT = "wms_height";
    private static final String WMS_SCALE_DENOMINATOR = "wms_scale_denominator";

    public static void setupEnvironmentVariables(WMSMapContent mapContent) {
        EnvFunction.setLocalValue((String)WMS_BBOX, (Object)mapContent.getRenderingArea());
        EnvFunction.setLocalValue((String)"wms_crs", (Object)mapContent.getRenderingArea().getCoordinateReferenceSystem());
        EnvFunction.setLocalValue((String)WMS_SRS, (Object)mapContent.getRequest().getSRS());
        EnvFunction.setLocalValue((String)WMS_WIDTH, (Object)mapContent.getMapWidth());
        EnvFunction.setLocalValue((String)WMS_HEIGHT, (Object)mapContent.getMapHeight());
        try {
            double scaleDenominator = mapContent.getScaleDenominator(true);
            EnvFunction.setLocalValue((String)WMS_SCALE_DENOMINATOR, (Object)scaleDenominator);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Failed to compute the scale denominator, wms_scale_denominator env variable is unset", e);
        }
    }
}

