/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms;

import org.geoserver.config.GeoServer;
import org.geoserver.ows.AbstractDispatcherCallback;
import org.geoserver.ows.Request;
import org.geoserver.platform.Service;
import org.geoserver.platform.ServiceException;
import org.geoserver.wms.WMSInfo;

public class CiteComplianceCallback
extends AbstractDispatcherCallback {
    GeoServer gs;

    public CiteComplianceCallback(GeoServer gs) {
        this.gs = gs;
    }

    public Service serviceDispatched(Request request, Service service) throws ServiceException {
        WMSInfo wms;
        if ("WMS".equals(request.getService()) && (wms = (WMSInfo)this.gs.getService(WMSInfo.class)).isCiteCompliant() && !"GetCapabilities".equals(request.getRequest()) && this.isVersionMissing(request)) {
            throw new ServiceException("Could not determine version", "MissingParameterValue", "version");
        }
        return service;
    }

    private boolean isVersionMissing(Request request) {
        return request.getVersion() == null && request.getRawKvp().get("wmtver") == null;
    }
}

