/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.sld;

import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import org.geoserver.catalog.StyleHandler;
import org.geoserver.catalog.Styles;
import org.geoserver.ows.XmlRequestReader;
import org.geoserver.platform.ServiceException;
import org.geoserver.wms.GetMapRequest;
import org.geoserver.wms.WMS;
import org.geoserver.wms.map.ProcessStandaloneSLDVisitor;
import org.geotools.api.style.StyleVisitor;
import org.geotools.api.style.StyledLayerDescriptor;
import org.geotools.util.Version;
import org.xml.sax.EntityResolver;

public class SLDXmlRequestReader
extends XmlRequestReader {
    private WMS wms;

    public SLDXmlRequestReader(WMS wms) {
        super("http://www.opengis.net/sld", "StyledLayerDescriptor");
        this.wms = wms;
    }

    public Object read(Object request, Reader reader, Map kvp) throws ServiceException {
        if (request == null) {
            throw new IllegalArgumentException("request must be not null");
        }
        try {
            GetMapRequest getMap = (GetMapRequest)request;
            String styleFormat = getMap.getStyleFormat();
            StyleHandler styleParser = Styles.handler((String)styleFormat);
            Version styleVersion = getMap.styleVersion();
            EntityResolver entityResolver = this.wms.getCatalog().getResourcePool().getEntityResolver();
            StyledLayerDescriptor sld = styleParser.parse((Object)reader, styleVersion, null, entityResolver);
            sld.accept((StyleVisitor)new ProcessStandaloneSLDVisitor(this.wms, getMap));
            return getMap;
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)this.cleanException(e));
        }
    }
}

