/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.jts;

import org.geotools.geometry.jts.CircularRing;
import org.geotools.geometry.jts.CircularString;
import org.geotools.geometry.jts.CompoundRing;
import org.geotools.geometry.jts.CurvePolygon;
import org.geotools.geometry.jts.MultiSurface;
import org.geotools.geometry.jts.WKTReader2;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.Polygon;

public class WKTReader2Test {
    @Test
    public void verifyWKT() throws Exception {
        String WKT = "LINESTRING (60 380, 60 20, 200 400, 280 20, 360 400, 420 20, 500 400, 580 20, 620 400)";
        WKTReader2 reader = new WKTReader2();
        Geometry geometry = reader.read(WKT);
        Assert.assertNotNull((Object)geometry);
        Assert.assertTrue((boolean)(geometry instanceof LineString));
    }

    @Test
    public void multiPoint() throws Exception {
        String WKT = "MULTIPOINT (111 -47, 110 -46.5)";
        WKTReader2 reader = new WKTReader2();
        Geometry geometry = reader.read(WKT);
        Assert.assertNotNull((Object)geometry);
        Assert.assertTrue((boolean)(geometry instanceof MultiPoint));
        MultiPoint mp = (MultiPoint)geometry;
        Assert.assertEquals((long)2L, (long)mp.getNumGeometries());
        Assert.assertEquals((Object)new Coordinate(111.0, -47.0), (Object)mp.getGeometryN(0).getCoordinate());
        Assert.assertEquals((Object)new Coordinate(110.0, -46.5), (Object)mp.getGeometryN(1).getCoordinate());
    }

    @Test
    public void multiPointWithInnerParens() throws Exception {
        String WKT = "MULTIPOINT ((111 -47), (110 -46.5))";
        WKTReader2 reader = new WKTReader2();
        Geometry geometry = reader.read(WKT);
        Assert.assertNotNull((Object)geometry);
        Assert.assertTrue((boolean)(geometry instanceof MultiPoint));
        MultiPoint mp = (MultiPoint)geometry;
        Assert.assertEquals((long)2L, (long)mp.getNumGeometries());
        Assert.assertEquals((Object)new Coordinate(111.0, -47.0), (Object)mp.getGeometryN(0).getCoordinate());
        Assert.assertEquals((Object)new Coordinate(110.0, -46.5), (Object)mp.getGeometryN(1).getCoordinate());
    }

    @Test
    public void circularString() throws Exception {
        String WKT = "CIRCULARSTRING(220268.439465645 150415.359530563, 220227.333322076 150505.561285879, 220227.353105332 150406.434743975)";
        WKTReader2 reader = new WKTReader2(0.2);
        Geometry geometry = reader.read(WKT);
        Assert.assertNotNull((String)"parsed circularstring", (Object)geometry);
        Assert.assertTrue((boolean)(geometry instanceof CircularString));
        CircularString cs1 = (CircularString)geometry;
        Assert.assertEquals((String)"segmentized as expected", (long)86L, (long)cs1.getNumPoints());
        WKT = "CIRCULARSTRING(143.62025166838282 -30.037497356076827, 142.92857147299705 -32.75101196874403, 145.96132309891922 -34.985671061528784, 149.57565307617188 -33.41153335571289, 149.41972407584802 -29.824672680573517, 146.1209416055467 -30.19711586270431, 143.62025166838282 -30.037497356076827)";
        geometry = reader.read(WKT);
        Assert.assertNotNull((String)"parsed circularstring ring", (Object)geometry);
        Coordinate[] array = geometry.getCoordinates();
        Assert.assertEquals((String)"forms a ring", (Object)array[0], (Object)array[array.length - 1]);
        WKT = "CIRCULARSTRING(143.62025166838282 -30.037497356076827, 142.92857147299705 -32.75101196874403, 143.62025166838282 -30.037497356076827)";
        geometry = reader.read(WKT);
        Assert.assertNotNull((String)"parsed perfect circle", (Object)geometry);
        Assert.assertEquals((long)11L, (long)geometry.getNumPoints());
        WKT = "CIRCULARSTRING EMPTY";
        geometry = reader.read(WKT);
        Assert.assertNotNull((Object)geometry);
        Assert.assertTrue((boolean)geometry.isEmpty());
    }

    @Test
    public void compoundCurve() throws Exception {
        String WKT = "COMPOUNDCURVE((153.72942375 -27.21757040, 152.29285719 -29.23940482, 154.74034096 -30.51635287),CIRCULARSTRING(154.74034096 -30.51635287, 154.74034096 -30.51635287, 152.39926953 -32.16574411, 155.11278414 -34.08116619, 151.86720784 -35.62414508))";
        WKTReader2 reader = new WKTReader2();
        Geometry geometry = reader.read(WKT);
        Assert.assertNotNull((Object)geometry);
        WKT = "COMPOUNDCURVE((153.72942375 -27.21757040, 152.29285719 -29.23940482, 154.74034096 -30.51635287))";
        geometry = reader.read(WKT);
        Assert.assertNotNull((Object)geometry);
        WKT = "COMPOUNDCURVE(CIRCULARSTRING(154.74034096 -30.51635287, 154.74034096 -30.51635287, 152.39926953 -32.16574411, 155.11278414 -34.08116619, 151.86720784 -35.62414508))";
        geometry = reader.read(WKT);
        Assert.assertNotNull((Object)geometry);
        WKT = "COMPOUNDCURVE EMPTY";
        geometry = reader.read(WKT);
        Assert.assertNotNull((Object)geometry);
        Assert.assertTrue((boolean)geometry.isEmpty());
    }

    @Test
    public void curvePolygon() throws Exception {
        WKTReader2 reader = new WKTReader2();
        String WKT = "CURVEPOLYGON(CIRCULARSTRING(143.62025166838282 -30.037497356076827, 142.92857147299705 -32.75101196874403, 143.62025166838282 -30.037497356076827))";
        Geometry geometry = reader.read(WKT);
        Assert.assertNotNull((String)"read curvepolygon", (Object)geometry);
        Assert.assertTrue((boolean)(geometry instanceof Polygon));
        Polygon polygon = (Polygon)geometry;
        Assert.assertTrue((boolean)(polygon.getExteriorRing() instanceof CircularRing));
        Assert.assertTrue((String)"ring", (boolean)polygon.getExteriorRing().isClosed());
        Assert.assertEquals((String)"segmented ring", (long)51L, (long)polygon.getExteriorRing().getNumPoints());
        Assert.assertEquals((String)"no holes", (long)0L, (long)polygon.getNumInteriorRing());
        WKT = "CURVEPOLYGON((144.84399355252685 -31.26123924022086, 144.20551952601693 -32.27215644886158, 145.55230712890625 -33.49203872680664, 147.97080993652344 -32.03618621826172, 146.38697244992585 -31.47406391572417, 144.84399355252685 -31.26123924022086))";
        polygon = (Polygon)reader.read(WKT);
        Assert.assertTrue((String)"ring", (boolean)polygon.getExteriorRing().isClosed());
        Assert.assertEquals((String)"no holes", (long)0L, (long)polygon.getNumInteriorRing());
        WKT = "CURVEPOLYGON(CIRCULARSTRING(143.62025166838282 -30.037497356076827, 142.92857147299705 -32.75101196874403, 145.96132309891922 -34.985671061528784, 149.57565307617188 -33.41153335571289, 149.41972407584802 -29.824672680573517, 146.1209416055467 -30.19711586270431, 143.62025166838282 -30.037497356076827),(144.84399355252685 -31.26123924022086, 144.20551952601693 -32.27215644886158, 145.55230712890625 -33.49203872680664, 147.97080993652344 -32.03618621826172, 146.38697244992585 -31.47406391572417, 144.84399355252685 -31.26123924022086))";
        polygon = (Polygon)reader.read(WKT);
        Assert.assertTrue((String)"ring", (boolean)polygon.getExteriorRing().isClosed());
        Assert.assertTrue((boolean)(polygon.getExteriorRing() instanceof CircularRing));
        Assert.assertEquals((String)"one holes", (long)1L, (long)polygon.getNumInteriorRing());
        Assert.assertFalse((boolean)(polygon.getInteriorRingN(0) instanceof CircularRing));
        WKT = "CURVEPOLYGON(COMPOUNDCURVE(CIRCULARSTRING(0 0,2 0, 2 1, 2 3, 4 3),(4 3, 4 5, 1 4, 0 0)), CIRCULARSTRING(1.7 1, 1.4 0.4, 1.6 0.4, 1.6 0.5, 1.7 1) )";
        polygon = (Polygon)reader.read(WKT);
        Assert.assertTrue((String)"ring", (boolean)polygon.getExteriorRing().isClosed());
        Assert.assertTrue((boolean)(polygon.getExteriorRing() instanceof CompoundRing));
        Assert.assertEquals((String)"one holes", (long)1L, (long)polygon.getNumInteriorRing());
        Assert.assertTrue((boolean)(polygon.getInteriorRingN(0) instanceof CircularRing));
    }

    @Test
    public void testParseMulticurve() throws Exception {
        WKTReader2 reader = new WKTReader2();
        String WKT = "MULTICURVE EMPTY";
        MultiLineString ml = (MultiLineString)reader.read(WKT);
        Assert.assertTrue((boolean)ml.isEmpty());
        WKT = "MULTICURVE((0 0, 5 5),CIRCULARSTRING(4 0, 4 4, 8 4))";
        ml = (MultiLineString)reader.read(WKT);
        Assert.assertEquals((long)2L, (long)ml.getNumGeometries());
        Assert.assertSame(ml.getGeometryN(0).getClass(), LineString.class);
        Assert.assertTrue((boolean)(ml.getGeometryN(1) instanceof CircularString));
        WKT = "MULTICURVE((100 100, 120 120), COMPOUNDCURVE(CIRCULARSTRING(0 0, 2 0, 2 1, 2 3, 4 3),(4 3, 4 5, 1 4, 0 0)))";
        ml = (MultiLineString)reader.read(WKT);
        Assert.assertEquals((long)2L, (long)ml.getNumGeometries());
        Assert.assertSame(ml.getGeometryN(0).getClass(), LineString.class);
        Assert.assertTrue((boolean)(ml.getGeometryN(1) instanceof CompoundRing));
    }

    @Test
    public void testCaseInsensitive() throws Exception {
        WKTReader2 reader = new WKTReader2();
        Assert.assertNotNull((Object)reader.read("POINT(1 2)"));
        Assert.assertNotNull((Object)reader.read("Point(1 2)"));
        Assert.assertNotNull((Object)reader.read("LINESTRING(0 2, 2 0, 8 6)"));
        Assert.assertNotNull((Object)reader.read("LineString(0 2, 2 0, 8 6)"));
    }

    @Test
    public void testMultiSurfaceStraightPolygon() throws Exception {
        String wkt = "MULTISURFACE (((0 0, 1 0, 1 4, 0 0)), CURVEPOLYGON (COMPOUNDCURVE (CIRCULARSTRING (0 2, 7 5, 2 10), (2 10, 0 2)), COMPOUNDCURVE (CIRCULARSTRING (3 9, 6 5, 3 2), (3 2, 3 9))))";
        Geometry geometry = new WKTReader2().read(wkt);
        MultiSurface ms = (MultiSurface)geometry;
        Assert.assertEquals((long)2L, (long)ms.getNumGeometries());
        Assert.assertFalse((boolean)(ms.getGeometryN(0) instanceof CurvePolygon));
        Assert.assertTrue((boolean)(ms.getGeometryN(1) instanceof CurvePolygon));
    }

    @Test
    public void testMultiSurfaceStraightPolygon2() throws Exception {
        String wkt = "MULTISURFACE (CURVEPOLYGON (COMPOUNDCURVE (CIRCULARSTRING (0 2, 7 5, 2 10), (2 10, 0 2)), COMPOUNDCURVE (CIRCULARSTRING (3 9, 6 5, 3 2), (3 2, 3 9))), ((0 0, 1 0, 1 4, 0 0)))";
        Geometry geometry = new WKTReader2().read(wkt);
        MultiSurface ms = (MultiSurface)geometry;
        Assert.assertEquals((long)2L, (long)ms.getNumGeometries());
        Assert.assertTrue((boolean)(ms.getGeometryN(0) instanceof CurvePolygon));
        Assert.assertFalse((boolean)(ms.getGeometryN(1) instanceof CurvePolygon));
    }

    @Test
    public void testMultiSurfaceEmpty() throws Exception {
        String wkt = "MULTISURFACE (EMPTY, CURVEPOLYGON (COMPOUNDCURVE (CIRCULARSTRING (0 2, 7 5, 2 10), (2 10, 0 2)), COMPOUNDCURVE (CIRCULARSTRING (3 9, 6 5, 3 2), (3 2, 3 9))), ((0 0, 1 0, 1 4, 0 0)))";
        Geometry geometry = new WKTReader2().read(wkt);
        MultiSurface ms = (MultiSurface)geometry;
        Assert.assertEquals((long)3L, (long)ms.getNumGeometries());
        Assert.assertFalse((boolean)(ms.getGeometryN(0) instanceof CurvePolygon));
        Assert.assertTrue((boolean)(ms.getGeometryN(1) instanceof CurvePolygon));
        Assert.assertFalse((boolean)(ms.getGeometryN(2) instanceof CurvePolygon));
    }

    @Test
    public void testEmptyPoint() throws Exception {
        WKTReader2 wktReader2 = new WKTReader2();
        String wkt = "POINT EMPTY";
        Geometry geom = wktReader2.read(wkt);
        Assert.assertNotNull((Object)geom);
        Assert.assertTrue((boolean)geom.isEmpty());
        wkt = "MULTIPOINT EMPTY";
        geom = wktReader2.read(wkt);
        Assert.assertNotNull((Object)geom);
        Assert.assertTrue((boolean)geom.isEmpty());
        wkt = "MULTIPOINT (EMPTY)";
        geom = wktReader2.read(wkt);
        Assert.assertNotNull((Object)geom);
        Assert.assertTrue((boolean)geom.isEmpty());
    }

    @Test
    public void testEmptyLineString() throws Exception {
        WKTReader2 wktReader2 = new WKTReader2();
        String wkt = "LINESTRING EMPTY";
        Geometry geom = wktReader2.read(wkt);
        Assert.assertNotNull((Object)geom);
        Assert.assertTrue((boolean)geom.isEmpty());
        wkt = "MULTILINESTRING EMPTY";
        geom = wktReader2.read(wkt);
        Assert.assertNotNull((Object)geom);
        Assert.assertTrue((boolean)geom.isEmpty());
        wkt = "MULTILINESTRING (EMPTY)";
        geom = wktReader2.read(wkt);
        Assert.assertNotNull((Object)geom);
        Assert.assertTrue((boolean)geom.isEmpty());
    }

    @Test
    public void testEmptyPolygon() throws Exception {
        WKTReader2 wktReader2 = new WKTReader2();
        String wkt = "POLYGON EMPTY";
        Geometry geom = wktReader2.read(wkt);
        Assert.assertNotNull((Object)geom);
        Assert.assertTrue((boolean)geom.isEmpty());
        wkt = "MULTIPOLYGON EMPTY";
        geom = wktReader2.read(wkt);
        Assert.assertNotNull((Object)geom);
        Assert.assertTrue((boolean)geom.isEmpty());
        wkt = "MULTIPOLYGON (EMPTY)";
        geom = wktReader2.read(wkt);
        Assert.assertNotNull((Object)geom);
        Assert.assertTrue((boolean)geom.isEmpty());
    }
}

