/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.jts;

import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import org.geotools.api.geometry.BoundingBox;
import org.geotools.api.geometry.Bounds;
import org.geotools.api.geometry.MismatchedReferenceSystemException;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.geometry.GeneralBounds;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultEngineeringCRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.referencing.crs.DefaultProjectedCRS;
import org.geotools.util.factory.GeoTools;
import org.geotools.util.factory.Hints;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;

public class ReferencedEnvelopeTest {
    @Before
    public void setUp() throws Exception {
        Hints.putSystemDefault((RenderingHints.Key)Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER, (Object)Boolean.FALSE);
        GeoTools.fireConfigurationChanged();
    }

    @Test
    public void testEverything() {
        ReferencedEnvelope everything = ReferencedEnvelope.EVERYTHING;
        ReferencedEnvelope world = new ReferencedEnvelope(ReferencedEnvelope.EVERYTHING);
        Assert.assertSame((Object)everything, (Object)ReferencedEnvelope.EVERYTHING);
        Assert.assertNotSame((Object)everything, (Object)world);
        Assert.assertEquals((Object)everything, (Object)world);
        Assert.assertEquals((Object)world, (Object)everything);
        Assert.assertFalse((String)"This is not an empty envelope", (boolean)everything.isEmpty());
        Assert.assertTrue((String)"This is a null envelope", (boolean)everything.isNull());
        Coordinate center = everything.centre();
        Assert.assertNotNull((Object)center);
        double area = everything.getArea();
        Assert.assertTrue((String)("area=" + area), (boolean)Double.isInfinite(area));
        area = world.getArea();
        Assert.assertTrue((String)("area=" + area), (boolean)Double.isInfinite(area));
        try {
            everything.setBounds((BoundingBox)new ReferencedEnvelope());
            Assert.fail((String)"Expected IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        everything.setToNull();
        everything.translate(1.0, 1.0);
        Assert.assertEquals((Object)everything, (Object)world);
        Assert.assertEquals((Object)world, (Object)everything);
        Assert.assertEquals((double)world.getMaximum(0), (double)everything.getMaximum(0), (double)0.0);
        Assert.assertEquals((double)world.getMaximum(1), (double)everything.getMaximum(1), (double)0.0);
        Assert.assertEquals((double)world.getMinimum(0), (double)everything.getMinimum(0), (double)0.0);
        Assert.assertEquals((double)world.getMinimum(1), (double)everything.getMinimum(1), (double)0.0);
        Assert.assertEquals((double)world.getMedian(0), (double)everything.getMedian(0), (double)0.0);
        Assert.assertEquals((double)world.getMedian(1), (double)everything.getMedian(0), (double)0.0);
    }

    @Test
    public void intersection() throws Exception {
        ReferencedEnvelope australia = new ReferencedEnvelope((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        australia.include(40.0, 110.0);
        australia.include(10.0, 150.0);
        ReferencedEnvelope newZealand = new ReferencedEnvelope((CoordinateReferenceSystem)DefaultEngineeringCRS.CARTESIAN_2D);
        newZealand.include(50.0, 165.0);
        newZealand.include(33.0, 180.0);
        try {
            australia.intersection((Envelope)newZealand);
            Assert.fail((String)"Expected a mismatch of CoordinateReferenceSystem");
        }
        catch (MismatchedReferenceSystemException mismatchedReferenceSystemException) {
            // empty catch block
        }
    }

    @Test
    public void include() throws Exception {
        ReferencedEnvelope australia = new ReferencedEnvelope((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        australia.include(40.0, 110.0);
        australia.include(10.0, 150.0);
        ReferencedEnvelope newZealand = new ReferencedEnvelope((CoordinateReferenceSystem)DefaultEngineeringCRS.CARTESIAN_2D);
        newZealand.include(50.0, 165.0);
        newZealand.include(33.0, 180.0);
        try {
            australia.expandToInclude((Envelope)newZealand);
            Assert.fail((String)"Expected a mismatch of CoordinateReferenceSystem");
        }
        catch (MismatchedReferenceSystemException mismatchedReferenceSystemException) {
            // empty catch block
        }
        try {
            australia.include((BoundingBox)newZealand);
            Assert.fail((String)"Expected a mismatch of CoordinateReferenceSystem");
        }
        catch (MismatchedReferenceSystemException mismatchedReferenceSystemException) {
            // empty catch block
        }
    }

    @Test
    public void empty() {
        ReferencedEnvelope bbox = new ReferencedEnvelope();
        Assert.assertNull((Object)bbox.getCoordinateReferenceSystem());
        ReferencedEnvelope australia = new ReferencedEnvelope((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        australia.include(40.0, 110.0);
        australia.include(10.0, 150.0);
        bbox.include((BoundingBox)australia);
        Assert.assertEquals((Object)australia.getCoordinateReferenceSystem(), (Object)bbox.getCoordinateReferenceSystem());
    }

    @Test
    public void testBoundsEquals2D() {
        Rectangle2D.Double bounds = new Rectangle2D.Double(-20.0, -20.0, 40.0, 40.0);
        ReferencedEnvelope env1 = new ReferencedEnvelope((Rectangle2D)bounds, null);
        ReferencedEnvelope env2 = new ReferencedEnvelope((Rectangle2D)bounds, null);
        double eps = 1.0E-4;
        Assert.assertTrue((boolean)env1.boundsEquals2D((Bounds)env2, eps));
        bounds = new Rectangle2D.Double(-20.01, -20.01, 40.0, 40.0);
        env2 = new ReferencedEnvelope((Rectangle2D)bounds, null);
        Assert.assertFalse((boolean)env1.boundsEquals2D((Bounds)env2, eps));
    }

    @Test
    public void testFactoryMethod() throws Exception {
        try {
            new ReferencedEnvelope((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84_3D);
            Assert.fail((String)"ReferencedEnvelope should not be able to represent 3D CRS such as GDA94");
        }
        catch (Exception exception) {
            // empty catch block
        }
        ReferencedEnvelope bounds2 = ReferencedEnvelope.create((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84_3D);
        Assert.assertNotNull((Object)bounds2);
    }

    @Test
    public void testTransformToWGS84() throws Exception {
        String wkt = "GEOGCS[\"GDA94\", DATUM[\"Geocentric Datum of Australia 1994\",  SPHEROID[\"GRS 1980\", 6378137.0, 298.257222101, AUTHORITY[\"EPSG\",\"7019\"]],  TOWGS84[0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],  AUTHORITY[\"EPSG\",\"6283\"]],  PRIMEM[\"Greenwich\", 0.0, AUTHORITY[\"EPSG\",\"8901\"]], UNIT[\"degree\", 0.017453292519943295],  AXIS[\"Geodetic longitude\", EAST],  AXIS[\"Geodetic latitude\", NORTH],  AXIS[\"Ellipsoidal height\", UP],  AUTHORITY[\"EPSG\",\"4939\"]]";
        CoordinateReferenceSystem gda94 = CRS.parseWKT(wkt);
        ReferencedEnvelope bounds = new ReferencedEnvelope(130.875825803896, 130.898939990319, -16.4491956225999, -16.4338185791628, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        ReferencedEnvelope worldBounds2D = bounds.transform((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, true);
        Assert.assertEquals((Object)DefaultGeographicCRS.WGS84, (Object)worldBounds2D.getCoordinateReferenceSystem());
        ReferencedEnvelope worldBounds3D = bounds.transform((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84_3D, true);
        Assert.assertEquals((Object)DefaultGeographicCRS.WGS84_3D, (Object)worldBounds3D.getCoordinateReferenceSystem());
        ReferencedEnvelope gda94Bounds3D = bounds.transform(gda94, true);
        Assert.assertEquals((Object)gda94, (Object)gda94Bounds3D.getCoordinateReferenceSystem());
    }

    @Test
    public void testExpandToIncludeNull() throws Exception {
        ReferencedEnvelope r1 = new ReferencedEnvelope((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        ReferencedEnvelope r2 = new ReferencedEnvelope((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        Assert.assertTrue((boolean)r1.isNull());
        Assert.assertTrue((boolean)r2.isNull());
        r1.expandToInclude((Envelope)r2);
        Assert.assertTrue((boolean)r1.isNull());
    }

    @Test
    public void testEmptyEnvelopeConversion() throws Exception {
        GeneralBounds ge = new GeneralBounds(new double[]{0.0, 0.0}, new double[]{-1.0, -1.0});
        Assert.assertTrue((boolean)ge.isEmpty());
        Assert.assertTrue((boolean)ReferencedEnvelope.create((Bounds)ge, (CoordinateReferenceSystem)ge.getCoordinateReferenceSystem()).isEmpty());
        Assert.assertTrue((boolean)ReferencedEnvelope.reference((Bounds)ge).isEmpty());
        GeneralBounds bounds = new GeneralBounds(DefaultGeographicCRS.WGS84);
        Assert.assertTrue((boolean)bounds.isEmpty());
        Assert.assertTrue((boolean)ReferencedEnvelope.create((Bounds)bounds, (CoordinateReferenceSystem)bounds.getCoordinateReferenceSystem()).isEmpty());
        Assert.assertTrue((boolean)ReferencedEnvelope.reference((Bounds)bounds).isEmpty());
        Rectangle2D.Double r2d = new Rectangle2D.Double(0.0, 0.0, -1.0, -1.0);
        Assert.assertTrue((boolean)((RectangularShape)r2d).isEmpty());
        Assert.assertTrue((boolean)ReferencedEnvelope.create((Rectangle2D)r2d, null).isEmpty());
        Assert.assertTrue((boolean)ReferencedEnvelope.rect((Rectangle2D)r2d).isEmpty());
        Assert.assertTrue((boolean)ReferencedEnvelope.rect((Rectangle2D)r2d, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84).isEmpty());
        ReferencedEnvelope re = new ReferencedEnvelope();
        Assert.assertTrue((boolean)re.isEmpty());
        Assert.assertTrue((boolean)ReferencedEnvelope.create((ReferencedEnvelope)re).isEmpty());
        Assert.assertTrue((boolean)ReferencedEnvelope.create((Bounds)re, (CoordinateReferenceSystem)re.getCoordinateReferenceSystem()).isEmpty());
        Assert.assertTrue((boolean)ReferencedEnvelope.reference((ReferencedEnvelope)re).isEmpty());
    }

    @Test
    public void testWrappingEnvelopeConversion() throws Exception {
        GeneralBounds ge = new GeneralBounds(new double[]{160.0, 20.0}, new double[]{-160.0, 40.0});
        ge.setCoordinateReferenceSystem(DefaultGeographicCRS.WGS84);
        ReferencedEnvelope re = ReferencedEnvelope.reference((Bounds)ge);
        Assert.assertEquals((Object)DefaultGeographicCRS.WGS84, (Object)re.getCoordinateReferenceSystem());
        Assert.assertEquals((double)-180.0, (double)re.getMinX(), (double)0.0);
        Assert.assertEquals((double)180.0, (double)re.getMaxX(), (double)0.0);
        Assert.assertEquals((double)20.0, (double)re.getMinY(), (double)0.0);
        Assert.assertEquals((double)40.0, (double)re.getMaxY(), (double)0.0);
    }

    @Test
    public void testCompatibleCRSEnvelopeIntersection() throws Exception {
        ReferencedEnvelope env1 = this.createEnvelope(-2.177465925706197E7, 8646206.01995729, -1.8020943797479007E7, 1.2385261999043737E7, "EPSG:3857", false);
        ReferencedEnvelope env2 = this.createEnvelope(-2.1788686706639238E7, 8621919.786483308, -1.801691811921271E7, 1.2394009693069756E7, "EPSG:3857", true);
        CoordinateReferenceSystem crs1 = env1.getCoordinateReferenceSystem();
        CoordinateReferenceSystem crs2 = env2.getCoordinateReferenceSystem();
        Assert.assertNotSame((Object)((DefaultProjectedCRS)crs1).getBaseCRS().getCoordinateSystem().getAxis(0).getDirection(), (Object)((DefaultProjectedCRS)crs2).getBaseCRS().getCoordinateSystem().getAxis(0).getDirection());
        Assert.assertTrue((boolean)CRS.isEquivalent(crs1, crs2));
        ReferencedEnvelope re = env1.intersection((Envelope)env2);
        Assert.assertNotNull((Object)re);
    }

    @Test(expected=MismatchedReferenceSystemException.class)
    public void testIncompatibleCRSEnvelopeOperation() throws Exception {
        ReferencedEnvelope env1 = this.createEnvelope(-2.177465925706197E7, 8646206.01995729, -1.8020943797479007E7, 1.2385261999043737E7, "EPSG:3857", false);
        ReferencedEnvelope env2 = this.createEnvelope(-2.1788686706639238E7, 8621919.786483308, -1.801691811921271E7, 1.2394009693069756E7, "EPSG:32632", true);
        Assert.assertFalse((boolean)CRS.isEquivalent(env1.getCoordinateReferenceSystem(), env2.getCoordinateReferenceSystem()));
        env1.expandToInclude((Envelope)env2);
    }

    private ReferencedEnvelope createEnvelope(double minX, double minY, double maxX, double maxY, String epsgCode, boolean longitudeFirst) throws FactoryException {
        GeneralBounds ge = new GeneralBounds(new double[]{minX, minY}, new double[]{maxX, maxY});
        CoordinateReferenceSystem crs = CRS.decode(epsgCode, longitudeFirst);
        ge.setCoordinateReferenceSystem(crs);
        return ReferencedEnvelope.reference((Bounds)ge);
    }

    @Test
    public void testRectangle2DBehaviour() throws Exception {
        Rectangle2D.Double rectangle = new Rectangle2D.Double(10.0, 10.0, 40.0, 30.0);
        ReferencedEnvelope envelope = ReferencedEnvelope.rect((double)10.0, (double)10.0, (double)40.0, (double)30.0, (CoordinateReferenceSystem)DefaultEngineeringCRS.CARTESIAN_2D);
        Assert.assertEquals((String)"rect", (Object)ReferencedEnvelope.rect((Rectangle2D)rectangle, (CoordinateReferenceSystem)DefaultEngineeringCRS.CARTESIAN_2D), (Object)envelope);
        Assert.assertEquals((String)"x", (double)rectangle.getMinX(), (double)envelope.getMinX(), (double)0.0);
        Assert.assertEquals((String)"height", (double)((RectangularShape)rectangle).getHeight(), (double)envelope.getHeight(), (double)0.0);
        Point2D.Double center = new Point2D.Double(50.0, 50.0);
        Point2D.Double outer = new Point2D.Double(85.0, 15.0);
        rectangle.setFrameFromCenter(center, outer);
        envelope.setFrameFromCenter((Point2D)center, (Point2D)outer);
        Assert.assertEquals((String)"setFrameFromCenter", (Object)ReferencedEnvelope.rect((Rectangle2D)rectangle, (CoordinateReferenceSystem)DefaultEngineeringCRS.CARTESIAN_2D), (Object)envelope);
        Point2D.Double lower = new Point2D.Double(10.0, 10.0);
        Point2D.Double upper = new Point2D.Double(40.0, 30.0);
        rectangle.setFrameFromDiagonal(lower, upper);
        envelope.setFrameFromDiagonal((Point2D)lower, (Point2D)upper);
        Assert.assertEquals((String)"setFrameFromDiagonal", (Object)ReferencedEnvelope.rect((Rectangle2D)rectangle, (CoordinateReferenceSystem)DefaultEngineeringCRS.CARTESIAN_2D), (Object)envelope);
    }

    @After
    public void tearDown() throws Exception {
        Hints.putSystemDefault((RenderingHints.Key)Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER, (Object)Boolean.TRUE);
        GeoTools.fireConfigurationChanged();
    }
}

