/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.visitor;

import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.FilterVisitor;
import org.geotools.api.filter.PropertyIsEqualTo;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.spatial.BBOX;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.filter.visitor.PropertyNameResolvingVisitor;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.locationtech.jts.geom.Polygon;

public class PropertyNameResolvingFilterVisitorTest {
    FilterFactory factory;
    SimpleFeatureType featureType;

    @Before
    public void setUp() throws Exception {
        this.factory = CommonFactoryFinder.getFilterFactory(null);
        SimpleFeatureTypeBuilder b = new SimpleFeatureTypeBuilder();
        b.setName("test");
        b.add("name", String.class);
        b.add("geom", Polygon.class, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        b.setDefaultGeometry("geom");
        this.featureType = b.buildFeatureType();
    }

    @Test
    public void testResolvePropertyName() {
        PropertyIsEqualTo f = this.factory.equal((Expression)this.factory.property("gml:name"), (Expression)this.factory.literal((Object)"foo"), true);
        Assert.assertEquals((Object)"gml:name", (Object)f.getExpression1().toString());
        f = (PropertyIsEqualTo)f.accept((FilterVisitor)new PropertyNameResolvingVisitor(this.featureType), null);
        Assert.assertEquals((Object)"name", (Object)f.getExpression1().toString());
    }

    @Test
    public void testResolveEmptyName() {
        BBOX f = this.factory.bbox("", 0.0, 0.0, 1.0, 1.0, DefaultGeographicCRS.WGS84.toString());
        Assert.assertEquals((Object)"", (Object)f.getExpression1().toString());
        f = (BBOX)f.accept((FilterVisitor)new PropertyNameResolvingVisitor(this.featureType), null);
        Assert.assertEquals((Object)"", (Object)f.getExpression1().toString());
    }
}

