/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.spatial;

import java.awt.RenderingHints;
import java.util.Collections;
import java.util.List;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.FilterVisitor;
import org.geotools.api.filter.Id;
import org.geotools.api.filter.PropertyIsEqualTo;
import org.geotools.api.filter.capability.FunctionName;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.ExpressionVisitor;
import org.geotools.api.filter.expression.Function;
import org.geotools.api.filter.expression.Literal;
import org.geotools.api.filter.expression.PropertyName;
import org.geotools.api.filter.spatial.BBOX;
import org.geotools.api.filter.spatial.Intersects;
import org.geotools.api.geometry.BoundingBox;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.data.DataUtilities;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureTypes;
import org.geotools.filter.capability.FunctionNameImpl;
import org.geotools.filter.spatial.ReprojectingFilterVisitor;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.util.factory.GeoTools;
import org.geotools.util.factory.Hints;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;

public class ReprojectingFilterVisitorTest {
    SimpleFeatureType ft;
    FilterFactory ff;
    ReprojectingFilterVisitor reprojector;

    @Before
    public void setUp() throws Exception {
        Hints.putSystemDefault((RenderingHints.Key)Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER, (Object)Boolean.TRUE);
        GeoTools.fireConfigurationChanged();
        this.ft = DataUtilities.createType((String)"testType", (String)"geom:Point:srid=4326,line:LineString,name:String,id:int");
        this.ff = CommonFactoryFinder.getFilterFactory((Hints)GeoTools.getDefaultHints());
        this.reprojector = new ReprojectingFilterVisitor(this.ff, (FeatureType)this.ft);
    }

    @Test
    public void testNoProjection() {
        Id idFilter = this.ff.id(Collections.singleton(this.ff.featureId("testType:1")));
        Filter clone = (Filter)idFilter.accept((FilterVisitor)this.reprojector, null);
        Assert.assertNotSame((Object)idFilter, (Object)clone);
        Assert.assertEquals((Object)idFilter, (Object)clone);
    }

    @Test
    public void testBboxNoReprojection() {
        BBOX bbox = this.ff.bbox((Expression)this.ff.property("geom"), 10.0, 10.0, 20.0, 20.0, "EPSG:4326");
        Filter clone = (Filter)bbox.accept((FilterVisitor)this.reprojector, null);
        Assert.assertNotSame((Object)bbox, (Object)clone);
        Assert.assertEquals((Object)bbox, (Object)clone);
    }

    @Test
    public void testBboxReproject() throws FactoryException {
        BBOX bbox = this.ff.bbox((Expression)this.ff.property("geom"), 10.0, 15.0, 20.0, 25.0, "urn:x-ogc:def:crs:EPSG:6.11.2:4326");
        Filter clone = (Filter)bbox.accept((FilterVisitor)this.reprojector, null);
        Assert.assertNotSame((Object)bbox, (Object)clone);
        BBOX clonedBbox = (BBOX)clone;
        Assert.assertEquals((Object)bbox.getExpression1(), (Object)clonedBbox.getExpression1());
        Assert.assertTrue((boolean)JTS.equals((BoundingBox)new ReferencedEnvelope(15.0, 25.0, 10.0, 20.0, CRS.decode("EPSG:4326", false)), (BoundingBox)clonedBbox.getBounds(), (double)1.0E-6));
    }

    @Test
    public void testBboxReprojectNoNativeAuthority() throws Exception {
        String wkt = "GEOGCS[\"WGS 84\", DATUM[\"World Geodetic System 1984\", SPHEROID[\"WGS 84\", 6378137.0, 298.257223563]], PRIMEM[\"Greenwich\", 0.0], UNIT[\"degree\", 0.017453292519943295], AXIS[\"Geodetic longitude\", EAST], AXIS[\"Geodetic latitude\", NORTH]]";
        CoordinateReferenceSystem crs = CRS.parseWKT(wkt);
        SimpleFeatureType newFt = FeatureTypes.transform((SimpleFeatureType)this.ft, (CoordinateReferenceSystem)crs);
        this.reprojector = new ReprojectingFilterVisitor(this.ff, (FeatureType)newFt);
        BBOX bbox = this.ff.bbox((Expression)this.ff.property("geom"), 10.0, 15.0, 20.0, 25.0, "urn:x-ogc:def:crs:EPSG:6.11.2:4326");
        Filter clone = (Filter)bbox.accept((FilterVisitor)this.reprojector, null);
        Assert.assertNotSame((Object)bbox, (Object)clone);
        BBOX clonedBbox = (BBOX)clone;
        Assert.assertEquals((Object)bbox.getExpression1(), (Object)clonedBbox.getExpression1());
        Assert.assertTrue((boolean)JTS.equals((BoundingBox)new ReferencedEnvelope(15.0, 25.0, 10.0, 20.0, CRS.decode("EPSG:4326", false)), (BoundingBox)clonedBbox.getBounds(), (double)1.0E-6));
    }

    @Test
    public void testBboxReprojectUnreferencedProperty() {
        BBOX bbox = this.ff.bbox((Expression)this.ff.property("line"), 10.0, 15.0, 20.0, 25.0, "urn:x-ogc:def:crs:EPSG:6.11.2:4326");
        Filter clone = (Filter)bbox.accept((FilterVisitor)this.reprojector, null);
        Assert.assertNotSame((Object)bbox, (Object)clone);
        Assert.assertEquals((Object)bbox, (Object)clone);
    }

    @Test
    public void testBboxReprojectUnreferencedBBox() {
        BBOX bbox = this.ff.bbox((Expression)this.ff.property("geom"), 10.0, 15.0, 20.0, 25.0, null);
        Filter clone = (Filter)bbox.accept((FilterVisitor)this.reprojector, null);
        Assert.assertNotSame((Object)bbox, (Object)clone);
        Assert.assertEquals((Object)bbox, (Object)clone);
    }

    @Test
    public void checkIntersectsReproject() throws Exception {
        PropertyName geom = this.ff.property("geom");
        this.checkIntersectsReproject((Expression)geom);
    }

    @Test
    public void testBoundedByReproject() throws Exception {
        Function geom = this.ff.function("boundedBy", new Expression[0]);
        this.checkIntersectsReproject((Expression)geom);
    }

    public void checkIntersectsReproject(Expression geom) throws FactoryException {
        GeometryFactory gf = new GeometryFactory();
        LineString ls = gf.createLineString(new Coordinate[]{new Coordinate(10.0, 15.0), new Coordinate(20.0, 25.0)});
        ls.setUserData((Object)CRS.decode("urn:x-ogc:def:crs:EPSG:6.11.2:4326"));
        Intersects original = this.ff.intersects(geom, (Expression)this.ff.literal((Object)ls));
        Filter clone = (Filter)original.accept((FilterVisitor)this.reprojector, null);
        Assert.assertNotSame((Object)original, (Object)clone);
        Intersects isClone = (Intersects)clone;
        Assert.assertEquals((Object)isClone.getExpression1(), (Object)original.getExpression1());
        LineString clonedLs = (LineString)((Literal)isClone.getExpression2()).getValue();
        Assert.assertEquals((double)15.0, (double)clonedLs.getCoordinateN((int)0).x, (double)0.0);
        Assert.assertEquals((double)10.0, (double)clonedLs.getCoordinateN((int)0).y, (double)0.0);
        Assert.assertEquals((double)25.0, (double)clonedLs.getCoordinateN((int)1).x, (double)0.0);
        Assert.assertEquals((double)20.0, (double)clonedLs.getCoordinateN((int)1).y, (double)0.0);
        Assert.assertEquals((Object)CRS.decode("EPSG:4326"), (Object)clonedLs.getUserData());
    }

    @Test
    public void testIntersectsUnreferencedGeometry() throws Exception {
        GeometryFactory gf = new GeometryFactory();
        LineString ls = gf.createLineString(new Coordinate[]{new Coordinate(10.0, 15.0), new Coordinate(20.0, 25.0)});
        Intersects original = this.ff.intersects((Expression)this.ff.property("geom"), (Expression)this.ff.literal((Object)ls));
        Filter clone = (Filter)original.accept((FilterVisitor)this.reprojector, null);
        Assert.assertNotSame((Object)original, (Object)clone);
        Assert.assertEquals((Object)original, (Object)clone);
    }

    @Test
    public void testIntersectsReferencedGeometry() throws Exception {
        GeometryFactory gf = new GeometryFactory();
        LineString ls = gf.createLineString(new Coordinate[]{new Coordinate(10.0, 15.0), new Coordinate(20.0, 25.0)});
        ls.setUserData((Object)CRS.decode("urn:x-ogc:def:crs:EPSG:6.11.2:4326"));
        Intersects original = this.ff.intersects((Expression)this.ff.property("line"), (Expression)this.ff.literal((Object)ls));
        Filter clone = (Filter)original.accept((FilterVisitor)this.reprojector, null);
        Assert.assertNotSame((Object)original, (Object)clone);
        Intersects isClone = (Intersects)clone;
        Assert.assertEquals((Object)isClone.getExpression1(), (Object)original.getExpression1());
        LineString clonedLs = (LineString)isClone.getExpression2().evaluate(null);
        Assert.assertEquals((double)15.0, (double)clonedLs.getCoordinateN((int)0).x, (double)0.0);
        Assert.assertEquals((double)10.0, (double)clonedLs.getCoordinateN((int)0).y, (double)0.0);
        Assert.assertEquals((double)25.0, (double)clonedLs.getCoordinateN((int)1).x, (double)0.0);
        Assert.assertEquals((double)20.0, (double)clonedLs.getCoordinateN((int)1).y, (double)0.0);
        Assert.assertEquals((Object)CRS.decode("EPSG:4326"), (Object)clonedLs.getUserData());
    }

    @Test
    public void testPropertyEqualsFirstArgumentNotPropertyName() throws Exception {
        GeometryFactory gf = new GeometryFactory();
        LineString ls = gf.createLineString(new Coordinate[]{new Coordinate(10.0, 15.0), new Coordinate(20.0, 25.0)});
        ls.setUserData((Object)CRS.decode("urn:x-ogc:def:crs:EPSG:6.11.2:4326"));
        Function function = this.ff.function("geometryType", new Expression[]{this.ff.property("geom")});
        PropertyIsEqualTo original = this.ff.equals((Expression)this.ff.literal((Object)"Point"), (Expression)function);
        Filter clone = (Filter)original.accept((FilterVisitor)this.reprojector, null);
        Assert.assertNotSame((Object)original, (Object)clone);
        Assert.assertEquals((Object)original, (Object)clone);
        original = this.ff.equals((Expression)function, (Expression)this.ff.literal((Object)"Point"));
        clone = (Filter)original.accept((FilterVisitor)this.reprojector, null);
        Assert.assertNotSame((Object)original, (Object)clone);
        Assert.assertEquals((Object)original, (Object)clone);
    }

    @Test
    public void testIntersectsWithFunction() throws Exception {
        GeometryFunction function = new GeometryFunction();
        Intersects original = this.ff.intersects((Expression)this.ff.property("geom"), (Expression)function);
        Filter clone = (Filter)original.accept((FilterVisitor)this.reprojector, null);
        Assert.assertNotSame((Object)original, (Object)clone);
        Intersects isClone = (Intersects)clone;
        Assert.assertEquals((Object)isClone.getExpression1(), (Object)original.getExpression1());
        LineString clonedLs = (LineString)isClone.getExpression2().evaluate(null);
        Assert.assertEquals((double)15.0, (double)clonedLs.getCoordinateN((int)0).x, (double)0.0);
        Assert.assertEquals((double)10.0, (double)clonedLs.getCoordinateN((int)0).y, (double)0.0);
        Assert.assertEquals((double)25.0, (double)clonedLs.getCoordinateN((int)1).x, (double)0.0);
        Assert.assertEquals((double)20.0, (double)clonedLs.getCoordinateN((int)1).y, (double)0.0);
        Assert.assertEquals((Object)CRS.decode("EPSG:4326"), (Object)clonedLs.getUserData());
    }

    @Test
    public void testPropertyEqualWithFunction() throws Exception {
        GeometryFunction function = new GeometryFunction();
        PropertyIsEqualTo original = this.ff.equals((Expression)this.ff.property("geom"), (Expression)function);
        PropertyIsEqualTo clone = (PropertyIsEqualTo)original.accept((FilterVisitor)this.reprojector, null);
        Assert.assertNotSame((Object)original, (Object)clone);
        Assert.assertEquals((Object)clone.getExpression1(), (Object)original.getExpression1());
        LineString clonedLs = (LineString)clone.getExpression2().evaluate(null);
        Assert.assertEquals((double)15.0, (double)clonedLs.getCoordinateN((int)0).x, (double)0.0);
        Assert.assertEquals((double)10.0, (double)clonedLs.getCoordinateN((int)0).y, (double)0.0);
        Assert.assertEquals((double)25.0, (double)clonedLs.getCoordinateN((int)1).x, (double)0.0);
        Assert.assertEquals((double)20.0, (double)clonedLs.getCoordinateN((int)1).y, (double)0.0);
        Assert.assertEquals((Object)CRS.decode("EPSG:4326"), (Object)clonedLs.getUserData());
    }

    @Test
    public void testIntersectsFilterFunctionUnreferencedGeometry() throws Exception {
        GeometryFactory gf = new GeometryFactory();
        LineString ls = gf.createLineString(new Coordinate[]{new Coordinate(10.0, 15.0), new Coordinate(20.0, 25.0)});
        Function intersects = this.ff.function("intersects", new Expression[]{this.ff.property("geom"), this.ff.literal((Object)ls)});
        Function clone = (Function)intersects.accept((ExpressionVisitor)this.reprojector, null);
        Assert.assertNotSame((Object)intersects, (Object)clone);
        Assert.assertEquals(clone.getParameters().get(0), intersects.getParameters().get(0));
        Assert.assertEquals(clone.getParameters().get(1), intersects.getParameters().get(1));
    }

    @Test
    public void testIntersectsFilterFunctionReferencedGeometry() throws Exception {
        GeometryFactory gf = new GeometryFactory();
        LineString ls = gf.createLineString(new Coordinate[]{new Coordinate(10.0, 15.0), new Coordinate(20.0, 25.0)});
        ls.setUserData((Object)CRS.decode("urn:x-ogc:def:crs:EPSG:6.11.2:4326"));
        Function intersects = this.ff.function("intersects", new Expression[]{this.ff.property("geom"), this.ff.literal((Object)ls)});
        Function clone = (Function)intersects.accept((ExpressionVisitor)this.reprojector, null);
        Assert.assertNotSame((Object)intersects, (Object)clone);
        Assert.assertEquals(clone.getParameters().get(0), intersects.getParameters().get(0));
        Assert.assertNotEquals(clone.getParameters().get(1), intersects.getParameters().get(1));
        LineString clonedLs = (LineString)((Literal)clone.getParameters().get(1)).getValue();
        Assert.assertEquals((double)15.0, (double)clonedLs.getCoordinateN((int)0).x, (double)0.0);
        Assert.assertEquals((double)10.0, (double)clonedLs.getCoordinateN((int)0).y, (double)0.0);
        Assert.assertEquals((double)25.0, (double)clonedLs.getCoordinateN((int)1).x, (double)0.0);
        Assert.assertEquals((double)20.0, (double)clonedLs.getCoordinateN((int)1).y, (double)0.0);
        Assert.assertEquals((Object)CRS.decode("EPSG:4326"), (Object)clonedLs.getUserData());
    }

    @Test
    public void testBboxReprojectWithTargetCrsProvided() throws FactoryException {
        CoordinateReferenceSystem webMercator = CRS.decode("EPSG:3857");
        ReprojectingFilterVisitor reprojector = new ReprojectingFilterVisitor(this.ff, (FeatureType)this.ft, webMercator);
        BBOX bbox = this.ff.bbox((Expression)this.ff.property("geom"), 10.0, 15.0, 20.0, 25.0, "EPSG:4326");
        Filter clone = (Filter)bbox.accept((FilterVisitor)reprojector, null);
        Assert.assertNotSame((Object)bbox, (Object)clone);
        BBOX clonedBbox = (BBOX)clone;
        Assert.assertEquals((Object)bbox.getExpression1(), (Object)clonedBbox.getExpression1());
        Assert.assertTrue((boolean)JTS.equals((BoundingBox)new ReferencedEnvelope(1113194.9079327357, 2226389.8158654715, 1689200.1396078924, 2875744.6243522423, webMercator), (BoundingBox)clonedBbox.getBounds(), (double)1.0E-6));
    }

    @Test
    public void testTargetCrsProvidedButNoGeometryProperty() throws FactoryException {
        ReprojectingFilterVisitor reprojector = new ReprojectingFilterVisitor(this.ff, (FeatureType)this.ft, CRS.decode("EPSG:3857"));
        BBOX bbox = this.ff.bbox((Expression)this.ff.property("name"), 10.0, 15.0, 20.0, 25.0, "EPSG:4326");
        BBOX clone = (BBOX)bbox.accept((FilterVisitor)reprojector, null);
        Assert.assertNotSame((Object)bbox, (Object)clone);
        Assert.assertEquals((Object)bbox.getExpression1(), (Object)clone.getExpression1());
        Assert.assertTrue((boolean)JTS.equals((BoundingBox)new ReferencedEnvelope(10.0, 20.0, 15.0, 25.0, CRS.decode("EPSG:4326")), (BoundingBox)clone.getBounds(), (double)0.1));
    }

    private final class GeometryFunction
    implements Function {
        final LineString ls;

        public GeometryFunction() throws Exception {
            GeometryFactory gf = new GeometryFactory();
            this.ls = gf.createLineString(new Coordinate[]{new Coordinate(10.0, 15.0), new Coordinate(20.0, 25.0)});
            this.ls.setUserData((Object)CRS.decode("urn:x-ogc:def:crs:EPSG:6.11.2:4326"));
        }

        public String getName() {
            return "function";
        }

        public List<Expression> getParameters() {
            return Collections.emptyList();
        }

        public Object accept(ExpressionVisitor visitor, Object extraData) {
            return visitor.visit((Function)this, extraData);
        }

        public Object evaluate(Object object) {
            return this.ls;
        }

        public <T> T evaluate(Object object, Class<T> context) {
            return context.cast(this.ls);
        }

        public Literal getFallbackValue() {
            return null;
        }

        public FunctionName getFunctionName() {
            return new FunctionNameImpl("geometryfunction", new String[0]);
        }
    }
}

