/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.spatial;

import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.spatial.BBOX;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.NoSuchAuthorityCodeException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.data.DataUtilities;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.SchemaException;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.filter.spatial.BBOXImpl;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.PrecisionModel;

public class BBOXImplTest {
    FilterFactory ff = CommonFactoryFinder.getFilterFactory();

    @Test
    public void testBbox() {
        Coordinate[] coords;
        GeometryFactory gf = new GeometryFactory(new PrecisionModel());
        coords = new Coordinate[]{new Coordinate(0.0, 1.5), new Coordinate(0.0, 2.5), new Coordinate(1.5, 3.0), new Coordinate(4.0, 2.5), new Coordinate(0.5, 1.0), coords[0]};
        Polygon p = gf.createPolygon(gf.createLinearRing(coords), null);
        SimpleFeatureType type = null;
        try {
            type = DataUtilities.createType((String)"testSchema", (String)"name:String,*geom:Geometry");
        }
        catch (SchemaException e) {
            Logger.getGlobal().log(Level.INFO, "", e);
        }
        ArrayList<String> attributes = new ArrayList<String>();
        attributes.add("testFeature");
        attributes.add((String)p);
        SimpleFeature f = SimpleFeatureBuilder.build((SimpleFeatureType)type, (Object[])new Object[]{"testFeature", p}, null);
        Envelope e1 = new Envelope(3.0, 6.0, 0.0, 2.0);
        Envelope e2 = new Envelope(3.25, 3.75, 1.25, 1.75);
        Assert.assertTrue((boolean)e1.contains(e2));
        Assert.assertTrue((boolean)p.getEnvelopeInternal().contains(e2));
        Assert.assertTrue((boolean)p.getEnvelopeInternal().intersects(e1));
        BBOXImpl bbox1 = (BBOXImpl)this.ff.bbox((Expression)this.ff.property("geom"), e1.getMinX(), e1.getMinY(), e1.getMaxX(), e1.getMaxY(), "");
        BBOXImpl bbox2 = (BBOXImpl)this.ff.bbox((Expression)this.ff.property("geom"), e2.getMinX(), e2.getMinY(), e2.getMaxX(), e2.getMaxY(), "");
        Assert.assertFalse((boolean)bbox2.evaluate((Object)f));
        Assert.assertFalse((boolean)bbox1.evaluate((Object)f));
    }

    @Test
    public void testPreserveOriginalSRS() throws NoSuchAuthorityCodeException, FactoryException {
        String srs = "AUTO:42004,9001,0,33";
        CoordinateReferenceSystem crs = CRS.decode(srs);
        BBOX bbox = this.ff.bbox((Expression)this.ff.property(""), 0.0, 1000.0, 2000.0, 3000.0, srs);
        ReferencedEnvelope envelope = (ReferencedEnvelope)bbox.getExpression2().evaluate(null);
        Assert.assertEquals((Object)crs, (Object)envelope.getCoordinateReferenceSystem());
    }
}

