/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.measure.Unit;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.capability.FunctionName;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.Function;
import org.geotools.api.filter.expression.Literal;
import org.geotools.api.parameter.Parameter;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.function.CategorizeFunction;
import org.geotools.filter.function.Classifier;
import org.geotools.filter.function.Collection_AverageFunction;
import org.geotools.filter.function.Collection_BoundsFunction;
import org.geotools.filter.function.Collection_CountFunction;
import org.geotools.filter.function.Collection_MaxFunction;
import org.geotools.filter.function.Collection_MedianFunction;
import org.geotools.filter.function.Collection_MinFunction;
import org.geotools.filter.function.Collection_NearestFunction;
import org.geotools.filter.function.Collection_SumFunction;
import org.geotools.filter.function.Collection_UniqueFunction;
import org.geotools.filter.function.DefaultFunctionFactory;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;

public class FunctionToStringTest {
    static FilterFactory ff;
    private DefaultFunctionFactory functionFactory;
    private static List<String> collectionFunctionList;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        ff = CommonFactoryFinder.getFilterFactory(null);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        ff = null;
    }

    @Test
    public void testFunctionToStringMethod() {
        this.functionFactory = new DefaultFunctionFactory();
        List functionNameList = this.functionFactory.getFunctionNames();
        for (FunctionName functionName : functionNameList) {
            Expression expression = this.createExpression(functionName);
            Assert.assertNotNull((Object)expression);
            Assert.assertNotNull((Object)expression.toString());
            MatcherAssert.assertThat((Object)expression.toString(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"@")));
        }
    }

    private Expression createExpression(FunctionName functionName) {
        if (functionName == null) {
            return null;
        }
        ArrayList<Expression> parameters = new ArrayList<Expression>();
        Literal fallback = null;
        FunctionToStringTest.createNewFunctionParameters(functionName, parameters);
        Function function = this.functionFactory.function(functionName.getFunctionName(), parameters, fallback);
        return function;
    }

    private static void createNewFunctionParameters(FunctionName functionName, List<Expression> parameters) {
        String name = functionName.getName();
        if (collectionFunctionList.contains(name)) {
            parameters.add((Expression)ff.property("geom"));
        } else if (name.compareToIgnoreCase(CategorizeFunction.NAME.getName()) == 0) {
            for (int index = 0; index < functionName.getArguments().size() - 1; ++index) {
                parameters.add(index, (Expression)ff.literal((Object)""));
            }
            parameters.remove(parameters.size() - 1);
            parameters.add((Expression)ff.literal((Object)"preceding"));
        } else {
            List functionParamList = functionName.getArguments();
            for (Parameter param : functionParamList) {
                Class type = param.getType();
                if (type == Object.class) {
                    parameters.add((Expression)ff.literal((Object)""));
                    continue;
                }
                if (type == String.class) {
                    parameters.add((Expression)ff.literal((Object)""));
                    continue;
                }
                if (type == Number.class || type == Double.class) {
                    parameters.add((Expression)ff.literal(0.0));
                    continue;
                }
                if (type == Float.class) {
                    parameters.add((Expression)ff.literal(0.0f));
                    continue;
                }
                if (type == Integer.class || type == Long.class) {
                    parameters.add((Expression)ff.literal(0));
                    continue;
                }
                if (type == Boolean.class) {
                    parameters.add((Expression)ff.literal(false));
                    continue;
                }
                if (type == Unit.class) {
                    parameters.add(null);
                    continue;
                }
                if (type == Color.class) {
                    parameters.add(null);
                    continue;
                }
                if (type == Geometry.class) {
                    parameters.add(null);
                    continue;
                }
                if (type == LineString.class) {
                    parameters.add(null);
                    continue;
                }
                if (type == Classifier.class) {
                    parameters.add(null);
                    continue;
                }
                if (type == Class.class) {
                    parameters.add(null);
                    continue;
                }
                if (type.getName().compareToIgnoreCase("org.geotools.filter.function.color.AbstractHSLFunction$Method") == 0) {
                    parameters.add(null);
                    continue;
                }
                if (type.getName().compareToIgnoreCase("org.geotools.styling.visitor.RescalingMode") == 0) {
                    parameters.add((Expression)ff.literal(0));
                    continue;
                }
                Object newObj = null;
                try {
                    newObj = type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception e) {
                    Logger.getGlobal().log(Level.INFO, "", e);
                }
                parameters.add((Expression)ff.literal(newObj));
            }
        }
    }

    static {
        collectionFunctionList = Arrays.asList(Collection_AverageFunction.NAME.getName(), Collection_BoundsFunction.NAME.getName(), Collection_CountFunction.NAME.getName(), Collection_MaxFunction.NAME.getName(), Collection_MedianFunction.NAME.getName(), Collection_MinFunction.NAME.getName(), Collection_NearestFunction.NAME.getName(), Collection_SumFunction.NAME.getName(), Collection_UniqueFunction.NAME.getName());
    }
}

