/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import java.util.Collections;
import java.util.Date;
import org.geotools.api.filter.capability.FunctionName;
import org.geotools.api.parameter.Parameter;
import org.geotools.filter.FunctionImpl;
import org.geotools.filter.LiteralExpressionImpl;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.MultiPolygon;

public class FunctionImplTest {
    @Test
    public void testFunctionName() throws Exception {
        FunctionName fn = FunctionImpl.functionName((String)"foo", (String)"bar:Integer", (String[])new String[]{"a", "x:String:1,1", "y:MultiPolygon", "z:java.util.Date:1,"});
        Assert.assertEquals((Object)"foo", (Object)fn.getName());
        this.check(fn.getReturn(), "bar", Integer.class, 1, 1);
        this.check((Parameter)fn.getArguments().get(0), "a", Object.class, 1, 1);
        this.check((Parameter)fn.getArguments().get(1), "x", String.class, 1, 1);
        this.check((Parameter)fn.getArguments().get(2), "y", MultiPolygon.class, 1, 1);
        this.check((Parameter)fn.getArguments().get(3), "z", Date.class, 1, -1);
        fn = FunctionImpl.functionName((String)"foo", (String)"a", (String[])new String[]{"geom::1,1", "b:Object:,"});
        this.check((Parameter)fn.getArguments().get(0), "geom", Geometry.class, 1, 1);
        this.check((Parameter)fn.getArguments().get(1), "b", Object.class, -1, -1);
        fn = FunctionImpl.functionName((String)"foo", (String)"value", (String[])new String[]{"geom::,"});
        this.check((Parameter)fn.getArguments().get(0), "geom", Geometry.class, -1, -1);
    }

    @Test
    public void testToString() throws Exception {
        FunctionImpl func = new FunctionImpl();
        LiteralExpressionImpl param = new LiteralExpressionImpl(42);
        func.setName("TestFunction");
        func.setParameters(Collections.singletonList(param));
        String result = func.toString();
        Assert.assertEquals((Object)"TestFunction([42])", (Object)result);
    }

    void check(Parameter p, String name, Class type, int min, int max) {
        Assert.assertEquals((Object)name, (Object)p.getName());
        Assert.assertEquals((Object)type, (Object)p.getType());
        Assert.assertEquals((long)min, (long)p.getMinOccurs());
        Assert.assertEquals((long)max, (long)p.getMaxOccurs());
    }
}

