/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature;

import java.util.Arrays;
import java.util.List;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.api.feature.type.PropertyDescriptor;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.Or;
import org.geotools.api.filter.PropertyIsEqualTo;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.Function;
import org.geotools.api.filter.expression.PropertyName;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.AttributeTypeBuilder;
import org.geotools.feature.FeatureTypes;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.referencing.CRS;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.jts.geom.Point;

public class FeatureTypesTest {
    @Test
    public void testNoLength() {
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.setName("NoLength");
        builder.setCRS(null);
        builder.add("name", String.class);
        builder.add("geom", Point.class);
        SimpleFeatureType ft = builder.buildFeatureType();
        Assert.assertEquals((long)-1L, (long)FeatureTypes.getFieldLength((PropertyDescriptor)ft.getDescriptor("name")));
        Assert.assertEquals((long)-1L, (long)FeatureTypes.getFieldLength((PropertyDescriptor)ft.getDescriptor("geom")));
    }

    @Test
    public void testStandardLength() {
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.setName("StdLength");
        builder.setCRS(null);
        builder.length(20);
        builder.add("name", String.class);
        builder.add("geom", Point.class);
        SimpleFeatureType ft = builder.buildFeatureType();
        Assert.assertEquals((long)20L, (long)FeatureTypes.getFieldLength((PropertyDescriptor)ft.getDescriptor("name")));
        Assert.assertEquals((long)-1L, (long)FeatureTypes.getFieldLength((PropertyDescriptor)ft.getDescriptor("geom")));
    }

    @Test
    public void testCustomLengthExpressions() {
        AttributeTypeBuilder builder = new AttributeTypeBuilder();
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        Function length = ff.function("LengthFunction", new Expression[]{ff.property(".")});
        builder.addRestriction((Filter)ff.less((Expression)length, (Expression)ff.literal(20)));
        builder.setBinding(String.class);
        AttributeDescriptor attribute = builder.buildDescriptor("attribute");
        Assert.assertEquals((long)19L, (long)FeatureTypes.getFieldLength((PropertyDescriptor)attribute));
        builder.addRestriction((Filter)ff.greater((Expression)ff.literal(20), (Expression)length));
        builder.setBinding(String.class);
        attribute = builder.buildDescriptor("attribute");
        Assert.assertEquals((long)19L, (long)FeatureTypes.getFieldLength((PropertyDescriptor)attribute));
    }

    @Test
    public void testGetAncestors() {
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.setName("SomeFeature");
        builder.setCRS(null);
        builder.add("name", String.class);
        builder.add("geom", Point.class);
        SimpleFeatureType ft = builder.buildFeatureType();
        List types = FeatureTypes.getAncestors((FeatureType)ft);
        Assert.assertEquals((long)1L, (long)types.size());
        Assert.assertEquals((Object)"Feature", (Object)((FeatureType)types.get(0)).getName().getLocalPart());
    }

    @Test
    public void testEquals() {
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.setName("SomeFeature");
        builder.setCRS(null);
        builder.add("name", String.class);
        builder.add("geom1", Point.class);
        builder.add("geom2", Point.class);
        builder.setDefaultGeometry("geom1");
        SimpleFeatureType ft1 = builder.buildFeatureType();
        builder.setName("SomeFeature");
        builder.setCRS(null);
        builder.add("name", String.class);
        builder.add("geom1", Point.class);
        builder.add("geom2", Point.class);
        builder.setDefaultGeometry("geom1");
        SimpleFeatureType ft2 = builder.buildFeatureType();
        Assert.assertTrue((boolean)FeatureTypes.equalsExact((SimpleFeatureType)ft1, (SimpleFeatureType)ft2));
        builder.setName("SomeFeature");
        builder.setCRS(null);
        builder.add("name", String.class);
        builder.add("geom1", Point.class);
        builder.add("geom2", Point.class);
        builder.setDefaultGeometry("geom2");
        ft2 = builder.buildFeatureType();
        Assert.assertFalse((boolean)FeatureTypes.equalsExact((SimpleFeatureType)ft1, (SimpleFeatureType)ft2));
    }

    @Test
    public void testCreateFieldOptionsMulti() {
        Filter restriction = FeatureTypes.createFieldOptions(Arrays.asList("a", "b"));
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        PropertyName thisProperty = ff.property(".");
        Or expected = ff.or((Filter)ff.equal((Expression)thisProperty, (Expression)ff.literal((Object)"a"), true), (Filter)ff.equal((Expression)thisProperty, (Expression)ff.literal((Object)"b"), true));
        Assert.assertEquals((Object)expected, (Object)restriction);
    }

    @Test
    public void testCreateFieldOptionsSingle() {
        Filter restriction = FeatureTypes.createFieldOptions(Arrays.asList("a"));
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        PropertyName thisProperty = ff.property(".");
        PropertyIsEqualTo expected = ff.equal((Expression)thisProperty, (Expression)ff.literal((Object)"a"), true);
        Assert.assertEquals((Object)expected, (Object)restriction);
    }

    @Test
    public void testGetFieldOptionsMulti() {
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        PropertyName thisProperty = ff.property(".");
        Or restriction = ff.or((Filter)ff.equal((Expression)thisProperty, (Expression)ff.literal((Object)"a"), true), (Filter)ff.equal((Expression)thisProperty, (Expression)ff.literal((Object)"b"), true));
        AttributeDescriptor descriptor = this.buildDescriptorWithRestriction((Filter)restriction);
        Assert.assertEquals(Arrays.asList("a", "b"), (Object)FeatureTypes.getFieldOptions((PropertyDescriptor)descriptor));
    }

    @Test
    public void testGetFieldOptionsInvalid() {
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        PropertyName thisProperty = ff.property(".");
        Or restriction = ff.or((Filter)ff.equal((Expression)thisProperty, (Expression)ff.literal((Object)"a"), true), (Filter)ff.greaterOrEqual((Expression)thisProperty, (Expression)ff.literal(10), true));
        AttributeDescriptor descriptor = this.buildDescriptorWithRestriction((Filter)restriction);
        Assert.assertNull((Object)FeatureTypes.getFieldOptions((PropertyDescriptor)descriptor));
    }

    @Test
    public void testGetFieldOptionsSingle() {
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        PropertyName thisProperty = ff.property(".");
        PropertyIsEqualTo restriction = ff.equal((Expression)thisProperty, (Expression)ff.literal((Object)"a"), true);
        AttributeDescriptor descriptor = this.buildDescriptorWithRestriction((Filter)restriction);
        Assert.assertEquals(Arrays.asList("a"), (Object)FeatureTypes.getFieldOptions((PropertyDescriptor)descriptor));
    }

    @Test
    public void testGetFieldOptionsFromSuper() {
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        PropertyName thisProperty = ff.property(".");
        Or restriction = ff.or((Filter)ff.equal((Expression)thisProperty, (Expression)ff.literal((Object)"a"), true), (Filter)ff.greaterOrEqual((Expression)thisProperty, (Expression)ff.literal(10), true));
        AttributeDescriptor superDescriptor = this.buildDescriptorWithRestriction((Filter)restriction);
        AttributeTypeBuilder at = new AttributeTypeBuilder();
        at.name("test").binding(String.class).superType(superDescriptor.getType());
        AttributeDescriptor descriptor = at.buildDescriptor("test");
        Assert.assertNull((Object)FeatureTypes.getFieldOptions((PropertyDescriptor)descriptor));
    }

    public AttributeDescriptor buildDescriptorWithRestriction(Filter restriction) {
        AttributeTypeBuilder builder = new AttributeTypeBuilder();
        builder.addRestriction(restriction);
        builder.setBinding(String.class);
        return builder.buildDescriptor("attribute");
    }

    @Test
    public void testShouldNotReproject() throws FactoryException {
        DefaultGeographicCRS wgs84FromConstant = DefaultGeographicCRS.WGS84;
        String crsDefinition = "GEOGCS[\"WGS84(DD)\",DATUM[\"WGS84\",SPHEROID[\"WGS84\", 6378137.0, 298.257223563]],PRIMEM[\"Greenwich\", 0.0],UNIT[\"degree\", 0.017453292519943295],AXIS[\"Geodetic longitude\", EAST],AXIS[\"Geodetic latitude\",NORTH],AUTHORITY[\"EPSG\",\"4326\"]]";
        CoordinateReferenceSystem fromWKT = ReferencingFactoryFinder.getCRSFactory(null).createFromWKT(crsDefinition);
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.setName("NoLength");
        builder.setCRS(fromWKT);
        builder.add("name", String.class);
        builder.add("geom", Point.class, fromWKT);
        SimpleFeatureType ft = builder.buildFeatureType();
        boolean shouldReproject = FeatureTypes.shouldReproject((SimpleFeatureType)ft, (CoordinateReferenceSystem)wgs84FromConstant);
        Assert.assertFalse((boolean)shouldReproject);
    }

    @Test
    public void testShouldReproject() throws FactoryException {
        DefaultGeographicCRS wgs84FromConstant = DefaultGeographicCRS.WGS84;
        CoordinateReferenceSystem mercatorCRS = CRS.decode("EPSG:3857");
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.setName("NoLength");
        builder.setCRS(mercatorCRS);
        builder.add("name", String.class);
        builder.add("geom", Point.class, mercatorCRS);
        SimpleFeatureType ft = builder.buildFeatureType();
        boolean shouldReproject = FeatureTypes.shouldReproject((SimpleFeatureType)ft, (CoordinateReferenceSystem)wgs84FromConstant);
        Assert.assertTrue((boolean)shouldReproject);
    }
}

