/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.util;

import java.io.ByteArrayInputStream;
import java.io.StringReader;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLFeatureNotSupportedException;
import org.easymock.EasyMock;
import org.geotools.data.util.LobConverterFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LobConverterFactoryTest {
    private LobConverterFactory factory;

    @Before
    public void setUp() throws Exception {
        this.factory = new LobConverterFactory();
    }

    @Test
    public void testBlobConversionDirect() throws Exception {
        byte[] expected = new byte[]{1, 2, 3};
        Blob blob = (Blob)EasyMock.createMock(Blob.class);
        EasyMock.expect((Object)blob.length()).andReturn((Object)expected.length);
        EasyMock.expect((Object)blob.getBytes(1L, expected.length)).andReturn((Object)expected);
        EasyMock.replay((Object[])new Object[]{blob});
        byte[] actual = this.convert(blob);
        Assert.assertArrayEquals((byte[])expected, (byte[])actual);
    }

    @Test
    public void testEmptyBlobConversion() throws Exception {
        Blob blob = (Blob)EasyMock.createMock(Blob.class);
        EasyMock.expect((Object)blob.length()).andReturn((Object)0L);
        EasyMock.replay((Object[])new Object[]{blob});
        byte[] actual = this.convert(blob);
        Assert.assertEquals((long)0L, (long)actual.length);
    }

    @Test
    public void testTooLargeBlobConversion() throws Exception {
        Blob blob = (Blob)EasyMock.createMock(Blob.class);
        EasyMock.expect((Object)blob.length()).andReturn((Object)0x80000000L);
        EasyMock.replay((Object[])new Object[]{blob});
        byte[] actual = this.convert(blob);
        Assert.assertNull((Object)actual);
    }

    @Test
    public void testBlobConversionChunkwise() throws Exception {
        byte[] expected = new byte[]{1, 2, 3};
        ByteArrayInputStream is = new ByteArrayInputStream(expected);
        Blob blob = (Blob)EasyMock.createMock(Blob.class);
        EasyMock.expect((Object)blob.length()).andThrow((Throwable)new SQLFeatureNotSupportedException());
        EasyMock.expect((Object)blob.getBinaryStream()).andReturn((Object)is);
        EasyMock.replay((Object[])new Object[]{blob});
        byte[] actual = this.convert(blob);
        Assert.assertArrayEquals((byte[])expected, (byte[])actual);
    }

    @Test
    public void testClobConversionDirect() throws Exception {
        String expected = "abc";
        Clob clob = (Clob)EasyMock.createMock(Clob.class);
        EasyMock.expect((Object)clob.length()).andReturn((Object)expected.length());
        EasyMock.expect((Object)clob.getSubString(1L, expected.length())).andReturn((Object)expected);
        EasyMock.replay((Object[])new Object[]{clob});
        String actual = this.convert(clob);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testEmptyClobConversion() throws Exception {
        Clob clob = (Clob)EasyMock.createMock(Clob.class);
        EasyMock.expect((Object)clob.length()).andReturn((Object)0L);
        EasyMock.replay((Object[])new Object[]{clob});
        String actual = this.convert(clob);
        Assert.assertEquals((Object)"", (Object)actual);
    }

    @Test
    public void testTooLargeClobConversion() throws Exception {
        Clob clob = (Clob)EasyMock.createMock(Clob.class);
        EasyMock.expect((Object)clob.length()).andReturn((Object)0x80000000L);
        EasyMock.replay((Object[])new Object[]{clob});
        String actual = this.convert(clob);
        Assert.assertNull((Object)actual);
    }

    @Test
    public void testClobConversionChunkwise() throws Exception {
        String expected = "abc";
        try (StringReader reader = new StringReader(expected);){
            Clob clob = (Clob)EasyMock.createMock(Clob.class);
            EasyMock.expect((Object)clob.length()).andThrow((Throwable)new SQLFeatureNotSupportedException());
            EasyMock.expect((Object)clob.getCharacterStream()).andReturn((Object)reader);
            EasyMock.replay((Object[])new Object[]{clob});
            String actual = this.convert(clob);
            Assert.assertEquals((Object)expected, (Object)actual);
        }
    }

    private byte[] convert(Blob blob) throws Exception {
        return (byte[])this.factory.createConverter(blob.getClass(), byte[].class, null).convert((Object)blob, byte[].class);
    }

    private String convert(Clob clob) throws Exception {
        return (String)this.factory.createConverter(clob.getClass(), String.class, null).convert((Object)clob, String.class);
    }
}

