/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.crs;

import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.data.collection.ListFeatureCollection;
import org.geotools.data.crs.ForceCoordinateSystemIterator;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.referencing.crs.DefaultEngineeringCRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;

public class ForceCoordinateSystemFeatureIteratorTest {
    private static final String FEATURE_TYPE_NAME = "testType";

    @Before
    public void setUp() throws Exception {
    }

    private SimpleFeatureCollection createDatastore(CoordinateReferenceSystem crs, Point p) throws Exception {
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.setName(FEATURE_TYPE_NAME);
        builder.setCRS(crs);
        builder.add("geom", Point.class);
        SimpleFeatureType ft = builder.buildFeatureType();
        SimpleFeatureBuilder b = new SimpleFeatureBuilder(ft);
        b.add((Object)p);
        ListFeatureCollection features = new ListFeatureCollection(ft);
        features.add(b.buildFeature(null));
        return features;
    }

    @Test
    public void testSameCRS() throws Exception {
        DefaultGeographicCRS crs = DefaultGeographicCRS.WGS84;
        GeometryFactory fac = new GeometryFactory();
        Point p = fac.createPoint(new Coordinate(10.0, 10.0));
        SimpleFeatureCollection collection = this.createDatastore(crs, p);
        try (SimpleFeatureIterator original = collection.features();
             ForceCoordinateSystemIterator modified = new ForceCoordinateSystemIterator((FeatureIterator)collection.features(), (SimpleFeatureType)collection.getSchema(), (CoordinateReferenceSystem)crs);){
            SimpleFeature f1 = (SimpleFeature)original.next();
            SimpleFeature f2 = modified.next();
            Assert.assertEquals((Object)f1, (Object)f2);
            Assert.assertFalse((boolean)original.hasNext());
            Assert.assertFalse((boolean)modified.hasNext());
        }
    }

    @Test
    public void testDifferentCRS() throws Exception {
        DefaultGeographicCRS srcCRS = DefaultGeographicCRS.WGS84;
        GeometryFactory fac = new GeometryFactory();
        Point p = fac.createPoint(new Coordinate(10.0, 10.0));
        SimpleFeatureCollection collection = this.createDatastore(srcCRS, p);
        DefaultEngineeringCRS destCRS = DefaultEngineeringCRS.CARTESIAN_2D;
        try (SimpleFeatureIterator original = collection.features();
             ForceCoordinateSystemIterator modified = new ForceCoordinateSystemIterator((FeatureIterator)collection.features(), (SimpleFeatureType)collection.getSchema(), (CoordinateReferenceSystem)destCRS);){
            SimpleFeature f1 = (SimpleFeature)original.next();
            SimpleFeature f2 = modified.next();
            Assert.assertEquals((Object)((Geometry)f1.getDefaultGeometry()).getCoordinate(), (Object)((Geometry)f2.getDefaultGeometry()).getCoordinate());
            Assert.assertNotEquals((Object)f1.getFeatureType().getCoordinateReferenceSystem(), (Object)f2.getFeatureType().getCoordinateReferenceSystem());
            Assert.assertEquals((Object)srcCRS, (Object)f1.getFeatureType().getCoordinateReferenceSystem());
            Assert.assertEquals((Object)srcCRS, (Object)f1.getFeatureType().getGeometryDescriptor().getCoordinateReferenceSystem());
            Assert.assertEquals((Object)destCRS, (Object)f2.getFeatureType().getCoordinateReferenceSystem());
            Assert.assertEquals((Object)destCRS, (Object)f2.getFeatureType().getGeometryDescriptor().getCoordinateReferenceSystem());
            Assert.assertFalse((boolean)original.hasNext());
            Assert.assertFalse((boolean)modified.hasNext());
            Assert.assertNotNull((Object)modified.builder);
        }
    }

    @Test
    public void testNullDestination() throws Exception {
        DefaultGeographicCRS crs = DefaultGeographicCRS.WGS84;
        GeometryFactory fac = new GeometryFactory();
        Point p = fac.createPoint(new Coordinate(10.0, 10.0));
        SimpleFeatureCollection collection = this.createDatastore(crs, p);
        try {
            new ForceCoordinateSystemIterator((FeatureIterator)collection.features(), (SimpleFeatureType)collection.getSchema(), null);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testNullSource() throws Exception {
        CoordinateReferenceSystem srcCRS = null;
        GeometryFactory fac = new GeometryFactory();
        Point p = fac.createPoint(new Coordinate(10.0, 10.0));
        SimpleFeatureCollection collection = this.createDatastore(srcCRS, p);
        DefaultEngineeringCRS destCRS = DefaultEngineeringCRS.CARTESIAN_2D;
        try (SimpleFeatureIterator original = collection.features();
             ForceCoordinateSystemIterator modified = new ForceCoordinateSystemIterator((FeatureIterator)collection.features(), (SimpleFeatureType)collection.getSchema(), (CoordinateReferenceSystem)destCRS);){
            SimpleFeature f1 = (SimpleFeature)original.next();
            SimpleFeature f2 = modified.next();
            Assert.assertEquals((Object)((Geometry)f1.getDefaultGeometry()).getCoordinate(), (Object)((Geometry)f2.getDefaultGeometry()).getCoordinate());
            Assert.assertNotEquals((Object)f2.getFeatureType().getCoordinateReferenceSystem(), (Object)f1.getFeatureType().getCoordinateReferenceSystem());
            Assert.assertEquals(srcCRS, (Object)f1.getFeatureType().getCoordinateReferenceSystem());
            Assert.assertEquals(srcCRS, (Object)f1.getFeatureType().getGeometryDescriptor().getCoordinateReferenceSystem());
            Assert.assertEquals((Object)destCRS, (Object)f2.getFeatureType().getCoordinateReferenceSystem());
            Assert.assertEquals((Object)destCRS, (Object)f2.getFeatureType().getGeometryDescriptor().getCoordinateReferenceSystem());
            Assert.assertFalse((boolean)original.hasNext());
            Assert.assertFalse((boolean)modified.hasNext());
            Assert.assertNotNull((Object)modified.builder);
        }
    }
}

