/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data;

import java.awt.RenderingHints;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.geotools.api.data.DataSourceException;
import org.geotools.api.data.DataStore;
import org.geotools.api.data.FeatureReader;
import org.geotools.api.data.FeatureSource;
import org.geotools.api.data.Query;
import org.geotools.api.data.SimpleFeatureReader;
import org.geotools.api.data.SimpleFeatureSource;
import org.geotools.api.feature.IllegalAttributeException;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.api.feature.type.AttributeType;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.api.feature.type.Name;
import org.geotools.api.filter.And;
import org.geotools.api.filter.BinaryLogicOperator;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.Id;
import org.geotools.api.filter.PropertyIsBetween;
import org.geotools.api.filter.PropertyIsEqualTo;
import org.geotools.api.filter.PropertyIsLike;
import org.geotools.api.filter.PropertyIsNull;
import org.geotools.api.filter.expression.Add;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.Function;
import org.geotools.api.filter.expression.PropertyName;
import org.geotools.api.filter.sort.SortBy;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.data.DataTestCase;
import org.geotools.data.DataUtilities;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FakeTypes;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureTypes;
import org.geotools.feature.NameImpl;
import org.geotools.feature.SchemaException;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.feature.type.AttributeDescriptorImpl;
import org.geotools.feature.type.AttributeTypeImpl;
import org.geotools.filter.IllegalFilterException;
import org.geotools.geometry.jts.GeometryBuilder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.util.factory.Hints;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

public class DataUtilitiesTest
extends DataTestCase {
    @Test
    public void testSimpleCollection() {
        SimpleFeatureCollection featureCollection = DataUtilities.collection((SimpleFeature[])this.roadFeatures);
        SimpleFeatureCollection simple = DataUtilities.simple((FeatureCollection)featureCollection);
        Assert.assertSame((Object)simple, (Object)featureCollection);
        Assert.assertEquals((long)this.roadFeatures.length, (long)featureCollection.size());
    }

    @Test
    public void testSimpleCollectionList() {
        SimpleFeatureCollection featureCollection = DataUtilities.collection(Arrays.asList(this.roadFeatures));
        Assert.assertEquals((long)this.roadFeatures.length, (long)featureCollection.size());
    }

    @Test
    public void testSimpleSource() {
        SimpleFeatureCollection collection = DataUtilities.collection((SimpleFeature[])this.roadFeatures);
        SimpleFeatureSource source = DataUtilities.source((FeatureCollection)collection);
        SimpleFeatureSource simple = DataUtilities.simple((FeatureSource)source);
        Assert.assertSame((Object)simple, (Object)source);
    }

    @Test
    public void testSimpleType() throws DataSourceException {
        SimpleFeatureType simpleFeatureType = DataUtilities.simple((FeatureType)FakeTypes.Mine.MINETYPE_TYPE);
        Assert.assertNull((Object)simpleFeatureType.getGeometryDescriptor());
    }

    @Test
    public void testDataStore() throws IOException {
        SimpleFeatureSource features = DataUtilities.source((SimpleFeature[])this.roadFeatures);
        Name name = features.getName();
        String typeName = name.getLocalPart();
        DataStore store = DataUtilities.dataStore((SimpleFeatureSource)features);
        Assert.assertSame((Object)features.getSchema(), (Object)store.getSchema(name));
        Assert.assertSame((Object)features.getSchema(), (Object)store.getSchema(typeName));
        Assert.assertSame((Object)features, (Object)store.getFeatureSource(name));
        Assert.assertSame((Object)features, (Object)store.getFeatureSource(typeName));
        Assert.assertEquals((Object)name, store.getNames().get(0));
        Assert.assertEquals((Object)typeName, (Object)store.getTypeNames()[0]);
    }

    @Test
    public void testFirst() {
        SimpleFeatureCollection collection = DataUtilities.collection((SimpleFeature[])this.roadFeatures);
        SimpleFeature first = (SimpleFeature)DataUtilities.first((FeatureCollection)collection);
        Assert.assertNotNull((Object)first);
        Assert.assertEquals((Object)"road.rd1", (Object)first.getID());
    }

    @Test
    public void testCheckDirectory() {
        File home = new File(System.getProperty("user.home"));
        File file = DataUtilities.checkDirectory((File)home);
        Assert.assertNotNull((Object)file);
        File missing = new File(home, ".missing");
        try {
            File found = DataUtilities.checkDirectory((File)missing);
            Assert.assertNull((Object)found);
            Assert.fail((String)"Missing should not be found");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testReadable() {
        File home = new File(System.getProperty("user.home"));
        Assert.assertFalse((String)"Home is not a readable file", (boolean)DataUtilities.checkFileReadable((File)home, null));
        FilenameFilter findFilter = (dir, name) -> {
            File target = new File(dir, name);
            return target.isFile() && target.canRead();
        };
        File[] readable = home.listFiles(findFilter);
        if (readable.length > 0) {
            File test = readable[0];
            Assert.assertTrue((String)test.toString(), (boolean)DataUtilities.checkFileReadable((File)test, null));
        }
    }

    @Test
    public void testFilters() {
        File home = new File(System.getProperty("user.home"));
        FilenameFilter directoryFilter = (dir, name) -> {
            File target = new File(dir, name);
            return target.isDirectory();
        };
        FilenameFilter hiddenFilter = (dir, name) -> {
            File target = new File(dir, name);
            return target.isHidden();
        };
        List<String> dir2 = Arrays.asList(home.list(directoryFilter));
        List<String> hidden = Arrays.asList(home.list(hiddenFilter));
        FilenameFilter includeFilter = DataUtilities.includeFilters((FilenameFilter)directoryFilter, (FilenameFilter[])new FilenameFilter[]{hiddenFilter});
        List<String> include = Arrays.asList(home.list(includeFilter));
        HashSet<String> both = new HashSet<String>();
        both.addAll(dir2);
        both.addAll(hidden);
        Assert.assertEquals((long)both.size(), (long)include.size());
        FilenameFilter excludeFilter = DataUtilities.excludeFilters((FilenameFilter)directoryFilter, (FilenameFilter[])new FilenameFilter[]{hiddenFilter});
        List<String> exclude = Arrays.asList(home.list(excludeFilter));
        HashSet<String> subtract = new HashSet<String>(dir2);
        subtract.removeAll(hidden);
        Assert.assertEquals((long)subtract.size(), (long)exclude.size());
    }

    @Test
    public void testAttributeNamesFeatureType() {
        String[] names = DataUtilities.attributeNames((SimpleFeatureType)this.roadType);
        Assert.assertEquals((long)4L, (long)names.length);
        Assert.assertEquals((Object)"id", (Object)names[0]);
        Assert.assertEquals((Object)"geom", (Object)names[1]);
        Assert.assertEquals((Object)"name", (Object)names[2]);
        Assert.assertEquals((Object)"uuid", (Object)names[3]);
        names = DataUtilities.attributeNames((SimpleFeatureType)this.subRoadType);
        Assert.assertEquals((long)2L, (long)names.length);
        Assert.assertEquals((Object)"id", (Object)names[0]);
        Assert.assertEquals((Object)"geom", (Object)names[1]);
    }

    @Test
    public void testAttributeNamesFilter() throws IllegalFilterException {
        FilterFactory factory = CommonFactoryFinder.getFilterFactory(null);
        Filter filter = null;
        String[] names = DataUtilities.attributeNames(filter);
        Assert.assertEquals((long)names.length, (long)0L);
        Id fidFilter = factory.id(Collections.singleton(factory.featureId("fid")));
        names = DataUtilities.attributeNames((Filter)fidFilter);
        Assert.assertEquals((long)0L, (long)names.length);
        PropertyName id = factory.property("id");
        PropertyName name = factory.property("name");
        PropertyName geom = factory.property("geom");
        PropertyIsNull nullFilter = factory.isNull((Expression)id);
        names = DataUtilities.attributeNames((Filter)nullFilter);
        Assert.assertEquals((long)1L, (long)names.length);
        Assert.assertEquals((Object)"id", (Object)names[0]);
        PropertyIsEqualTo equal = factory.equals((Expression)name, (Expression)id);
        names = DataUtilities.attributeNames((Filter)equal);
        Assert.assertEquals((long)2L, (long)names.length);
        List<String> list = Arrays.asList(names);
        Assert.assertTrue((boolean)list.contains("name"));
        Assert.assertTrue((boolean)list.contains("id"));
        Function fnCall = factory.function("Max", new Expression[]{id, name});
        PropertyIsLike fn = factory.like((Expression)fnCall, "does-not-matter");
        names = DataUtilities.attributeNames((Filter)fn);
        list = Arrays.asList(names);
        Assert.assertTrue((boolean)list.contains("name"));
        Assert.assertTrue((boolean)list.contains("id"));
        PropertyIsBetween between = factory.between((Expression)name, (Expression)id, (Expression)geom);
        names = DataUtilities.attributeNames((Filter)between);
        Assert.assertEquals((long)3L, (long)names.length);
        list = Arrays.asList(names);
        Assert.assertTrue((boolean)list.contains("name"));
        Assert.assertTrue((boolean)list.contains("id"));
        Assert.assertTrue((boolean)list.contains("geom"));
        PropertyIsNull geomNull = factory.isNull((Expression)geom);
        names = DataUtilities.attributeNames((Filter)factory.and((Filter)geomNull, (Filter)equal));
        Assert.assertEquals((long)3L, (long)names.length);
        list = Arrays.asList(names);
        Assert.assertTrue((boolean)list.contains("name"));
        Assert.assertTrue((boolean)list.contains("id"));
        Assert.assertTrue((boolean)list.contains("geom"));
        names = DataUtilities.attributeNames((Filter)factory.not((Filter)geomNull));
        Assert.assertEquals((long)1L, (long)names.length);
        Assert.assertEquals((Object)"geom", (Object)names[0]);
        PropertyIsEqualTo equalToWithPrefix = factory.equals((Expression)factory.property("gml:name"), (Expression)id);
        names = DataUtilities.attributeNames((Filter)equalToWithPrefix, (SimpleFeatureType)this.roadType);
        Assert.assertEquals((long)2L, (long)names.length);
        list = Arrays.asList(names);
        Assert.assertTrue((boolean)list.contains("name"));
        Assert.assertTrue((boolean)list.contains("id"));
    }

    @Test
    public void testAttributeNamesFilterFeatureType() {
        FilterFactory factory = CommonFactoryFinder.getFilterFactory(null);
        PropertyIsEqualTo filter = factory.equals((Expression)factory.property("id"), (Expression)factory.add((Expression)factory.property("geom"), (Expression)factory.property("gml:name")));
        String[] names = DataUtilities.attributeNames((Filter)filter, (SimpleFeatureType)this.roadType);
        Assert.assertEquals((long)3L, (long)names.length);
        List<String> namesList = Arrays.asList(names);
        Assert.assertTrue((boolean)namesList.contains("id"));
        Assert.assertTrue((boolean)namesList.contains("geom"));
        Assert.assertTrue((boolean)namesList.contains("name"));
    }

    @Test
    public void testAttributeExpressionFilterFeatureType() {
        FilterFactory factory = CommonFactoryFinder.getFilterFactory(null);
        Add expression = factory.add((Expression)factory.property("geom"), (Expression)factory.property("gml:name"));
        String[] names = DataUtilities.attributeNames((Expression)expression, (SimpleFeatureType)this.roadType);
        Assert.assertEquals((long)2L, (long)names.length);
        List<String> namesList = Arrays.asList(names);
        Assert.assertTrue((boolean)namesList.contains("geom"));
        Assert.assertTrue((boolean)namesList.contains("name"));
    }

    @Test
    public void testCompare() throws SchemaException {
        Assert.assertEquals((long)0L, (long)DataUtilities.compare(null, null));
        Assert.assertEquals((long)-1L, (long)DataUtilities.compare((SimpleFeatureType)this.roadType, null));
        Assert.assertEquals((long)-1L, (long)DataUtilities.compare(null, (SimpleFeatureType)this.roadType));
        Assert.assertEquals((long)-1L, (long)DataUtilities.compare((SimpleFeatureType)this.riverType, (SimpleFeatureType)this.roadType));
        Assert.assertEquals((long)-1L, (long)DataUtilities.compare((SimpleFeatureType)this.roadType, (SimpleFeatureType)this.riverType));
        Assert.assertEquals((long)0L, (long)DataUtilities.compare((SimpleFeatureType)this.roadType, (SimpleFeatureType)this.roadType));
        Assert.assertEquals((long)1L, (long)DataUtilities.compare((SimpleFeatureType)this.subRoadType, (SimpleFeatureType)this.roadType));
        SimpleFeatureType road2 = DataUtilities.createType((String)"namespace.road", (String)"geom:LineString,name:String,id:0");
        Assert.assertEquals((long)1L, (long)DataUtilities.compare((SimpleFeatureType)road2, (SimpleFeatureType)this.roadType));
        SimpleFeatureType road3 = DataUtilities.createType((String)"test.road", (String)"id:0,geom:LineString,name:String,uuid:UUID");
        Assert.assertEquals((long)0L, (long)DataUtilities.compare((SimpleFeatureType)road3, (SimpleFeatureType)this.roadType));
        SimpleFeatureType road4 = DataUtilities.createType((String)"road", (String)"id:0,geom:LineString,name:String,uuid:String");
        Assert.assertEquals((long)-1L, (long)DataUtilities.compare((SimpleFeatureType)road4, (SimpleFeatureType)this.roadType));
    }

    @Test
    public void testCompareNames() throws SchemaException {
        Assert.assertEquals((long)0L, (long)DataUtilities.compareNames(null, null));
        Assert.assertEquals((long)-1L, (long)DataUtilities.compareNames((SimpleFeatureType)this.roadType, null));
        Assert.assertEquals((long)-1L, (long)DataUtilities.compareNames(null, (SimpleFeatureType)this.roadType));
        Assert.assertEquals((long)-1L, (long)DataUtilities.compareNames((SimpleFeatureType)this.riverType, (SimpleFeatureType)this.roadType));
        Assert.assertEquals((long)-1L, (long)DataUtilities.compareNames((SimpleFeatureType)this.roadType, (SimpleFeatureType)this.riverType));
        Assert.assertEquals((long)0L, (long)DataUtilities.compareNames((SimpleFeatureType)this.roadType, (SimpleFeatureType)this.roadType));
        Assert.assertEquals((long)1L, (long)DataUtilities.compareNames((SimpleFeatureType)this.subRoadType, (SimpleFeatureType)this.roadType));
        SimpleFeatureType road2 = DataUtilities.createType((String)"namespace.road", (String)"geom:LineString,name:String,id:0");
        Assert.assertEquals((long)1L, (long)DataUtilities.compareNames((SimpleFeatureType)road2, (SimpleFeatureType)this.roadType));
        SimpleFeatureType road3 = DataUtilities.createType((String)"test.road", (String)"id:0,geom:LineString,name:String,uuid:UUID");
        Assert.assertEquals((long)0L, (long)DataUtilities.compareNames((SimpleFeatureType)road3, (SimpleFeatureType)this.roadType));
        SimpleFeatureType road4 = DataUtilities.createType((String)"road", (String)"id:0,geom:LineString,name:String,uuid:String");
        Assert.assertEquals((long)0L, (long)DataUtilities.compareNames((SimpleFeatureType)road4, (SimpleFeatureType)this.roadType));
        SimpleFeatureType road5 = DataUtilities.createType((String)"road", (String)"id:0,uuid:String,geom:LineString,name:String");
        Assert.assertEquals((long)1L, (long)DataUtilities.compareNames((SimpleFeatureType)road5, (SimpleFeatureType)this.roadType));
    }

    @Test
    public void testIsMatch() throws SchemaException {
        SimpleFeatureType roadType1 = DataUtilities.createType((String)"road", (String)"id:0,geom:LineString,name:String,uuid:String");
        Assert.assertFalse((boolean)DataUtilities.isMatch((AttributeDescriptor)this.roadType.getDescriptor("uuid"), (AttributeDescriptor)roadType1.getDescriptor("uuid")));
        Assert.assertTrue((boolean)DataUtilities.isMatch((AttributeDescriptor)this.roadType.getDescriptor("uuid"), (AttributeDescriptor)roadType1.getDescriptor("uuid"), (boolean)false));
        SimpleFeatureType roadType2 = DataUtilities.createType((String)"road", (String)"id:0,the_geom:LineString,name:String,uuid:UUID");
        Assert.assertFalse((boolean)DataUtilities.isMatch((AttributeDescriptor)this.roadType.getDescriptor("geom"), (AttributeDescriptor)roadType2.getDescriptor("the_geom")));
        Assert.assertFalse((boolean)DataUtilities.isMatch((AttributeDescriptor)this.roadType.getDescriptor("geom"), (AttributeDescriptor)roadType2.getDescriptor("the_geom"), (boolean)false));
        SimpleFeatureType roadType3 = DataUtilities.createType((String)"road", (String)"id:0,the_geom:LineString,geom:String,name:String,uuid:UUID");
        Assert.assertFalse((boolean)DataUtilities.isMatch((AttributeDescriptor)this.roadType.getDescriptor("geom"), (AttributeDescriptor)roadType3.getDescriptor("geom")));
        Assert.assertTrue((boolean)DataUtilities.isMatch((AttributeDescriptor)this.roadType.getDescriptor("geom"), (AttributeDescriptor)roadType3.getDescriptor("geom"), (boolean)false));
    }

    @Test
    public void testReType() throws Exception {
        SimpleFeature rd1 = this.roadFeatures[0];
        Assert.assertEquals((Object)rd1, (Object)rd1);
        SimpleFeature rdDuplicate = SimpleFeatureBuilder.copy((SimpleFeature)rd1);
        Assert.assertEquals((Object)rd1, (Object)rdDuplicate);
        Assert.assertNotSame((Object)rd1, (Object)rdDuplicate);
        SimpleFeature rd2 = DataUtilities.reType((SimpleFeatureType)this.roadType, (SimpleFeature)rd1);
        Assert.assertEquals((Object)rd1, (Object)rd2);
        Assert.assertNotSame((Object)rd1, (Object)rd2);
        SimpleFeature rd3 = DataUtilities.reType((SimpleFeatureType)this.subRoadType, (SimpleFeature)rd1);
        Assert.assertNotEquals((Object)rd1, (Object)rd3);
        Assert.assertEquals((long)2L, (long)rd3.getAttributeCount());
        Assert.assertEquals((Object)rd1.getID(), (Object)rd3.getID());
        Assert.assertEquals((Object)rd1.getAttribute("id"), (Object)rd3.getAttribute("id"));
        Assert.assertEquals((Object)((Geometry)rd1.getAttribute("geom")), (Object)((Geometry)rd3.getAttribute("geom")));
        Assert.assertNotNull((Object)rd3.getDefaultGeometry());
        SimpleFeature rv1 = this.riverFeatures[0];
        Assert.assertEquals((Object)rv1, (Object)rv1);
        SimpleFeature rvDuplicate = SimpleFeatureBuilder.copy((SimpleFeature)rv1);
        Assert.assertEquals((Object)rv1, (Object)rvDuplicate);
        Assert.assertNotSame((Object)rv1, (Object)rvDuplicate);
        SimpleFeature rv2 = DataUtilities.reType((SimpleFeatureType)this.riverType, (SimpleFeature)rv1);
        Assert.assertEquals((Object)rv1, (Object)rv2);
        Assert.assertNotSame((Object)rv1, (Object)rv2);
        SimpleFeature rv3 = DataUtilities.reType((SimpleFeatureType)this.subRiverType, (SimpleFeature)rv1);
        Assert.assertNotEquals((Object)rv1, (Object)rv3);
        Assert.assertEquals((long)2L, (long)rv3.getAttributeCount());
        Assert.assertEquals((Object)rv1.getID(), (Object)rv3.getID());
        Assert.assertEquals((Object)rv1.getAttribute("name"), (Object)rv3.getAttribute("name"));
        Assert.assertEquals((Object)rv1.getAttribute("flow"), (Object)rv3.getAttribute("flow"));
        Assert.assertNull((Object)rv3.getDefaultGeometry());
    }

    @Test
    public void testCreate() throws Exception {
        SimpleFeatureType featureType = DataUtilities.createType((String)"Contact", (String)"id:Integer,party:String,geom:Geometry:srid=4326");
        SimpleFeature feature1 = DataUtilities.createFeature((SimpleFeatureType)featureType, (String)"fid1=1|Jody Garnett\\nSteering Committee|POINT(1 2)");
        SimpleFeature feature2 = DataUtilities.createFeature((SimpleFeatureType)featureType, (String)"2|John Hudson\\|Hapless Victim|POINT(6 2)");
        Assert.assertNotNull((Object)featureType.getCoordinateReferenceSystem());
        Geometry geometry = (Geometry)feature1.getAttribute("geom");
        Assert.assertEquals((String)"geom", (double)2.0, (double)geometry.getCoordinate().y, (double)0.0);
        Assert.assertEquals((String)"fid preservation", (Object)"fid1", (Object)feature1.getID());
        Assert.assertEquals((String)"newline decode check", (Object)"Jody Garnett\nSteering Committee", (Object)feature1.getAttribute("party"));
        Assert.assertEquals((String)"escape check", (Object)"John Hudson|Hapless Victim", (Object)feature2.getAttribute("party"));
        Assert.assertEquals((Object)"fid1", (Object)feature1.getID());
        Assert.assertNotNull((Object)feature2.getID());
        Assert.assertEquals((Object)feature2.getID(), (Object)feature2.getIdentifier().getID());
        GeometryBuilder geomBuilder = new GeometryBuilder();
        Assert.assertEquals((Object)geomBuilder.point(6.0, 2.0), (Object)feature2.getDefaultGeometry());
        Assert.assertEquals((Object)geomBuilder.point(6.0, 2.0), (Object)feature2.getAttribute("geom"));
    }

    @Test
    public void testEncode() throws Exception {
        SimpleFeatureType featureType = DataUtilities.createType((String)"Contact", (String)"id:Integer,party:String,geom:Geometry:srid=4326");
        SimpleFeature feature1 = DataUtilities.createFeature((SimpleFeatureType)featureType, (String)"fid1=1|Jody Garnett\\nSteering Committee|POINT (1 2)");
        String spec = DataUtilities.encodeType((SimpleFeatureType)featureType);
        Assert.assertEquals((Object)"id:Integer,party:String,geom:Geometry:srid=4326", (Object)spec);
        String text = DataUtilities.encodeFeature((SimpleFeature)feature1);
        Assert.assertEquals((Object)"fid1=1|Jody Garnett\\nSteering Committee|POINT (1 2)", (Object)text);
    }

    @Test
    public void testDecodeGeometrySpec() throws Exception {
        SimpleFeatureType featureType1 = DataUtilities.createType((String)"Contact", (String)"id:Integer,party:String,geom:Geometry");
        SimpleFeatureType featureType2 = DataUtilities.createType((String)"Contact", (String)"id:Integer,party:String,geom:org.locationtech.jts.geom.Geometry");
        Assert.assertEquals((Object)featureType1, (Object)featureType2);
        featureType2 = DataUtilities.createType((String)"Contact", (String)"id:Integer,party:String,geom:com.vividsolutions.jts.geom.Geometry");
        Assert.assertEquals((Object)featureType1, (Object)featureType2);
        Assert.assertEquals((Object)DataUtilities.createAttribute((String)"point:Point"), (Object)DataUtilities.createAttribute((String)"point:com.vividsolutions.jts.geom.Point"));
        Assert.assertEquals((Object)DataUtilities.createAttribute((String)"point:Point"), (Object)DataUtilities.createAttribute((String)"point:org.locationtech.jts.geom.Point"));
        Assert.assertEquals((Object)DataUtilities.createAttribute((String)"area:Polygon"), (Object)DataUtilities.createAttribute((String)"area:com.vividsolutions.jts.geom.Polygon"));
    }

    @Test
    public void testTemplateFeatureType() throws IllegalAttributeException {
        SimpleFeature feature = DataUtilities.template((SimpleFeatureType)this.roadType);
        Assert.assertNotNull((Object)feature);
        Assert.assertEquals((long)this.roadType.getAttributeCount(), (long)feature.getAttributeCount());
    }

    @Test
    public void testTemplateFeatureTypeString() throws IllegalAttributeException {
        SimpleFeature feature = DataUtilities.template((SimpleFeatureType)this.roadType, (String)"Foo");
        Assert.assertNotNull((Object)feature);
        Assert.assertEquals((long)this.roadType.getAttributeCount(), (long)feature.getAttributeCount());
        Assert.assertEquals((Object)"Foo", (Object)feature.getID());
        Assert.assertNull((Object)feature.getAttribute("name"));
        Assert.assertNull((Object)feature.getAttribute("id"));
        Assert.assertNull((Object)feature.getAttribute("geom"));
    }

    @Test
    public void testDefaultValues() throws IllegalAttributeException {
        Object[] values = DataUtilities.defaultValues((SimpleFeatureType)this.roadType);
        Assert.assertNotNull((Object)values);
        Assert.assertEquals((long)values.length, (long)this.roadType.getAttributeCount());
    }

    @Test
    public void testDefaultValue() throws IllegalAttributeException {
        Assert.assertNull((Object)this.roadType.getDescriptor("name").getDefaultValue());
        Assert.assertNull((Object)this.roadType.getDescriptor("id").getDefaultValue());
        Assert.assertNull((Object)this.roadType.getDescriptor("geom").getDefaultValue());
        GeometryFactory fac = new GeometryFactory();
        Coordinate coordinate = new Coordinate(0.0, 0.0);
        Point point = fac.createPoint(coordinate);
        Geometry geometry = fac.createGeometry((Geometry)point);
        Assert.assertEquals((Object)geometry, (Object)((Geometry)DataUtilities.defaultValue(Geometry.class)));
    }

    @Test
    public void testDefaultValueArray() throws Exception {
        Assert.assertArrayEquals((byte[])new byte[0], (byte[])((byte[])DataUtilities.defaultValue(byte[].class)));
        Assert.assertArrayEquals((Object[])new String[0], (Object[])((String[])DataUtilities.defaultValue(String[].class)));
    }

    @Test
    public void testCollection() {
        SimpleFeatureCollection collection = DataUtilities.collection((SimpleFeature[])this.roadFeatures);
        Assert.assertEquals((long)this.roadFeatures.length, (long)collection.size());
    }

    @Test
    public void testBounds() {
        SimpleFeatureCollection collection = DataUtilities.collection((SimpleFeature[])this.roadFeatures);
        ReferencedEnvelope expected = collection.getBounds();
        ReferencedEnvelope actual = DataUtilities.bounds((FeatureCollection)collection);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testCollectionList() {
        SimpleFeatureCollection collection = DataUtilities.collection(Arrays.asList(this.roadFeatures));
        Assert.assertEquals((long)this.roadFeatures.length, (long)collection.size());
    }

    @Test
    public void testReaderFeatureArray() throws Exception {
        try (FeatureReader reader = DataUtilities.reader((SimpleFeature[])this.roadFeatures);){
            Assert.assertEquals((long)this.roadFeatures.length, (long)this.count(reader));
        }
    }

    @Test
    public void testReaderCollection() throws Exception {
        SimpleFeatureCollection collection = DataUtilities.collection((SimpleFeature[])this.roadFeatures);
        Assert.assertEquals((long)this.roadFeatures.length, (long)collection.size());
        try (SimpleFeatureReader reader = DataUtilities.reader((FeatureCollection)collection);){
            Assert.assertEquals((long)this.roadFeatures.length, (long)this.count((FeatureReader)reader));
        }
    }

    @Test
    public void testCreateSubType() throws Exception {
        SimpleFeatureType before = DataUtilities.createType((String)"cities", (String)"the_geom:Point:srid=4326,name:String");
        SimpleFeatureType after = DataUtilities.createSubType((SimpleFeatureType)before, (String[])new String[]{"the_geom"});
        Assert.assertEquals((long)1L, (long)after.getAttributeCount());
        before = DataUtilities.createType((String)"cities", (String)"the_geom:Point:srid=4326,name:String,population:Integer");
        URI here = new URI("http://localhost/");
        after = DataUtilities.createSubType((SimpleFeatureType)before, (String[])new String[]{"the_geom"}, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, (String)"now", (URI)here);
        Assert.assertEquals((Object)here.toString(), (Object)after.getName().getNamespaceURI());
        Assert.assertEquals((Object)"now", (Object)after.getName().getLocalPart());
        Assert.assertEquals((Object)DefaultGeographicCRS.WGS84, (Object)after.getCoordinateReferenceSystem());
        Assert.assertEquals((long)1L, (long)after.getAttributeCount());
        Assert.assertEquals((Object)"the_geom", (Object)after.getDescriptor(0).getLocalName());
        Assert.assertNotNull((Object)after.getGeometryDescriptor());
        before = DataUtilities.createType((String)"cities", (String)"the_geom:Point:srid=4326,name:String,population:Integer");
        after = DataUtilities.createSubType((SimpleFeatureType)before, (String[])new String[]{"the_geom"});
        Assert.assertEquals((Object)before.getGeometryDescriptor(), (Object)after.getGeometryDescriptor());
        before = DataUtilities.createType((String)"cities", (String)"the_geom:Point:srid=4326,name:String,population:Integer");
        after = DataUtilities.createSubType((SimpleFeatureType)before, (String[])new String[]{"the_geom"});
        Assert.assertEquals((Object)before.getGeometryDescriptor(), (Object)after.getGeometryDescriptor());
    }

    @Test
    public void testCreateSubTypePreservesDefaultGeometryProperty() throws Exception {
        SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
        tb.setName("test");
        tb.add("name", String.class);
        tb.add("the_geom1", Point.class, Integer.valueOf(4326));
        tb.add("the_geom2", Point.class, Integer.valueOf(4326));
        tb.add("the_geom3", Point.class, Integer.valueOf(4326));
        tb.setDefaultGeometry("the_geom2");
        SimpleFeatureType before = tb.buildFeatureType();
        SimpleFeatureType after = DataUtilities.createSubType((SimpleFeatureType)before, (String[])new String[]{"name", "the_geom1", "the_geom3"});
        Assert.assertEquals((long)3L, (long)after.getAttributeCount());
        Assert.assertEquals((Object)"the_geom1", (Object)after.getGeometryDescriptor().getLocalName());
        after = DataUtilities.createSubType((SimpleFeatureType)before, (String[])new String[]{"name", "the_geom1", "the_geom3"}, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        Assert.assertEquals((long)3L, (long)after.getAttributeCount());
        Assert.assertEquals((Object)"the_geom1", (Object)after.getGeometryDescriptor().getLocalName());
        after = DataUtilities.createSubType((SimpleFeatureType)before, (String[])new String[]{"name", "the_geom1", "the_geom2"});
        Assert.assertEquals((long)3L, (long)after.getAttributeCount());
        Assert.assertEquals((Object)"the_geom2", (Object)after.getGeometryDescriptor().getLocalName());
        after = DataUtilities.createSubType((SimpleFeatureType)before, (String[])new String[]{"name", "the_geom1", "the_geom2"}, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        Assert.assertEquals((long)3L, (long)after.getAttributeCount());
        Assert.assertEquals((Object)"the_geom2", (Object)after.getGeometryDescriptor().getLocalName());
    }

    @Test
    public void testCreateSubTypeWithPropertyNotMatchingAnAttributeDescriptor() throws Exception {
        SimpleFeatureType before = DataUtilities.createType((String)"cities", (String)"the_geom:Point:srid=4326,name:String");
        SimpleFeatureType after = DataUtilities.createSubType((SimpleFeatureType)before, (String[])new String[]{"the_geom", "name", "not_existing"});
        Assert.assertEquals((long)2L, (long)after.getAttributeCount());
        Assert.assertNotNull((Object)after.getDescriptor("the_geom"));
        Assert.assertNotNull((Object)after.getDescriptor("name"));
    }

    @Test
    public void testSource() throws Exception {
        SimpleFeatureSource s = DataUtilities.source((SimpleFeature[])this.roadFeatures);
        Assert.assertEquals((long)3L, (long)s.getCount(Query.ALL));
        Assert.assertEquals((long)3L, (long)s.getFeatures().size());
        Assert.assertEquals((long)3L, (long)s.getFeatures(Query.ALL).size());
        Assert.assertEquals((long)3L, (long)s.getFeatures((Filter)Filter.INCLUDE).size());
        Assert.assertEquals((long)0L, (long)s.getFeatures((Filter)Filter.EXCLUDE).size());
        Assert.assertEquals((long)1L, (long)s.getFeatures(this.rd1Filter).size());
        Assert.assertEquals((long)2L, (long)s.getFeatures(this.rd12Filter).size());
    }

    @Test
    public void testMixQueries() throws Exception {
        Query firstQuery = new Query("typeName", (Filter)Filter.EXCLUDE, 100, new String[]{"att1", "att2", "att3"}, "handle");
        Query secondQuery = new Query("typeName", (Filter)Filter.EXCLUDE, 20, new String[]{"att1", "att2", "att4"}, "handle2");
        secondQuery.setStartIndex(Integer.valueOf(4));
        Query mixed = DataUtilities.mixQueries((Query)firstQuery, (Query)secondQuery, (String)"newhandle");
        Assert.assertEquals((Object)"newhandle", (Object)mixed.getHandle());
        Assert.assertEquals((long)20L, (long)mixed.getMaxFeatures());
        Assert.assertEquals((long)4L, (long)mixed.getPropertyNames().length);
        Assert.assertEquals((long)4L, (long)mixed.getStartIndex().intValue());
        FilterFactory ffac = CommonFactoryFinder.getFilterFactory(null);
        PropertyIsEqualTo filter1 = ffac.equals((Expression)ffac.property("att1"), (Expression)ffac.literal((Object)"val1"));
        PropertyIsEqualTo filter2 = ffac.equals((Expression)ffac.property("att2"), (Expression)ffac.literal((Object)"val2"));
        firstQuery = new Query("typeName", (Filter)filter1, 100, (String[])null, "handle");
        secondQuery = new Query("typeName", (Filter)filter2, 20, new String[]{"att1", "att2", "att4"}, "handle2");
        mixed = DataUtilities.mixQueries((Query)firstQuery, (Query)secondQuery, (String)"newhandle");
        Assert.assertEquals((Object)"newhandle", (Object)mixed.getHandle());
        Assert.assertEquals((long)20L, (long)mixed.getMaxFeatures());
        Assert.assertEquals((long)3L, (long)mixed.getPropertyNames().length);
        Filter mixedFilter = mixed.getFilter();
        Assert.assertNotNull((Object)mixedFilter);
        Assert.assertTrue((boolean)(mixedFilter instanceof BinaryLogicOperator));
        BinaryLogicOperator f = (BinaryLogicOperator)mixedFilter;
        Assert.assertTrue((boolean)(f instanceof And));
        for (Filter subFilter : f.getChildren()) {
            Assert.assertTrue((filter1.equals(subFilter) || filter2.equals(subFilter) ? 1 : 0) != 0);
        }
        firstQuery.setHints(new Hints((RenderingHints.Key)Hints.USE_PROVIDED_FID, (Object)Boolean.TRUE));
        secondQuery.setHints(new Hints((RenderingHints.Key)Hints.FEATURE_2D, (Object)Boolean.TRUE));
        mixed = DataUtilities.mixQueries((Query)firstQuery, (Query)secondQuery, (String)"newhandle");
        Assert.assertEquals((long)2L, (long)mixed.getHints().size());
        Assert.assertTrue((boolean)((Boolean)mixed.getHints().get((Object)Hints.USE_PROVIDED_FID)));
        Assert.assertTrue((boolean)((Boolean)mixed.getHints().get((Object)Hints.FEATURE_2D)));
    }

    @Test
    public void testMixQueryAll() {
        Query firstQuery = new Query(Query.ALL);
        Query secondQuery = new Query(Query.ALL);
        firstQuery.setHints(new Hints((RenderingHints.Key)Hints.USE_PROVIDED_FID, (Object)Boolean.TRUE));
        secondQuery.setHints(new Hints((RenderingHints.Key)Hints.FEATURE_2D, (Object)Boolean.TRUE));
        Query mixed = DataUtilities.mixQueries((Query)firstQuery, (Query)secondQuery, (String)"mixer");
        Assert.assertEquals((long)2L, (long)mixed.getHints().size());
        Assert.assertTrue((boolean)((Boolean)mixed.getHints().get((Object)Hints.USE_PROVIDED_FID)));
        Assert.assertTrue((boolean)((Boolean)mixed.getHints().get((Object)Hints.FEATURE_2D)));
    }

    @Test
    public void testSimplifyFilter() {
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        And filter = ff.and((Filter)Filter.INCLUDE, (Filter)Filter.INCLUDE);
        Query query = new Query(Query.ALL);
        query.setFilter((Filter)filter);
        Query result = DataUtilities.simplifyFilter((Query)query);
        Assert.assertEquals((Object)Filter.INCLUDE, (Object)result.getFilter());
    }

    @Test
    public void testSpecNoCRS() throws Exception {
        String spec = "id:String,polygonProperty:Polygon";
        SimpleFeatureType ft = DataUtilities.createType((String)"testType", (String)spec);
        String spec2 = DataUtilities.encodeType((SimpleFeatureType)ft);
        Assert.assertEquals((Object)spec, (Object)spec2);
    }

    @Test
    public void testSpecCRS() throws Exception {
        String spec = "id:String,polygonProperty:Polygon:srid=32615";
        SimpleFeatureType ft = DataUtilities.createType((String)"testType", (String)spec);
        String spec2 = DataUtilities.encodeType((SimpleFeatureType)ft);
        Assert.assertEquals((Object)spec, (Object)spec2);
    }

    @Test
    public void testSpecCRSAuthority() throws Exception {
        String spec = "id:String,polygonProperty:Polygon:authority=CRS;srid=84";
        SimpleFeatureType ft = DataUtilities.createType((String)"testType", (String)spec);
        String spec2 = DataUtilities.encodeType((SimpleFeatureType)ft);
        Assert.assertEquals((Object)spec, (Object)spec2);
    }

    @Test
    public void testAllGeometryTypes() throws Exception {
        List<Class> bindings = Arrays.asList(Geometry.class, Point.class, LineString.class, Polygon.class, MultiPoint.class, MultiLineString.class, MultiPolygon.class, GeometryCollection.class);
        StringBuilder specBuilder = new StringBuilder();
        bindings.forEach(b -> specBuilder.append(b.getSimpleName()).append("_type:").append(b.getName()).append(','));
        String spec = specBuilder.toString();
        SimpleFeatureType ft = DataUtilities.createType((String)"testType", (String)spec);
        bindings.forEach(b -> {
            AttributeDescriptor descriptor = ft.getDescriptor(b.getSimpleName() + "_type");
            Assert.assertNotNull((Object)descriptor);
            Assert.assertEquals((Object)b, (Object)descriptor.getType().getBinding());
        });
    }

    @Test
    public void testSpecNotIdentifiable() throws Exception {
        String spec = "id:String,polygonProperty:Polygon:srid=32615";
        SimpleFeatureType ft = DataUtilities.createType((String)"testType", (String)spec);
        CoordinateReferenceSystem crsNoId = CRS.parseWKT("PROJCS[\"Geoscience Australia Standard National Scale Lambert Projection\",GEOGCS[\"WGS 84\",DATUM[\"WGS_1984\",SPHEROID[\"WGS_1978\",6378135,298.26],TOWGS84[0,0,0]],PRIMEM[\"Greenwich\",0],UNIT[\"Decimal_Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"central_meridian\",134.0],PARAMETER[\"latitude_of_origin\",0.0],PARAMETER[\"standard_parallel_1\",-18.0],PARAMETER[\"standard_parallel_2\",-36.0],UNIT[\"Meter\",1]]");
        SimpleFeatureType transformedFt = FeatureTypes.transform((SimpleFeatureType)ft, (CoordinateReferenceSystem)crsNoId);
        String expected = "id:String,polygonProperty:Polygon";
        String spec2 = DataUtilities.encodeType((SimpleFeatureType)transformedFt);
        Assert.assertEquals((Object)expected, (Object)spec2);
    }

    @Test
    public void testCreateView() throws Exception {
        String[] propNames = new String[]{"id", "geom"};
        Query query = new Query(this.roadType.getTypeName(), (Filter)Filter.INCLUDE, 100, propNames, null);
        SimpleFeatureSource source = DataUtilities.source((SimpleFeature[])this.roadFeatures);
        SimpleFeatureSource view = DataUtilities.createView((SimpleFeatureSource)source, (Query)query);
        Assert.assertNotNull((Object)view);
        List desc = ((SimpleFeatureType)view.getSchema()).getAttributeDescriptors();
        Assert.assertEquals((long)desc.size(), (long)propNames.length);
        Assert.assertEquals((Object)((AttributeDescriptor)desc.get(0)).getLocalName(), (Object)propNames[0]);
        Assert.assertEquals((Object)((AttributeDescriptor)desc.get(1)).getLocalName(), (Object)propNames[1]);
    }

    @Test
    public void testAddMandatoryProperties() {
        AttributeTypeImpl at = new AttributeTypeImpl((Name)new NameImpl("String"), String.class, false, false, Collections.emptyList(), null, null);
        AttributeDescriptorImpl descr1 = new AttributeDescriptorImpl((AttributeType)at, (Name)new NameImpl("att1"), 0, 1, false, null);
        AttributeDescriptorImpl descr2 = new AttributeDescriptorImpl((AttributeType)at, (Name)new NameImpl("att2"), 0, 1, false, null);
        AttributeDescriptorImpl descr3 = new AttributeDescriptorImpl((AttributeType)at, (Name)new NameImpl("att3"), 1, 1, false, null);
        AttributeDescriptorImpl descr4 = new AttributeDescriptorImpl((AttributeType)at, (Name)new NameImpl("att4"), 1, 1, false, null);
        SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
        tb.setName("type");
        tb.add((AttributeDescriptor)descr1);
        tb.add((AttributeDescriptor)descr2);
        tb.add((AttributeDescriptor)descr3);
        tb.add((AttributeDescriptor)descr4);
        SimpleFeatureType type = tb.buildFeatureType();
        PropertyName propName1 = this.ff.property("att1");
        PropertyName propName2 = this.ff.property("att2");
        PropertyName propName3 = this.ff.property("att3");
        PropertyName propName4 = this.ff.property("att4");
        ArrayList<PropertyName> list = new ArrayList<PropertyName>();
        list.add(propName1);
        list.add(propName4);
        List list2 = DataUtilities.addMandatoryProperties((SimpleFeatureType)type, list);
        Assert.assertTrue((boolean)list2.contains(propName1));
        Assert.assertFalse((boolean)list2.contains(propName2));
        Assert.assertTrue((boolean)list2.contains(propName3));
        Assert.assertTrue((boolean)list2.contains(propName4));
        Assert.assertEquals((long)3L, (long)list2.size());
    }

    @Test
    public void testMixQueriesSort() {
        Query q1 = new Query();
        Query q2 = new Query();
        q2.setSortBy(new SortBy[]{SortBy.NATURAL_ORDER});
        MatcherAssert.assertThat((Object)DataUtilities.mixQueries((Query)q1, (Query)q2, null).getSortBy(), (Matcher)Matchers.arrayContaining((Object[])new SortBy[]{SortBy.NATURAL_ORDER}));
        MatcherAssert.assertThat((Object)DataUtilities.mixQueries((Query)q2, (Query)q1, null).getSortBy(), (Matcher)Matchers.arrayContaining((Object[])new SortBy[]{SortBy.NATURAL_ORDER}));
        Query q3 = new Query();
        q3.setSortBy(new SortBy[]{SortBy.REVERSE_ORDER});
        MatcherAssert.assertThat((Object)DataUtilities.mixQueries((Query)q2, (Query)q3, null).getSortBy(), (Matcher)Matchers.arrayContaining((Object[])new SortBy[]{SortBy.REVERSE_ORDER}));
        MatcherAssert.assertThat((Object)DataUtilities.mixQueries((Query)q3, (Query)q2, null).getSortBy(), (Matcher)Matchers.arrayContaining((Object[])new SortBy[]{SortBy.NATURAL_ORDER}));
    }
}

