/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Arrays;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.client.utils.DateUtils;
import org.geotools.util.logging.Logging;
import org.geowebcache.GeoWebCacheDispatcher;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.conveyor.Conveyor;
import org.geowebcache.conveyor.ConveyorTile;
import org.geowebcache.filter.request.RequestFilterException;
import org.geowebcache.filter.security.SecurityDispatcher;
import org.geowebcache.grid.BoundingBox;
import org.geowebcache.grid.GridSubset;
import org.geowebcache.grid.OutsideCoverageException;
import org.geowebcache.io.ByteArrayResource;
import org.geowebcache.io.Resource;
import org.geowebcache.layer.EmptyTileException;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.layer.TileLayerDispatcher;
import org.geowebcache.mime.ImageMime;
import org.geowebcache.stats.RuntimeStats;
import org.geowebcache.storage.DefaultStorageFinder;
import org.geowebcache.util.ServletUtils;

public final class ResponseUtils {
    private static Logger log = Logging.getLogger(ResponseUtils.class);

    private ResponseUtils() {
    }

    public static void writeTile(SecurityDispatcher secDispatcher, Conveyor conv, String layerName, TileLayerDispatcher tileLayerDispatcher, DefaultStorageFinder defaultStorageFinder, RuntimeStats runtimeStats) throws GeoWebCacheException, RequestFilterException, IOException {
        ConveyorTile convTile = (ConveyorTile)conv;
        TileLayer layer = tileLayerDispatcher.getTileLayer(layerName);
        layer.applyRequestFilters(convTile);
        secDispatcher.checkSecurity(convTile);
        try {
            convTile = layer.getTile(convTile);
            ResponseUtils.writeData(convTile, runtimeStats);
        }
        catch (EmptyTileException e) {
            ResponseUtils.writeEmpty(defaultStorageFinder, convTile, e.getMessage(), runtimeStats, e.getMime().getMimeType(), e.getContents());
        }
        catch (OutsideCoverageException e) {
            ResponseUtils.writeEmpty(defaultStorageFinder, convTile, e.getMessage(), runtimeStats);
        }
    }

    private static void writeData(ConveyorTile tile, RuntimeStats runtimeStats) throws IOException {
        long tileTimeStampSeconds;
        Date ifModifiedSince;
        long ifModSinceSeconds;
        HttpServletResponse servletResp = tile.servletResp;
        HttpServletRequest servletReq = tile.servletReq;
        Conveyor.CacheResult cacheResult = tile.getCacheResult();
        int httpCode = 200;
        Resource blob = tile.getBlob();
        String mimeType = tile.getMimeType().getMimeType(blob);
        servletResp.setHeader("geowebcache-cache-result", String.valueOf((Object)cacheResult));
        servletResp.setHeader("geowebcache-tile-index", Arrays.toString(tile.getTileIndex()));
        long[] tileIndex = tile.getTileIndex();
        TileLayer layer = tile.getLayer();
        GridSubset gridSubset = layer.getGridSubset(tile.getGridSetId());
        BoundingBox tileBounds = gridSubset.boundsFromIndex(tileIndex);
        servletResp.setHeader("geowebcache-tile-bounds", tileBounds.toString());
        servletResp.setHeader("geowebcache-gridset", gridSubset.getName());
        servletResp.setHeader("geowebcache-crs", gridSubset.getSRS().toString());
        long tileTimeStamp = tile.getTSCreated();
        String ifModSinceHeader = servletReq.getHeader("If-Modified-Since");
        String lastModified = DateUtils.formatDate((Date)new Date(tileTimeStamp));
        servletResp.setHeader("Last-Modified", lastModified);
        if (ifModSinceHeader != null && ifModSinceHeader.length() > 0 && (ifModSinceSeconds = 1000L * ((ifModifiedSince = DateUtils.parseDate((String)ifModSinceHeader)).getTime() / 1000L)) >= (tileTimeStampSeconds = 1000L * (tileTimeStamp / 1000L))) {
            httpCode = 304;
            blob = null;
        }
        if (httpCode == 200 && tile.getLayer().useETags()) {
            String ifNoneMatch = servletReq.getHeader("If-None-Match");
            String hexTag = Long.toHexString(tileTimeStamp);
            if (ifNoneMatch != null && ifNoneMatch.equals(hexTag)) {
                httpCode = 304;
                blob = null;
            }
            servletResp.setHeader("ETag", hexTag);
        }
        int contentLength = (int)(blob == null ? -1L : blob.getSize());
        ResponseUtils.writeFixedResponse(servletResp, httpCode, mimeType, blob, cacheResult, contentLength, runtimeStats);
    }

    private static void writeEmpty(DefaultStorageFinder defaultStorageFinder, ConveyorTile tile, String message, RuntimeStats runtimeStats, String mimeType, ByteArrayResource emptyTileContents) {
        tile.servletResp.setHeader("geowebcache-message", message);
        TileLayer layer = tile.getLayer();
        if (layer != null) {
            layer.setExpirationHeader(tile.servletResp, (int)tile.getTileIndex()[2]);
            if (layer.useETags()) {
                String ifNoneMatch = tile.servletReq.getHeader("If-None-Match");
                if (ifNoneMatch != null && ifNoneMatch.equals("gwc-blank-tile")) {
                    tile.servletResp.setStatus(304);
                    return;
                }
                tile.servletResp.setHeader("ETag", "gwc-blank-tile");
            }
        }
        int status = emptyTileContents == null ? 204 : 200;
        ResponseUtils.writeFixedResponse(tile.servletResp, status, mimeType, emptyTileContents, Conveyor.CacheResult.OTHER, runtimeStats);
    }

    private static void writeEmpty(DefaultStorageFinder defaultStorageFinder, ConveyorTile tile, String message, RuntimeStats runtimeStats) {
        ResponseUtils.writeEmpty(defaultStorageFinder, tile, message, runtimeStats, ImageMime.png.getMimeType(), ResponseUtils.loadBlankTile(defaultStorageFinder));
    }

    public static void writeFixedResponse(HttpServletResponse response, int httpCode, String contentType, Resource resource, Conveyor.CacheResult cacheRes, RuntimeStats runtimeStats) {
        int contentLength = (int)(resource == null ? -1L : resource.getSize());
        ResponseUtils.writeFixedResponse(response, httpCode, contentType, resource, cacheRes, contentLength, runtimeStats);
    }

    public static void writeFixedResponse(HttpServletResponse response, int httpCode, String contentType, Resource resource, Conveyor.CacheResult cacheRes, int contentLength, RuntimeStats runtimeStats) {
        response.setStatus(httpCode);
        response.setContentType(contentType);
        response.setContentLength(contentLength);
        if (resource != null) {
            try (ServletOutputStream os = response.getOutputStream();
                 WritableByteChannel channel = Channels.newChannel((OutputStream)os);){
                resource.transferTo(channel);
                runtimeStats.log(contentLength, cacheRes);
            }
            catch (IOException ioe) {
                log.fine("Caught IOException: " + ioe.getMessage() + "\n\n" + ioe.toString());
            }
        }
    }

    private static ByteArrayResource loadBlankTile(DefaultStorageFinder defaultStorageFinder) {
        ByteArrayResource blankTile = null;
        String blankTilePath = defaultStorageFinder.findEnvVar("GWC_BLANK_TILE_PATH");
        if (blankTilePath != null) {
            File fh = new File(blankTilePath);
            if (fh.exists() && fh.canRead() && fh.isFile()) {
                long fileSize = fh.length();
                blankTile = new ByteArrayResource(new byte[(int)fileSize]);
                try {
                    ResponseUtils.loadBlankTile(blankTile, fh.toURI().toURL());
                }
                catch (IOException e) {
                    log.log(Level.SEVERE, e.getMessage(), e);
                }
                if (fileSize == blankTile.getSize()) {
                    log.info("Loaded blank tile from " + blankTilePath);
                } else {
                    log.log(Level.SEVERE, "Failed to load blank tile from " + blankTilePath);
                }
            } else {
                log.log(Level.SEVERE, blankTilePath + " does not exist or is not readable.");
            }
        }
        if (blankTile == null) {
            try {
                URL url = GeoWebCacheDispatcher.class.getResource("blank.png");
                blankTile = new ByteArrayResource();
                ResponseUtils.loadBlankTile(blankTile, url);
                int ret = (int)blankTile.getSize();
                log.info("Read " + ret + " from blank PNG file (expected 425).");
            }
            catch (IOException ioe) {
                log.log(Level.SEVERE, ioe.getMessage());
            }
        }
        return blankTile;
    }

    private static void loadBlankTile(Resource blankTile, URL source) throws IOException {
        try (InputStream inputStream = source.openStream();
             ReadableByteChannel ch = Channels.newChannel(inputStream);){
            blankTile.transferFrom(ch);
        }
        catch (IOException e) {
            log.log(Level.FINE, e.getMessage(), e);
        }
    }

    public static void writeErrorPage(HttpServletResponse response, int httpCode, String errorMsg, RuntimeStats runtimeStats) {
        log.fine((String)errorMsg);
        errorMsg = "<html>\n" + ServletUtils.gwcHtmlHeader("../", "GWC Error") + "<body>\n" + ServletUtils.gwcHtmlLogoLink("../") + "<h4>" + httpCode + ": " + ServletUtils.disableHTMLTags((String)errorMsg) + "</h4></body></html>\n";
        ResponseUtils.writePage(response, httpCode, (String)errorMsg, runtimeStats, "text/html");
    }

    public static void writeErrorAsXML(HttpServletResponse response, int httpCode, String errorMsg, RuntimeStats runtimeStats) {
        log.fine(errorMsg);
        ResponseUtils.writePage(response, httpCode, errorMsg, runtimeStats, "application/xml");
    }

    public static void writePage(HttpServletResponse response, int httpCode, String message, RuntimeStats runtimeStats, String contentType) {
        ByteArrayResource res = null;
        if (message != null) {
            res = new ByteArrayResource(message.getBytes());
        }
        ResponseUtils.writeFixedResponse(response, httpCode, contentType, res, Conveyor.CacheResult.OTHER, runtimeStats);
    }
}

