/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.storage;

import org.geowebcache.storage.CompositeBlobStore;
import org.geowebcache.storage.StorageException;

public class UnsuitableStorageException
extends StorageException {
    private static final long serialVersionUID = 3939772540460067187L;

    public UnsuitableStorageException(String msg) {
        super(msg);
    }

    public static void checkSuitability(String location, boolean exists, boolean empty) throws UnsuitableStorageException {
        switch (CompositeBlobStore.getStoreSuitabilityCheck()) {
            case EXISTING: {
                if (exists) break;
            }
            case EMPTY: {
                if (empty) break;
                throw new UnsuitableStorageException("Attempted to create Blob Store in " + location + " but it was not empty");
            }
        }
    }
}

