/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.seed;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.util.logging.Logging;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.filter.request.RequestFilter;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.seed.GWCTask;
import org.geowebcache.storage.StorageBroker;
import org.geowebcache.storage.TileRange;

class TruncateTask
extends GWCTask {
    private static Logger log = Logging.getLogger((String)TruncateTask.class.getName());
    private final TileRange tr;
    private final TileLayer tl;
    private final boolean doFilterUpdate;
    private final StorageBroker storageBroker;

    public TruncateTask(StorageBroker sb, TileRange tr, TileLayer tl, boolean doFilterUpdate) {
        this.storageBroker = sb;
        this.tr = tr;
        this.tl = tl;
        this.doFilterUpdate = doFilterUpdate;
        this.parsedType = GWCTask.TYPE.TRUNCATE;
        this.layerName = tl.getName();
    }

    @Override
    protected void doActionInternal() throws GeoWebCacheException, InterruptedException {
        this.state = GWCTask.STATE.RUNNING;
        this.checkInterrupted();
        try {
            this.storageBroker.delete(this.tr);
        }
        catch (Exception e) {
            this.state = GWCTask.STATE.DEAD;
            log.log(Level.SEVERE, "During truncate request", e);
        }
        this.checkInterrupted();
        if (this.doFilterUpdate) {
            this.runFilterUpdates();
        }
        if (this.state != GWCTask.STATE.DEAD) {
            this.state = GWCTask.STATE.DONE;
            log.log(Level.FINE, "Completed truncate request.");
        }
    }

    private void runFilterUpdates() {
        List<RequestFilter> reqFilters = this.tl.getRequestFilters();
        if (reqFilters != null && !reqFilters.isEmpty()) {
            for (RequestFilter reqFilter : reqFilters) {
                if (reqFilter.update(this.tl, this.tr.getGridSetId())) {
                    log.log(Level.FINE, "Updated request filter " + reqFilter.getName());
                    continue;
                }
                log.log(Level.FINE, "Request filter " + reqFilter.getName() + " returned false on update.");
            }
        }
    }

    @Override
    protected void dispose() {
    }
}

