/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.seed;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.geotools.util.logging.Logging;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.scheduling.concurrent.CustomizableThreadFactory;

public class SeederThreadPoolExecutor
extends ThreadPoolExecutor
implements DisposableBean {
    private static final Logger log = Logging.getLogger((String)SeederThreadPoolExecutor.class.getName());
    private static final ThreadFactory tf = new CustomizableThreadFactory("GWC Seeder Thread-");

    public SeederThreadPoolExecutor(int corePoolSize, int maxPoolSize) {
        super(corePoolSize, maxPoolSize, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), tf);
    }

    public void destroy() throws Exception {
        log.info("Initiating shut down for running and pending seed tasks...");
        this.shutdownNow();
        while (!this.isTerminated()) {
            log.fine("Waiting for pending tasks to terminate....");
            Thread.sleep(500L);
        }
        log.info("Seeder thread pool executor shut down complete.");
    }
}

