/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.seed;

import com.google.common.annotations.VisibleForTesting;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.util.logging.Logging;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.conveyor.ConveyorTile;
import org.geowebcache.filter.request.RequestFilter;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.layer.wms.WMSLayer;
import org.geowebcache.seed.GWCTask;
import org.geowebcache.storage.StorageBroker;
import org.geowebcache.storage.TileRange;
import org.geowebcache.storage.TileRangeIterator;
import org.geowebcache.util.Sleeper;

class SeedTask
extends GWCTask {
    private static Logger log = Logging.getLogger((String)SeedTask.class.getName());
    private final TileRangeIterator trIter;
    private final TileLayer tl;
    private boolean reseed;
    private boolean doFilterUpdate;
    private StorageBroker storageBroker;
    private int tileFailureRetryCount;
    private long tileFailureRetryWaitTime;
    private long totalFailuresBeforeAborting;
    private AtomicLong sharedFailureCounter;
    @VisibleForTesting
    Sleeper sleeper = Thread::sleep;

    public SeedTask(StorageBroker sb, TileRangeIterator trIter, TileLayer tl, boolean reseed, boolean doFilterUpdate) {
        this.storageBroker = sb;
        this.trIter = trIter;
        this.tl = tl;
        this.reseed = reseed;
        this.doFilterUpdate = doFilterUpdate;
        this.tileFailureRetryCount = 0;
        this.tileFailureRetryWaitTime = 100L;
        this.totalFailuresBeforeAborting = 10000L;
        this.sharedFailureCounter = new AtomicLong();
        this.parsedType = reseed ? GWCTask.TYPE.RESEED : GWCTask.TYPE.SEED;
        this.layerName = tl.getName();
        this.state = GWCTask.STATE.READY;
    }

    @Override
    protected void doActionInternal() throws GeoWebCacheException, InterruptedException {
        this.state = GWCTask.STATE.RUNNING;
        this.reprioritize();
        this.checkInterrupted();
        long START_TIME = System.currentTimeMillis();
        String layerName = this.tl.getName();
        log.info(this.getThreadName() + " begins seeding layer : " + layerName);
        TileRange tr = this.trIter.getTileRange();
        this.checkInterrupted();
        this.tilesTotal = this.tileCount(tr);
        int metaTilingFactorX = this.tl.getMetaTilingFactors()[0];
        int metaTilingFactorY = this.tl.getMetaTilingFactors()[1];
        boolean tryCache = !this.reseed;
        this.checkInterrupted();
        long[] gridLoc = this.trIter.nextMetaGridLocation(new long[3]);
        long seedCalls = 0L;
        while (gridLoc != null && !this.terminate) {
            this.checkInterrupted();
            Map<String, String> fullParameters = tr.getParameters();
            ConveyorTile tile = new ConveyorTile(this.storageBroker, layerName, tr.getGridSetId(), gridLoc, tr.getMimeType(), fullParameters, null, null);
            for (int fetchAttempt = 0; fetchAttempt <= this.tileFailureRetryCount || this.tileFailureRetryCount < 0; ++fetchAttempt) {
                try {
                    this.checkInterrupted();
                    this.tl.seedTile(tile, tryCache);
                    break;
                }
                catch (Exception e) {
                    if (this.tileFailureRetryCount < 0) {
                        if (e instanceof GeoWebCacheException) {
                            throw (GeoWebCacheException)e;
                        }
                        throw new GeoWebCacheException(e);
                    }
                    long sharedFailureCount = this.sharedFailureCounter.incrementAndGet();
                    if (sharedFailureCount >= this.totalFailuresBeforeAborting) {
                        log.info("Aborting seed thread " + this.getThreadName() + ". Error count reached configured maximum of " + this.totalFailuresBeforeAborting);
                        this.state = GWCTask.STATE.DEAD;
                        return;
                    }
                    String logMsg = "Seed failed at " + tile.toString() + " after " + (fetchAttempt + 1) + " of " + (this.tileFailureRetryCount + 1) + " attempts.";
                    if (fetchAttempt < this.tileFailureRetryCount) {
                        log.fine(logMsg);
                        if (this.tileFailureRetryWaitTime <= 0L) continue;
                        log.finer("Waiting " + this.tileFailureRetryWaitTime + " before trying again");
                        this.waitToRetry();
                        continue;
                    }
                    log.log(Level.WARNING, logMsg + " Skipping and continuing with next tile. Total failure count across threads is at: " + sharedFailureCount, e);
                    continue;
                }
            }
            if (log.isLoggable(Level.FINER)) {
                log.finer(this.getThreadName() + " seeded " + Arrays.toString(gridLoc));
            }
            long tilesCompletedByThisThread = seedCalls * (long)metaTilingFactorX * (long)metaTilingFactorY;
            this.updateStatusInfo(this.tl, tilesCompletedByThisThread, START_TIME);
            this.checkInterrupted();
            ++seedCalls;
            gridLoc = this.trIter.nextMetaGridLocation(gridLoc);
        }
        if (this.terminate) {
            log.info("Job on " + this.getThreadName() + " was terminated after " + this.tilesDone + " tiles");
        } else {
            log.info(this.getThreadName() + " completed (re)seeding layer " + layerName + " after " + this.tilesDone + " tiles and " + this.timeSpent + " seconds.");
        }
        this.checkInterrupted();
        if (this.threadOffset == 0 && this.doFilterUpdate) {
            this.runFilterUpdates(tr.getGridSetId());
        }
        this.state = GWCTask.STATE.DONE;
    }

    private void reprioritize() {
        Thread.currentThread().setPriority(3);
    }

    private void waitToRetry() throws InterruptedException {
        this.sleeper.sleep(this.tileFailureRetryWaitTime);
    }

    private String getThreadName() {
        return Thread.currentThread().getName();
    }

    private long tileCount(TileRange tr) {
        int startZoom = tr.getZoomStart();
        int stopZoom = tr.getZoomStop();
        long count = 0L;
        for (int z = startZoom; z <= stopZoom; ++z) {
            long miny;
            long maxy;
            long minx;
            long[] gridBounds = tr.rangeBounds(z);
            long maxx = gridBounds[2];
            long thisLevel = (1L + maxx - (minx = gridBounds[0])) * (1L + (maxy = gridBounds[3]) - (miny = gridBounds[1]));
            if (thisLevel > 0x1FFFFFFFFFFFFFFFL && z != stopZoom) {
                return -1L;
            }
            count += thisLevel;
        }
        return count;
    }

    private void updateStatusInfo(TileLayer layer, long tilesCount, long start_time) {
        this.tilesDone = tilesCount;
        this.timeSpent = (int)(System.currentTimeMillis() - start_time) / 1000;
        double threadCount = this.sharedThreadCount.get();
        long timeTotal = Math.round((double)this.timeSpent * ((double)this.tilesTotal / threadCount / (double)tilesCount));
        this.timeRemaining = (int)(timeTotal - this.timeSpent);
    }

    private void runFilterUpdates(String gridSetId) {
        List<RequestFilter> reqFilters = this.tl.getRequestFilters();
        if (reqFilters != null && !reqFilters.isEmpty()) {
            for (RequestFilter reqFilter : reqFilters) {
                if (reqFilter.update(this.tl, gridSetId)) {
                    log.info("Updated request filter " + reqFilter.getName());
                    continue;
                }
                log.fine("Request filter " + reqFilter.getName() + " returned false on update.");
            }
        }
    }

    public void setFailurePolicy(int tileFailureRetryCount, long tileFailureRetryWaitTime, long totalFailuresBeforeAborting, AtomicLong sharedFailureCounter) {
        this.tileFailureRetryCount = tileFailureRetryCount;
        this.tileFailureRetryWaitTime = tileFailureRetryWaitTime;
        this.totalFailuresBeforeAborting = totalFailuresBeforeAborting;
        this.sharedFailureCounter = sharedFailureCounter;
    }

    @Override
    protected void dispose() {
        if (this.tl instanceof WMSLayer) {
            ((WMSLayer)this.tl).cleanUpThreadLocals();
        }
    }
}

