/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.io;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class XMLBuilder {
    Appendable builder;
    static final Map<Integer, char[]> ESCAPE_ENTITIES;
    Deque<NodeInfo> nodeStack = new LinkedList<NodeInfo>();
    boolean startOfElement = false;

    public XMLBuilder(Appendable builder) {
        Preconditions.checkNotNull((Object)builder);
        this.builder = builder;
    }

    public XMLBuilder appendUnescaped(@Nullable String s) throws IOException {
        this.builder.append(s);
        return this;
    }

    public XMLBuilder indentElement(String name) throws IOException {
        return this.startElement(name, true);
    }

    public XMLBuilder startElement(String name, boolean indent) throws IOException {
        Preconditions.checkNotNull((Object)name);
        if (this.startOfElement) {
            this.appendUnescaped(">");
        }
        this.startOfElement = false;
        if (indent) {
            this.text("\n");
            for (int i = 0; i < this.nodeStack.size(); ++i) {
                this.text("  ");
            }
        }
        this.appendUnescaped("<").appendUnescaped(name);
        if (!this.nodeStack.isEmpty()) {
            this.nodeStack.peek().containsIndented = true;
        }
        NodeInfo ni = new NodeInfo();
        ni.name = name;
        ni.indented = indent;
        this.nodeStack.push(ni);
        this.startOfElement = true;
        return this;
    }

    public XMLBuilder startElement(String name) throws IOException {
        return this.startElement(name, false);
    }

    public XMLBuilder endElement() throws IOException {
        return this.endElement(null);
    }

    public XMLBuilder endElement(@Nullable String name) throws IOException {
        NodeInfo ni = this.nodeStack.pop();
        assert (name == null || name.equals(ni.name));
        if (this.startOfElement) {
            this.appendUnescaped("/>");
        } else {
            if (ni.indented && ni.containsIndented) {
                this.text("\n");
                for (int i = 0; i < this.nodeStack.size(); ++i) {
                    this.text("  ");
                }
            }
            this.appendUnescaped("</").appendUnescaped(ni.name).appendUnescaped(">");
        }
        this.startOfElement = false;
        return this;
    }

    public XMLBuilder simpleElement(String name, @Nullable String text, boolean indent) throws IOException {
        return this.startElement(name, indent).text(text).endElement();
    }

    public XMLBuilder text(@Nullable String str) throws IOException {
        if (str != null && !str.isEmpty()) {
            if (this.startOfElement) {
                this.appendUnescaped(">");
            }
            this.startOfElement = false;
            return this.appendEscaped(str);
        }
        return this;
    }

    public XMLBuilder appendEscaped(@Nullable String str) throws IOException {
        if (str != null) {
            int offset = 0;
            int strLen = str.length();
            while (offset < strLen) {
                int curChar = str.codePointAt(offset);
                offset += Character.charCount(curChar);
                char[] chars = ESCAPE_ENTITIES.get(curChar);
                if (chars == null) {
                    chars = Character.toChars(curChar);
                }
                this.builder.append(new String(chars));
            }
        }
        return this;
    }

    public XMLBuilder entity(String name) throws IOException {
        Preconditions.checkNotNull((Object)name);
        if (this.startOfElement) {
            this.appendUnescaped(">");
        }
        this.startOfElement = false;
        this.appendUnescaped("&").appendUnescaped(name).appendUnescaped(";");
        return this;
    }

    public XMLBuilder attribute(String name, String value) throws IOException {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull((Object)value);
        if (!this.startOfElement) {
            throw new IllegalArgumentException();
        }
        this.appendUnescaped(" ").appendUnescaped(name).appendUnescaped("=\"").appendEscaped(value).appendUnescaped("\"");
        return this;
    }

    public <T> XMLBuilder bboxAttributes(T minx, T miny, T maxx, T maxy) throws IOException {
        return this.attribute("minx", minx.toString()).attribute("miny", miny.toString()).attribute("maxx", maxx.toString()).attribute("maxy", maxy.toString());
    }

    public <T> XMLBuilder boundingBox(@Nullable String srs, T minx, T miny, T maxx, T maxy) throws IOException {
        this.indentElement("BoundingBox");
        if (srs != null) {
            this.attribute("SRS", srs);
        }
        this.bboxAttributes(minx, miny, maxx, maxy);
        this.endElement();
        return this;
    }

    public <T> XMLBuilder latLonBoundingBox(T minx, T miny, T maxx, T maxy) throws IOException {
        return this.indentElement("LatLonBoundingBox").bboxAttributes(minx, miny, maxx, maxy).endElement();
    }

    public XMLBuilder header(String version, @Nullable String charset) throws IOException {
        Preconditions.checkNotNull((Object)version);
        this.appendUnescaped("<?xml version=\"").appendEscaped(version).appendUnescaped("\"");
        if (charset != null) {
            this.appendUnescaped(" encoding=\"").appendEscaped(charset).appendUnescaped("\"");
        }
        this.appendUnescaped("?>\n");
        return this;
    }

    public XMLBuilder header(String version, @Nullable Charset charset) throws IOException {
        String charsetName = charset.name();
        return this.header(version, charsetName);
    }

    static {
        HashMap<Integer, char[]> entities = new HashMap<Integer, char[]>();
        entities.put(60, "&lt;".toCharArray());
        entities.put(62, "&gt;".toCharArray());
        entities.put(38, "&amp;".toCharArray());
        entities.put(34, "&quot;".toCharArray());
        entities.put(39, "&apos;".toCharArray());
        ESCAPE_ENTITIES = Collections.unmodifiableMap(entities);
    }

    class NodeInfo {
        String name;
        boolean indented;
        boolean containsIndented = false;

        NodeInfo() {
        }
    }
}

