/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.io;

import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.collections.MapConverter;
import com.thoughtworks.xstream.core.JVM;
import com.thoughtworks.xstream.core.util.HierarchicalStreams;
import com.thoughtworks.xstream.core.util.PresortedMap;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.mapper.Mapper;
import java.util.Comparator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class TreeMapConverter
extends MapConverter {
    private static final Comparator NULL_MARKER = new NullComparator();

    public TreeMapConverter(Mapper mapper) {
        super(mapper, TreeMap.class);
    }

    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        SortedMap sortedMap = (SortedMap)source;
        TreeMapConverter.marshalComparator(this.mapper(), sortedMap.comparator(), writer, context);
        super.marshal(source, writer, context);
    }

    protected static void marshalComparator(Mapper mapper, Comparator comparator, HierarchicalStreamWriter writer, MarshallingContext context) {
        if (comparator != null) {
            writer.startNode("comparator");
            writer.addAttribute(mapper.aliasForSystemAttribute("class"), mapper.serializedClass(comparator.getClass()));
            context.convertAnother((Object)comparator);
            writer.endNode();
        }
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        TreeMap result = null;
        Comparator comparator = TreeMapConverter.unmarshalComparator(this.mapper(), reader, context, result);
        if (result == null) {
            result = comparator == null ? new TreeMap() : new TreeMap(comparator);
        }
        this.populateTreeMap(reader, context, result, comparator);
        return result;
    }

    protected static Comparator unmarshalComparator(Mapper mapper, HierarchicalStreamReader reader, UnmarshallingContext context, TreeMap result) {
        Comparator comparator;
        if (reader.hasMoreChildren()) {
            reader.moveDown();
            if (reader.getNodeName().equals("comparator")) {
                Class comparatorClass = HierarchicalStreams.readClassType((HierarchicalStreamReader)reader, (Mapper)mapper);
                comparator = (Comparator)context.convertAnother((Object)result, comparatorClass);
            } else if (reader.getNodeName().equals("no-comparator")) {
                comparator = null;
            } else {
                return NULL_MARKER;
            }
            reader.moveUp();
        } else {
            comparator = null;
        }
        return comparator;
    }

    protected void populateTreeMap(HierarchicalStreamReader reader, UnmarshallingContext context, TreeMap result, Comparator comparator) {
        boolean inFirstElement;
        boolean bl = inFirstElement = comparator == NULL_MARKER;
        if (inFirstElement) {
            comparator = null;
        }
        PresortedMap sortedMap = new PresortedMap(comparator != null && JVM.hasOptimizedTreeMapPutAll() ? comparator : null);
        if (inFirstElement) {
            this.putCurrentEntryIntoMap(reader, context, result, (Map)sortedMap);
            reader.moveUp();
        }
        this.populateMap(reader, context, result, (Map)sortedMap);
    }

    private static final class NullComparator
    extends Mapper.Null
    implements Comparator {
        private NullComparator() {
        }

        public int compare(Object o1, Object o2) {
            Comparable c1 = (Comparable)o1;
            return c1.compareTo(o2);
        }
    }
}

