/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.grid;

import java.io.Serializable;
import java.util.Objects;

public class Grid
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private long numTilesWide;
    private long numTilesHigh;
    private double resolution;
    private double scaleDenom;
    private String name;

    public boolean equals(Object obj) {
        if (!(obj instanceof Grid)) {
            return false;
        }
        Grid other = (Grid)obj;
        if (this.numTilesWide != other.numTilesWide) {
            return false;
        }
        if (this.numTilesHigh != other.numTilesHigh) {
            return false;
        }
        return !(Math.abs(other.resolution - this.resolution) / Math.abs(other.resolution + this.resolution) > 0.005);
    }

    public int hashCode() {
        return Objects.hash(this.numTilesWide, this.numTilesHigh, this.resolution, this.scaleDenom, this.name);
    }

    public String getName() {
        return this.name;
    }

    public double getScaleDenominator() {
        return this.scaleDenom;
    }

    public double getResolution() {
        return this.resolution;
    }

    public void setResolution(double resolution) {
        this.resolution = resolution;
    }

    public void setScaleDenominator(double scaleDenom) {
        this.scaleDenom = scaleDenom;
    }

    public void setName(String name) {
        this.name = name;
    }

    public long getNumTilesWide() {
        return this.numTilesWide;
    }

    public void setNumTilesWide(long numTilesWide) {
        this.numTilesWide = numTilesWide;
    }

    public long getNumTilesHigh() {
        return this.numTilesHigh;
    }

    public void setNumTilesHigh(long numTilesHigh) {
        this.numTilesHigh = numTilesHigh;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[name: '" + this.name + "', resolution: " + this.resolution + ", scale denom: " + this.scaleDenom + ", grid extent: " + this.numTilesWide + " x " + this.numTilesHigh + "]";
    }

    public Grid clone() {
        Grid clon;
        try {
            clon = (Grid)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        return clon;
    }
}

