/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.filter.parameters;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.geowebcache.filter.parameters.CaseNormalizer;
import org.geowebcache.filter.parameters.ParameterFilter;

public abstract class CaseNormalizingParameterFilter
extends ParameterFilter {
    private static final long serialVersionUID = 1761619452677321350L;
    protected CaseNormalizer normalize;

    public CaseNormalizingParameterFilter() {
    }

    public CaseNormalizingParameterFilter(String key, String defaultValue) {
        super(key, defaultValue);
    }

    public abstract List<String> getValues();

    public CaseNormalizingParameterFilter(String key) {
        super(key);
    }

    @Override
    protected Object readResolve() {
        super.readResolve();
        return this;
    }

    public CaseNormalizer getNormalize() {
        if (this.normalize != null) {
            return this.normalize;
        }
        return new CaseNormalizer();
    }

    public void setNormalize(CaseNormalizer normalize) {
        this.normalize = normalize;
    }

    @Override
    @Nullable
    public List<String> getLegalValues() {
        List<String> values = this.getValues();
        if (values == null) {
            return null;
        }
        return Lists.transform(values, (Function)this.getNormalize());
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.getNormalize().hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CaseNormalizingParameterFilter other = (CaseNormalizingParameterFilter)obj;
        return Objects.equals(this.getNormalize(), other.getNormalize());
    }

    public String toString() {
        return "CaseNormalizingParameterFilter [normalize=" + this.normalize + ", " + super.toString() + "]";
    }
}

