/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.config.legends;

import com.google.common.base.Preconditions;
import org.geowebcache.config.legends.LegendInfo;
import org.geowebcache.util.ServletUtils;

public class LegendInfoBuilder {
    private String layerName;
    private String layerUrl;
    private Integer defaultWidth;
    private Integer defaultHeight;
    private String defaultFormat;
    private String styleName;
    private Integer width;
    private Integer height;
    private String format;
    private String url;
    private String completeUrl;
    private Double minScale;
    private Double maxScale;

    public LegendInfoBuilder withLayerName(String layerName) {
        this.layerName = layerName;
        return this;
    }

    public LegendInfoBuilder withLayerUrl(String layerUrl) {
        this.layerUrl = layerUrl;
        return this;
    }

    public LegendInfoBuilder withDefaultWidth(Integer defaultWidth) {
        this.defaultWidth = defaultWidth;
        return this;
    }

    public LegendInfoBuilder withDefaultHeight(Integer defaultHeight) {
        this.defaultHeight = defaultHeight;
        return this;
    }

    public LegendInfoBuilder withDefaultFormat(String defaultFormat) {
        this.defaultFormat = defaultFormat;
        return this;
    }

    public LegendInfoBuilder withStyleName(String styleName) {
        this.styleName = styleName;
        return this;
    }

    public LegendInfoBuilder withWidth(Integer width) {
        this.width = width;
        return this;
    }

    public LegendInfoBuilder withHeight(Integer height) {
        this.height = height;
        return this;
    }

    public LegendInfoBuilder withFormat(String format) {
        this.format = format;
        return this;
    }

    public LegendInfoBuilder withUrl(String url) {
        this.url = url;
        return this;
    }

    public LegendInfoBuilder withCompleteUrl(String completeUrl) {
        this.completeUrl = completeUrl;
        return this;
    }

    public LegendInfoBuilder withMinScale(Double minScale) {
        if (minScale == null || Math.abs(minScale) < 1.0E-6) {
            this.minScale = null;
            return this;
        }
        this.minScale = minScale;
        return this;
    }

    public LegendInfoBuilder withMaxScale(Double maxScale) {
        if (maxScale == null || maxScale == Double.POSITIVE_INFINITY) {
            this.maxScale = null;
            return this;
        }
        this.maxScale = maxScale;
        return this;
    }

    public LegendInfo build() {
        Integer finalWidth = this.width == null ? this.defaultWidth : this.width;
        Integer finalHeight = this.height == null ? this.defaultHeight : this.height;
        String finalFormat = this.format == null ? this.defaultFormat : this.format;
        Preconditions.checkNotNull((Object)finalFormat, (Object)"A legend image format is mandatory.");
        String finalStyleName = this.styleName == null ? "" : this.styleName;
        String finalUrl = this.buildFinalUrl(finalStyleName, finalWidth, finalHeight, finalFormat);
        return new LegendInfo(finalStyleName, finalWidth, finalHeight, finalFormat, finalUrl, this.minScale, this.maxScale);
    }

    private String buildFinalUrl(String finalStyleName, Integer finalWidth, Integer finalHeight, String finalFormat) {
        if (this.completeUrl != null) {
            return this.completeUrl;
        }
        String finalUrl = this.url == null ? this.layerUrl : this.url;
        Preconditions.checkNotNull((Object)finalWidth, (Object)"A legend width is mandatory.");
        Preconditions.checkNotNull((Object)finalHeight, (Object)"A legend height is mandatory.");
        Preconditions.checkNotNull((Object)finalUrl, (Object)"A legend url is mandatory.");
        Preconditions.checkNotNull((Object)this.layerName, (Object)"A layer name is mandatory.");
        return finalUrl + this.addQuoteMark(finalUrl) + "service=WMS&request=GetLegendGraphic&format=" + finalFormat + "&width=" + finalWidth + "&height=" + finalHeight + "&layer=" + ServletUtils.URLEncode(this.layerName) + "&style=" + ServletUtils.URLEncode(finalStyleName);
    }

    private String addQuoteMark(String finalUrl) {
        if (finalUrl.indexOf("?") == finalUrl.length() - 1) {
            return "";
        }
        return "?";
    }
}

