/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.config;

import java.io.Serializable;
import java.util.Arrays;
import org.geowebcache.grid.BoundingBox;
import org.geowebcache.grid.GridSet;
import org.geowebcache.grid.GridSetFactory;
import org.geowebcache.grid.SRS;

public class XMLGridSet
implements Serializable {
    private static final long serialVersionUID = 2684804068163933728L;
    private String name;
    private String description;
    private SRS srs;
    private BoundingBox extent;
    private Boolean alignTopLeft;
    private double[] resolutions;
    private double[] scaleDenominators;
    private Integer levels;
    private Double metersPerUnit;
    private Double pixelSize;
    private String[] scaleNames;
    private Integer tileHeight;
    private Integer tileWidth;
    private Boolean yCoordinateFirst;

    public XMLGridSet() {
    }

    public XMLGridSet(XMLGridSet orig) {
        this.setAlignTopLeft(orig.getAlignTopLeft());
        this.setExtent(orig.getExtent() == null ? null : new BoundingBox(orig.getExtent()));
        this.setResolutions(orig.getResolutions() == null ? null : (double[])orig.getResolutions().clone());
        this.setLevels(orig.getLevels());
        this.setScaleDenominators(orig.getScaleDenominators() == null ? null : (double[])orig.getScaleDenominators().clone());
        this.setMetersPerUnit(orig.getMetersPerUnit());
        this.setName(orig.getName());
        this.setDescription(orig.getDescription());
        this.setPixelSize(orig.getPixelSize());
        this.setScaleNames(orig.getScaleNames() == null ? null : (String[])orig.getScaleNames().clone());
        this.setSrs(orig.getSrs());
        this.setTileWidth(orig.getTileWidth());
        this.setTileHeight(orig.getTileHeight());
    }

    public XMLGridSet(GridSet gset) {
        this.setAlignTopLeft(gset.isTopLeftAligned());
        this.setYCoordinateFirst(gset.isyCoordinateFirst());
        this.setExtent(gset.getOriginalExtent());
        this.setLevels(null);
        if (gset.isResolutionsPreserved()) {
            this.setResolutions(XMLGridSet.resolutions(gset));
            this.setScaleDenominators(null);
        } else {
            this.setResolutions(null);
            this.setScaleDenominators(XMLGridSet.scaleDenominators(gset));
        }
        this.setMetersPerUnit(gset.getMetersPerUnit());
        this.setName(gset.getName());
        this.setDescription(gset.getDescription());
        this.setPixelSize(gset.getPixelSize());
        this.setScaleNames(XMLGridSet.scaleNames(gset));
        this.setSrs(gset.getSrs());
        this.setTileWidth(gset.getTileWidth());
        this.setTileHeight(gset.getTileHeight());
    }

    private static double[] resolutions(GridSet gridSet) {
        double[] resolutions = new double[gridSet.getNumLevels()];
        for (int i = 0; i < resolutions.length; ++i) {
            resolutions[i] = gridSet.getGrid(i).getResolution();
        }
        return resolutions;
    }

    private static double[] scaleDenominators(GridSet gridSet) {
        double[] scales = new double[gridSet.getNumLevels()];
        for (int i = 0; i < scales.length; ++i) {
            scales[i] = gridSet.getGrid(i).getScaleDenominator();
        }
        return scales;
    }

    private static String[] scaleNames(GridSet gridSet) {
        String[] scaleNames = new String[gridSet.getNumLevels()];
        for (int i = 0; i < scaleNames.length; ++i) {
            scaleNames[i] = gridSet.getGrid(i).getName();
        }
        return scaleNames;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setName(String name) {
        this.name = name;
    }

    public GridSet makeGridSet() {
        GridSet gridSet;
        if (this.getTileWidth() == null) {
            this.setTileWidth(256);
        }
        if (this.getTileHeight() == null) {
            this.setTileHeight(256);
        }
        if (this.getAlignTopLeft() == null) {
            this.setAlignTopLeft(false);
        }
        if (this.getPixelSize() == null) {
            this.setPixelSize(2.8E-4);
        }
        if (this.getYCoordinateFirst() == null) {
            this.setYCoordinateFirst(false);
        }
        String name = this.getName();
        SRS srs = this.getSrs();
        BoundingBox extent = this.getExtent();
        Boolean alignTopLeft = this.getAlignTopLeft();
        double[] resolutions = this.getResolutions();
        double[] scaleDenominators = this.getScaleDenominators();
        Double metersPerUnit = this.getMetersPerUnit();
        Double pixelSize = this.getPixelSize();
        String[] scaleNames = this.getScaleNames();
        Integer tileWidth = this.getTileWidth();
        Integer tileHeight = this.getTileHeight();
        Boolean yCoordinateFirst = this.getYCoordinateFirst();
        if (this.getResolutions() != null || this.getScaleDenominators() != null) {
            gridSet = GridSetFactory.createGridSet(name, srs, extent, alignTopLeft, resolutions, scaleDenominators, metersPerUnit, pixelSize, scaleNames, tileWidth, tileHeight, yCoordinateFirst);
        } else {
            if (this.getLevels() == null) {
                this.setLevels(18);
            }
            Integer levels = this.getLevels();
            gridSet = GridSetFactory.createGridSet(name, srs, extent, alignTopLeft, levels, metersPerUnit, pixelSize, tileWidth, tileHeight, yCoordinateFirst);
        }
        gridSet.setDescription(this.getDescription());
        return gridSet;
    }

    SRS getSrs() {
        return this.srs;
    }

    void setSrs(SRS srs) {
        this.srs = srs;
    }

    public BoundingBox getExtent() {
        return this.extent;
    }

    public void setExtent(BoundingBox extent) {
        this.extent = extent;
    }

    public Boolean getAlignTopLeft() {
        return this.alignTopLeft;
    }

    public void setAlignTopLeft(Boolean alignTopLeft) {
        this.alignTopLeft = alignTopLeft;
    }

    public double[] getResolutions() {
        return this.resolutions;
    }

    public void setResolutions(double[] resolutions) {
        this.resolutions = resolutions;
    }

    public double[] getScaleDenominators() {
        return this.scaleDenominators;
    }

    public void setScaleDenominators(double[] scaleDenominators) {
        this.scaleDenominators = scaleDenominators;
    }

    public Integer getLevels() {
        return this.levels;
    }

    public void setLevels(Integer levels) {
        this.levels = levels;
    }

    public Double getMetersPerUnit() {
        return this.metersPerUnit;
    }

    public void setMetersPerUnit(Double metersPerUnit) {
        this.metersPerUnit = metersPerUnit;
    }

    public Double getPixelSize() {
        return this.pixelSize;
    }

    public void setPixelSize(Double pixelSize) {
        this.pixelSize = pixelSize;
    }

    public String[] getScaleNames() {
        return this.scaleNames;
    }

    public void setScaleNames(String[] scaleNames) {
        this.scaleNames = scaleNames;
    }

    public Integer getTileHeight() {
        return this.tileHeight;
    }

    public void setTileHeight(Integer tileHeight) {
        this.tileHeight = tileHeight;
    }

    public Integer getTileWidth() {
        return this.tileWidth;
    }

    public void setTileWidth(Integer tileWidth) {
        this.tileWidth = tileWidth;
    }

    public Boolean getYCoordinateFirst() {
        return this.yCoordinateFirst;
    }

    public void setYCoordinateFirst(Boolean yCoordinateFirst) {
        this.yCoordinateFirst = yCoordinateFirst;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.alignTopLeft == null ? 0 : this.alignTopLeft.hashCode());
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.extent == null ? 0 : this.extent.hashCode());
        result = 31 * result + (this.levels == null ? 0 : this.levels.hashCode());
        result = 31 * result + (this.metersPerUnit == null ? 0 : this.metersPerUnit.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.pixelSize == null ? 0 : this.pixelSize.hashCode());
        result = 31 * result + Arrays.hashCode(this.resolutions);
        result = 31 * result + Arrays.hashCode(this.scaleDenominators);
        result = 31 * result + Arrays.hashCode(this.scaleNames);
        result = 31 * result + (this.srs == null ? 0 : this.srs.hashCode());
        result = 31 * result + (this.tileHeight == null ? 0 : this.tileHeight.hashCode());
        result = 31 * result + (this.tileWidth == null ? 0 : this.tileWidth.hashCode());
        result = 31 * result + (this.yCoordinateFirst == null ? 0 : this.yCoordinateFirst.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        XMLGridSet other = (XMLGridSet)obj;
        if (this.alignTopLeft == null ? other.alignTopLeft != null : !this.alignTopLeft.equals(other.alignTopLeft)) {
            return false;
        }
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.extent == null ? other.extent != null : !this.extent.equals(other.extent)) {
            return false;
        }
        if (this.levels == null ? other.levels != null : !this.levels.equals(other.levels)) {
            return false;
        }
        if (this.metersPerUnit == null ? other.metersPerUnit != null : !this.metersPerUnit.equals(other.metersPerUnit)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.pixelSize == null ? other.pixelSize != null : !this.pixelSize.equals(other.pixelSize)) {
            return false;
        }
        if (!Arrays.equals(this.resolutions, other.resolutions)) {
            return false;
        }
        if (!Arrays.equals(this.scaleDenominators, other.scaleDenominators)) {
            return false;
        }
        if (!Arrays.equals(this.scaleNames, other.scaleNames)) {
            return false;
        }
        if (this.srs == null ? other.srs != null : !this.srs.equals(other.srs)) {
            return false;
        }
        if (this.tileHeight == null ? other.tileHeight != null : !this.tileHeight.equals(other.tileHeight)) {
            return false;
        }
        if (this.tileWidth == null ? other.tileWidth != null : !this.tileWidth.equals(other.tileWidth)) {
            return false;
        }
        return !(this.yCoordinateFirst == null ? other.yCoordinateFirst != null : !this.yCoordinateFirst.equals(other.yCoordinateFirst));
    }

    public String toString() {
        return "XMLGridSet [name=" + this.name + ", description=" + this.description + ", srs=" + this.srs + ", extent=" + this.extent + ", alignTopLeft=" + this.alignTopLeft + ", resolutions=" + Arrays.toString(this.resolutions) + ", scaleDenominators=" + Arrays.toString(this.scaleDenominators) + ", levels=" + this.levels + ", metersPerUnit=" + this.metersPerUnit + ", pixelSize=" + this.pixelSize + ", scaleNames=" + Arrays.toString(this.scaleNames) + ", tileHeight=" + this.tileHeight + ", tileWidth=" + this.tileWidth + ", yCoordinateFirst=" + this.yCoordinateFirst + "]";
    }
}

