/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.geotools.util.logging.Logging;
import org.geowebcache.config.ConfigurationException;
import org.geowebcache.config.ConfigurationResourceProvider;
import org.geowebcache.storage.DefaultStorageFinder;
import org.geowebcache.util.ApplicationContextProvider;
import org.geowebcache.util.GWCVars;
import org.springframework.context.ApplicationContext;
import org.springframework.lang.NonNull;
import org.springframework.web.context.WebApplicationContext;

public class XMLFileResourceProvider
implements ConfigurationResourceProvider {
    private static Logger log = Logging.getLogger((String)XMLFileResourceProvider.class.getName());
    public static final String GWC_CONFIG_DIR_VAR = "GEOWEBCACHE_CONFIG_DIR";
    private final WebApplicationContext context;
    @NonNull
    private final File configDirectory;
    @NonNull
    private final String configFileName;
    private String templateLocation;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public XMLFileResourceProvider(String configFileName, WebApplicationContext appCtx, String configFileDirectory, DefaultStorageFinder storageDirFinder) throws ConfigurationException {
        if (configFileDirectory == null && storageDirFinder == null) {
            throw new NullPointerException("At least one of configFileDirectory or storageDirFinder must not be null");
        }
        this.context = appCtx;
        this.configFileName = configFileName;
        if (configFileDirectory != null) {
            if (new File(configFileDirectory).isAbsolute()) {
                log.config("Provided configuration directory as absolute path '" + configFileDirectory + "'");
                this.configDirectory = new File(configFileDirectory);
            } else {
                ServletContext servletContext = this.context.getServletContext();
                if (servletContext == null) throw new IllegalStateException("Unexpected, cannot locate the config directory");
                String baseDir = servletContext.getRealPath("");
                log.config("Provided configuration directory relative to servlet context '" + baseDir + "': " + configFileDirectory);
                this.configDirectory = new File(baseDir, configFileDirectory);
            }
        } else {
            this.configDirectory = new File(storageDirFinder.getDefaultPath());
        }
        log.config("Will look for " + configFileName + " in '" + this.configDirectory + "'");
    }

    public XMLFileResourceProvider(String configFileName, ApplicationContextProvider appCtx, String configFileDirectory, DefaultStorageFinder storageDirFinder) throws ConfigurationException {
        this(configFileName, appCtx == null ? null : appCtx.getApplicationContext(), configFileDirectory, storageDirFinder);
    }

    public XMLFileResourceProvider(String configFileName, ApplicationContextProvider appCtx, DefaultStorageFinder storageDirFinder) throws ConfigurationException {
        this(configFileName, appCtx, XMLFileResourceProvider.getConfigDirVar((ApplicationContext)appCtx.getApplicationContext()), storageDirFinder);
    }

    public XMLFileResourceProvider(String configFileName, WebApplicationContext appCtx, DefaultStorageFinder storageDirFinder) throws ConfigurationException {
        this(configFileName, appCtx, XMLFileResourceProvider.getConfigDirVar((ApplicationContext)appCtx), storageDirFinder);
    }

    @Override
    public InputStream in() throws IOException {
        return new FileInputStream(this.findOrCreateConfFile());
    }

    @Override
    public OutputStream out() throws IOException {
        return new FileOutputStream(this.findOrCreateConfFile());
    }

    @Override
    public void backup() throws IOException {
        this.backUpConfig(this.findOrCreateConfFile());
    }

    @Override
    public String getId() {
        return this.configDirectory.getAbsolutePath();
    }

    private static String getConfigDirVar(ApplicationContext ctxt) {
        return GWCVars.findEnvVar(ctxt, GWC_CONFIG_DIR_VAR);
    }

    @Override
    public void setTemplate(String templateLocation) {
        this.templateLocation = templateLocation;
    }

    private File findConfigFile() throws IOException {
        if (!this.configDirectory.exists() && !this.configDirectory.mkdirs()) {
            throw new IOException("TileLayerConfiguration directory does not exist and cannot be created: '" + this.configDirectory.getAbsolutePath() + "'");
        }
        return new File(this.configDirectory, this.configFileName);
    }

    @Override
    public String getLocation() throws IOException {
        File f = this.findConfigFile();
        try {
            return f.getCanonicalPath();
        }
        catch (IOException ex) {
            log.log(Level.SEVERE, "Could not canonize config path", ex);
            return f.getPath();
        }
    }

    private File findOrCreateConfFile() throws IOException {
        File xmlFile = this.findConfigFile();
        if (xmlFile.exists()) {
            log.config("Found configuration file in " + this.configDirectory.getAbsolutePath());
        } else if (this.templateLocation != null) {
            if (!this.configDirectory.canWrite()) {
                throw new IOException("TileLayerConfiguration directory is not writable: '" + this.configDirectory.getAbsolutePath() + "'");
            }
            log.warning("Found no configuration file in config directory, will create one at '" + xmlFile.getAbsolutePath() + "' from template " + this.getClass().getResource(this.templateLocation).toExternalForm());
            try (InputStream templateStream = this.getClass().getResourceAsStream(this.templateLocation);
                 FileOutputStream output = new FileOutputStream(xmlFile);){
                IOUtils.copy((InputStream)templateStream, (OutputStream)output);
                output.flush();
            }
            catch (IOException e) {
                throw new IOException("Error copying template config to " + xmlFile.getAbsolutePath(), e);
            }
        }
        return xmlFile;
    }

    private void backUpConfig(File xmlFile) throws IOException {
        String timeStamp = new SimpleDateFormat("yyyy-MM-dd'T'HHmmss").format(new Date());
        String backUpFileName = "geowebcache_" + timeStamp + ".bak";
        File parentFile = xmlFile.getParentFile();
        log.fine("Backing up config file " + xmlFile.getName() + " to " + backUpFileName);
        Object[] previousBackUps = parentFile.list((dir, name) -> {
            if (this.configFileName.equals(name)) {
                return false;
            }
            return name.startsWith(this.configFileName) && name.endsWith(".bak");
        });
        int maxBackups = 10;
        if (previousBackUps != null && previousBackUps.length > 10) {
            Arrays.sort(previousBackUps);
            Object oldest = previousBackUps[0];
            log.fine("Deleting oldest config backup " + (String)oldest + " to keep a maximum of 10 backups.");
            new File(parentFile, (String)oldest).delete();
        }
        File backUpFile = new File(parentFile, backUpFileName);
        FileUtils.copyFile((File)xmlFile, (File)backUpFile);
        log.fine("Config backup done");
    }

    @Override
    public boolean hasInput() {
        try {
            File file = this.findConfigFile();
            return file.exists() || this.templateLocation != null && this.configDirectory.canWrite();
        }
        catch (IOException e) {
            log.log(Level.WARNING, "Error obtaining config file", e);
            return false;
        }
    }

    @Override
    public boolean hasOutput() {
        try {
            File file = this.findConfigFile();
            return this.configDirectory.canWrite() && (!file.exists() || file.canWrite());
        }
        catch (IOException e) {
            log.log(Level.WARNING, "Error obtaining config file", e);
            return false;
        }
    }
}

