/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest.security;

import java.util.Map;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.rest.ResourceNotFoundException;
import org.geoserver.rest.RestException;
import org.geoserver.rest.catalog.NamedMap;
import org.geoserver.security.CatalogMode;
import org.geoserver.security.GeoServerSecurityManager;
import org.geoserver.security.impl.DataAccessRuleDAO;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path={"/rest/security/acl/catalog"})
public class CatalogModeController {
    static final String MODE_ELEMENT = "mode";
    static final String XML_ROOT_ELEM = "catalog";
    DataAccessRuleDAO ruleDAO = DataAccessRuleDAO.get();

    GeoServerSecurityManager getManager() {
        return (GeoServerSecurityManager)GeoServerExtensions.bean(GeoServerSecurityManager.class);
    }

    protected void checkUserIsAdmin() {
        if (!this.getManager().checkAuthenticationForAdminRole()) {
            throw new RestException("Administrative privileges required", HttpStatus.FORBIDDEN);
        }
    }

    @GetMapping(produces={"application/json", "text/json", "application/xml", "text/xml"})
    @ResponseBody
    public NamedMap mapGet() throws Exception {
        this.checkUserIsAdmin();
        CatalogMode mode = this.ruleDAO.getMode();
        NamedMap modeMap = new NamedMap(XML_ROOT_ELEM);
        modeMap.put(MODE_ELEMENT, mode.toString());
        return modeMap;
    }

    @PutMapping(consumes={"application/json", "text/json", "application/xml", "text/xml"})
    protected void mapPut(@RequestBody Map map) throws Exception {
        this.checkUserIsAdmin();
        String mode = (String)map.get(MODE_ELEMENT);
        if (mode == null) {
            throw new ResourceNotFoundException("Element mode is missing");
        }
        CatalogMode modeValue = null;
        for (CatalogMode m : CatalogMode.values()) {
            if (!m.toString().equals(mode)) continue;
            modeValue = m;
            break;
        }
        if (modeValue == null) {
            throw new RestException("Not a valid mode: " + mode, HttpStatus.UNPROCESSABLE_ENTITY);
        }
        this.ruleDAO.setCatalogMode(modeValue);
        this.ruleDAO.storeRules();
    }
}

