/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest.security;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.rest.ResourceNotFoundException;
import org.geoserver.rest.RestException;
import org.geoserver.rest.catalog.SequentialExecutionController;
import org.geoserver.rest.security.RuleMap;
import org.geoserver.security.GeoServerSecurityManager;
import org.geoserver.security.impl.AbstractAccessRuleDAO;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseBody;

public abstract class AbstractAclController<R extends Comparable<R>, DAO extends AbstractAccessRuleDAO<R>>
implements SequentialExecutionController {
    public static final String ANY = "*";
    DAO ruleDAO;

    AbstractAclController(DAO ruleDAO) {
        this.ruleDAO = ruleDAO;
    }

    GeoServerSecurityManager getManager() {
        return (GeoServerSecurityManager)GeoServerExtensions.bean(GeoServerSecurityManager.class);
    }

    @GetMapping(produces={"application/json", "text/json", "application/xml", "text/xml"})
    @ResponseBody
    public RuleMap rulesGet() throws IOException {
        this.checkUserIsAdmin();
        try {
            return this.getMap();
        }
        catch (Exception e) {
            throw this.createRestException(e);
        }
    }

    @PostMapping(consumes={"application/json", "text/json", "application/xml", "text/xml"})
    public void rulesPost(@RequestBody RuleMap<String, String> map) throws IOException {
        this.checkUserIsAdmin();
        try {
            this.postMap(map);
        }
        catch (Exception e) {
            throw this.createRestException(e);
        }
    }

    @PutMapping(consumes={"application/json", "text/json", "application/xml", "text/xml"})
    public void rulesPut(@RequestBody RuleMap<String, String> map) throws IOException {
        this.checkUserIsAdmin();
        try {
            this.putMap(map);
        }
        catch (Exception e) {
            throw this.createRestException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DeleteMapping(path={"/**"})
    public void rulesDelete(HttpServletRequest request) throws UnsupportedEncodingException {
        this.checkUserIsAdmin();
        String thePath = request.getPathInfo();
        String ruleString = thePath.substring(this.getBasePath().length() + 1);
        ruleString = URLDecoder.decode(ruleString, "utf-8");
        String msg = this.validateRuleKey(ruleString);
        if (msg != null) {
            throw new RestException(msg, HttpStatus.UNPROCESSABLE_ENTITY);
        }
        Comparable rule = null;
        for (Comparable ruleCandidate : this.ruleDAO.getRules()) {
            if (!ruleString.equals(this.keyFor(ruleCandidate))) continue;
            rule = ruleCandidate;
            break;
        }
        if (rule == null) {
            throw new ResourceNotFoundException("Rule not found: " + ruleString);
        }
        try {
            Iterator<Object> iterator = this.ruleDAO;
            synchronized (iterator) {
                this.ruleDAO.removeRule(rule);
                this.ruleDAO.storeRules();
            }
        }
        catch (Exception e) {
            throw this.createRestException(e);
        }
    }

    protected abstract String getBasePath();

    protected void checkUserIsAdmin() {
        if (!this.getManager().checkAuthenticationForAdminRole()) {
            throw new RestException("Administrative privileges required", HttpStatus.FORBIDDEN);
        }
    }

    protected abstract void addRuleToMap(R var1, Map<String, String> var2);

    public RuleMap<String, String> getMap() throws Exception {
        RuleMap<String, String> result = new RuleMap<String, String>();
        for (Comparable rule : this.ruleDAO.getRules()) {
            this.addRuleToMap(rule, result);
        }
        return result;
    }

    protected Set<Object> intersection(Map map) {
        HashSet<Object> result = new HashSet<Object>();
        HashSet<String> ruleKeys = new HashSet<String>();
        for (Comparable comparable : this.ruleDAO.getRules()) {
            ruleKeys.add(this.keyFor(comparable));
        }
        if (ruleKeys.isEmpty() || map.isEmpty()) {
            return result;
        }
        for (Object e : ruleKeys) {
            if (!map.containsKey(e)) continue;
            result.add(e);
        }
        return result;
    }

    protected Set<Object> nonExistingKeys(Map<?, ?> map) {
        List rules = this.ruleDAO.getRules();
        if (rules.isEmpty()) {
            return map.keySet().stream().collect(Collectors.toSet());
        }
        HashSet<Object> result = new HashSet<Object>();
        HashSet<String> ruleKeys = new HashSet<String>();
        for (Comparable rule : rules) {
            ruleKeys.add(this.keyFor(rule));
        }
        for (Object key : map.keySet()) {
            if (ruleKeys.contains(key)) continue;
            result.add(key);
        }
        return result;
    }

    protected abstract String keyFor(R var1);

    protected String validateRule(String ruleKey, String ruleValue) {
        return this.validateRuleKey(ruleKey);
    }

    protected abstract String validateRuleKey(String var1);

    protected abstract R convertEntryToRule(Map.Entry<String, String> var1);

    protected void validateMap(Map<String, String> ruleMap) {
        for (Map.Entry<String, String> entry : ruleMap.entrySet()) {
            String msg = this.validateRule(entry.getKey(), entry.getValue());
            if (msg == null) continue;
            throw new RestException(msg, HttpStatus.UNPROCESSABLE_ENTITY);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void postMap(Map<String, String> map) throws Exception {
        this.validateMap(map);
        Set<Object> commonKeys = this.intersection(map);
        if (!commonKeys.isEmpty()) {
            String msg = "Already existing rules: " + StringUtils.join(commonKeys.iterator(), (String)",");
            throw new RestException(msg, HttpStatus.CONFLICT);
        }
        DAO DAO = this.ruleDAO;
        synchronized (DAO) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                R rule = this.convertEntryToRule(entry);
                this.ruleDAO.addRule(rule);
            }
            this.ruleDAO.storeRules();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void putMap(Map<String, String> map) throws Exception {
        this.validateMap(map);
        Set<Object> nonExisting = this.nonExistingKeys(map);
        if (!nonExisting.isEmpty()) {
            String msg = "Unknown rules: " + StringUtils.join(nonExisting.iterator(), (String)",");
            throw new RestException(msg, HttpStatus.CONFLICT);
        }
        DAO DAO = this.ruleDAO;
        synchronized (DAO) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                R rule = this.convertEntryToRule(entry);
                this.ruleDAO.removeRule(rule);
                this.ruleDAO.addRule(rule);
            }
            this.ruleDAO.storeRules();
        }
    }

    protected Set<String> parseRoles(String roleCsv) {
        String[] rolesArray = roleCsv.split("[\\s,]+");
        HashSet<String> roles = new HashSet<String>(rolesArray.length);
        roles.addAll(Arrays.asList(rolesArray));
        for (String role : roles) {
            if (!ANY.equals(role)) continue;
            return Collections.singleton(ANY);
        }
        return roles;
    }

    protected RestException createRestException(Exception ex) {
        if (ex instanceof RestException) {
            return (RestException)ex;
        }
        return new RestException("", HttpStatus.INTERNAL_SERVER_ERROR, (Throwable)ex);
    }
}

