/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest.catalog;

import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.CoverageStoreInfo;
import org.geoserver.catalog.CoverageView;
import org.geoserver.catalog.MetadataMap;
import org.geoserver.catalog.ResourceInfo;
import org.geotools.api.geometry.Bounds;
import org.geotools.coverage.grid.io.StructuredGridCoverage2DReader;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.logging.Logging;

class MosaicInfoBBoxHandler {
    static final Logger LOGGER = Logging.getLogger(MosaicInfoBBoxHandler.class);
    private Catalog catalog;

    MosaicInfoBBoxHandler(Catalog catalog) {
        this.catalog = catalog;
    }

    void updateNativeBBox(String workspaceName, String storeName, StructuredGridCoverage2DReader reader) throws IOException {
        CoverageStoreInfo store = this.catalog.getCoverageStoreByName(workspaceName, storeName);
        this.updateNativeBBox(store, reader);
    }

    void updateNativeBBox(CoverageStoreInfo storeInfo, StructuredGridCoverage2DReader reader) throws IOException {
        List coverages = this.catalog.getCoveragesByStore(storeInfo);
        try {
            if (reader == null) {
                reader = (StructuredGridCoverage2DReader)storeInfo.getGridCoverageReader(null, null);
            }
            StructuredGridCoverage2DReader defaultReader = reader;
            for (CoverageInfo ci : coverages) {
                MetadataMap metadata = ci.getMetadata();
                reader = metadata != null && metadata.containsKey((Object)CoverageView.COVERAGE_VIEW) ? (StructuredGridCoverage2DReader)this.catalog.getResourcePool().getGridCoverageReader(ci, null) : defaultReader;
                ReferencedEnvelope newBbox = new ReferencedEnvelope((Bounds)reader.getOriginalEnvelope(ci.getName()));
                ci.setNativeBoundingBox(newBbox);
                this.catalog.save((ResourceInfo)ci);
            }
        }
        catch (ClassCastException ex) {
            LOGGER.log(Level.FINE, "Store doesn't support harvesting. Cannot update layer's native bounding box");
        }
    }
}

