/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest.catalog;

import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import freemarker.template.ObjectWrapper;
import freemarker.template.SimpleHash;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.CatalogFacade;
import org.geoserver.catalog.CatalogInfo;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.PublishedInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.impl.ResolvingProxy;
import org.geoserver.config.util.XStreamPersister;
import org.geoserver.rest.ObjectToMapWrapper;
import org.geoserver.rest.ResourceNotFoundException;
import org.geoserver.rest.RestException;
import org.geoserver.rest.catalog.AbstractCatalogController;
import org.geoserver.rest.converters.XStreamMessageConverter;
import org.geoserver.rest.wrapper.RestWrapper;
import org.geotools.util.logging.Logging;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.MethodParameter;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

@RestController
@ControllerAdvice
@RequestMapping(path={"/rest/layergroups", "/rest/workspaces/{workspaceName}/layergroups"}, produces={"application/json", "application/xml", "text/html"})
public class LayerGroupController
extends AbstractCatalogController {
    private static final Logger LOGGER = Logging.getLogger(LayerGroupController.class);

    @Autowired
    public LayerGroupController(@Qualifier(value="catalog") Catalog catalog) {
        super(catalog);
    }

    @GetMapping
    public RestWrapper<?> getLayerGroups(@PathVariable(required=false) String workspaceName) {
        if (workspaceName != null && this.catalog.getWorkspaceByName(workspaceName) == null) {
            throw new ResourceNotFoundException("Workspace " + workspaceName + " not found");
        }
        List layerGroupInfos = workspaceName != null ? this.catalog.getLayerGroupsByWorkspace(workspaceName) : this.catalog.getLayerGroupsByWorkspace(CatalogFacade.NO_WORKSPACE);
        return this.wrapList(layerGroupInfos, LayerGroupInfo.class);
    }

    @GetMapping(value={"{layerGroupName}"})
    public RestWrapper<?> getLayerGroup(@PathVariable String layerGroupName, @PathVariable(required=false) String workspaceName) {
        LayerGroupInfo layerGroupInfo;
        if (workspaceName != null && this.catalog.getWorkspaceByName(workspaceName) == null) {
            throw new ResourceNotFoundException("Workspace " + workspaceName + " not found");
        }
        LayerGroupInfo layerGroupInfo2 = layerGroupInfo = workspaceName != null ? this.catalog.getLayerGroupByName(workspaceName, layerGroupName) : this.catalog.getLayerGroupByName(layerGroupName);
        if (layerGroupInfo == null) {
            throw new ResourceNotFoundException("No such layer group " + layerGroupName + (String)(workspaceName == null ? "" : " in workspace " + workspaceName));
        }
        return this.wrapObject(layerGroupInfo, LayerGroupInfo.class);
    }

    @PostMapping(consumes={"application/json", "text/json", "application/xml", "text/xml"})
    public ResponseEntity<String> layerGroupPost(@RequestBody LayerGroupInfo lg, @PathVariable(required=false) String workspaceName, UriComponentsBuilder builder) throws Exception {
        if (workspaceName != null && this.catalog.getWorkspaceByName(workspaceName) == null) {
            throw new ResourceNotFoundException("Workspace " + workspaceName + " not found");
        }
        this.checkFullAdminRequired(workspaceName);
        if (lg.getLayers().isEmpty()) {
            throw new RestException("layer group must not be empty", HttpStatus.BAD_REQUEST);
        }
        for (int i = 0; i < lg.getLayers().size(); ++i) {
            lg.getLayers().set(i, (PublishedInfo)ResolvingProxy.resolve((Catalog)this.catalog, (Object)((PublishedInfo)lg.getLayers().get(i))));
        }
        if (lg.getBounds() == null) {
            LOGGER.fine("Auto calculating layer group bounds");
            new CatalogBuilder(this.catalog).calculateLayerGroupBounds(lg);
        }
        if (workspaceName != null) {
            lg.setWorkspace(this.catalog.getWorkspaceByName(workspaceName));
        }
        if (lg.getMode() == null) {
            LOGGER.fine("Setting layer group mode SINGLE");
            lg.setMode(LayerGroupInfo.Mode.SINGLE);
        }
        this.catalog.validate(lg, true).throwIfInvalid();
        this.catalog.add(lg);
        String layerGroupName = lg.getName();
        LOGGER.info("POST layer group " + layerGroupName);
        UriComponents uriComponents = builder.path("/layergroups/{layerGroupName}").buildAndExpand(new Object[]{layerGroupName});
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.setLocation(uriComponents.toUri());
        httpHeaders.setContentType(MediaType.TEXT_PLAIN);
        return new ResponseEntity((Object)layerGroupName, (MultiValueMap)httpHeaders, HttpStatus.CREATED);
    }

    @PutMapping(value={"{layerGroupName}"}, consumes={"application/json", "text/json", "application/xml", "text/xml"})
    public void layerGroupPut(@RequestBody LayerGroupInfo lg, @PathVariable(required=false) String workspaceName, @PathVariable String layerGroupName) throws Exception {
        LayerGroupInfo original;
        if (workspaceName != null && this.catalog.getWorkspaceByName(workspaceName) == null) {
            throw new ResourceNotFoundException("Workspace " + workspaceName + " not found");
        }
        this.checkFullAdminRequired(workspaceName);
        LayerGroupInfo layerGroupInfo = original = workspaceName != null ? this.catalog.getLayerGroupByName(workspaceName, layerGroupName) : this.catalog.getLayerGroupByName(layerGroupName);
        if (lg.getName() != null && !lg.getName().equals(original.getName())) {
            throw new RestException("Can't change name of a layer group", HttpStatus.FORBIDDEN);
        }
        if (lg.getWorkspace() != null && !lg.getWorkspace().equals(original.getWorkspace())) {
            throw new RestException("Can't change the workspace of a layer group, instead DELETE from existing workspace and POST to new workspace", HttpStatus.FORBIDDEN);
        }
        LOGGER.info("PUT layer group " + layerGroupName + (String)(workspaceName != null ? ", workspace " + workspaceName : ""));
        new CatalogBuilder(this.catalog).updateLayerGroup(original, lg);
        this.catalog.save(original);
    }

    @DeleteMapping(value={"{layerGroupName}"})
    public void layerGroupDelete(@PathVariable(required=false) String workspaceName, @PathVariable String layerGroupName) {
        if (workspaceName != null && this.catalog.getWorkspaceByName(workspaceName) == null) {
            throw new ResourceNotFoundException("Workspace " + workspaceName + " not found");
        }
        LOGGER.info("DELETE layer group " + layerGroupName);
        LayerGroupInfo lg = workspaceName == null ? this.catalog.getLayerGroupByName(layerGroupName) : this.catalog.getLayerGroupByName(workspaceName, layerGroupName);
        this.catalog.remove(lg);
    }

    public boolean supports(MethodParameter methodParameter, Type targetType, Class<? extends HttpMessageConverter<?>> converterType) {
        return LayerGroupInfo.class.isAssignableFrom(methodParameter.getParameterType());
    }

    public void configurePersister(XStreamPersister persister, final XStreamMessageConverter converter) {
        persister.setCallback(new XStreamPersister.Callback(){

            protected Class<LayerGroupInfo> getObjectClass() {
                return LayerGroupInfo.class;
            }

            protected CatalogInfo getCatalogObject() {
                Map uriTemplateVars = LayerGroupController.this.getURITemplateVariables();
                String workspace = (String)uriTemplateVars.get("workspaceName");
                String layerGroup = (String)uriTemplateVars.get("layerGroupName");
                if (layerGroup == null) {
                    return null;
                }
                return LayerGroupController.this.catalog.getLayerGroupByName(workspace, layerGroup);
            }

            protected void postEncodeReference(Object obj, String ref, String prefix, HierarchicalStreamWriter writer, MarshallingContext context) {
                if (obj instanceof StyleInfo) {
                    StringBuilder link = new StringBuilder();
                    if (prefix != null) {
                        link.append("/workspaces/").append(converter.encode(prefix));
                    }
                    link.append("/styles/").append(converter.encode(ref));
                    converter.encodeLink(link.toString(), writer);
                }
                if (obj instanceof LayerInfo) {
                    converter.encodeLink("/workspaces/" + prefix + "/layers/" + converter.encode(ref), writer);
                } else if (obj instanceof LayerGroupInfo) {
                    LayerGroupInfo lg = (LayerGroupInfo)obj;
                    if (lg.getWorkspace() != null) {
                        converter.encodeLink("/workspaces/" + lg.getWorkspace().getName() + "/layergroups/" + converter.encode(ref), writer);
                    } else {
                        converter.encodeLink("/layergroups/" + converter.encode(ref), writer);
                    }
                }
            }
        });
    }

    protected <T> ObjectWrapper createObjectWrapper(Class<T> clazz) {
        return new ObjectToMapWrapper<LayerGroupInfo>(LayerGroupInfo.class){

            protected void wrapInternal(Map<String, Object> properties, SimpleHash model, LayerGroupInfo layerGroup) {
                if (properties == null) {
                    properties = this.hashToProperties(model);
                }
                ArrayList layerProps = new ArrayList();
                for (PublishedInfo info : layerGroup.getLayers()) {
                    HashMap<String, String> props = new HashMap<String, String>();
                    if (info != null) {
                        props.put("name", info.getName());
                        props.put("prefixedName", info.prefixedName());
                    }
                    layerProps.add(Collections.singletonMap("properties", props));
                }
                properties.put("layers", layerProps);
                ArrayList styleProps = new ArrayList();
                for (StyleInfo info : layerGroup.getStyles()) {
                    HashMap<String, String> props = new HashMap<String, String>();
                    if (info != null) {
                        props.put("name", info.getName());
                        if (info.getWorkspace() != null) {
                            props.put("workspace", info.getWorkspace().getName());
                        }
                    }
                    styleProps.add(Collections.singletonMap("properties", props));
                }
                properties.put("styles", styleProps);
            }

            protected void wrapInternal(SimpleHash model, Collection object) {
                for (Object l : object) {
                    LayerGroupInfo lg = (LayerGroupInfo)l;
                    this.wrapInternal(null, model, lg);
                }
            }
        };
    }
}

