/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.diskquota.jdbc;

import java.sql.ResultSet;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.geowebcache.diskquota.jdbc.SimpleJdbcTemplate;
import org.springframework.jdbc.support.JdbcAccessor;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.jdbc.support.MetaDataAccessException;

public class SQLDialect {
    protected static final int LAYER_NAME_SIZE = 128;
    protected static final int GRIDSET_ID_SIZE = 32;
    protected static final int BLOB_FORMAT_SIZE = 64;
    protected static final int PARAMETERS_ID_SIZE = 41;
    protected static final int BYTES_SIZE = 21;
    protected static final int NUM_HITS_SIZE = 64;
    protected static final int TILESET_KEY_SIZE = 320;
    protected static final int TILEPAGE_KEY_SIZE = 320;
    protected final Map<String, List<String>> TABLE_CREATION_MAP = new LinkedHashMap<String, List<String>>(){
        {
            this.put("TILESET", Arrays.asList("CREATE TABLE ${schema}TILESET (\n  KEY VARCHAR(320) PRIMARY KEY,\n  LAYER_NAME VARCHAR(128),\n  GRIDSET_ID VARCHAR(32),\n  BLOB_FORMAT VARCHAR(64),\n  PARAMETERS_ID VARCHAR(41),\n  BYTES NUMERIC(21) NOT NULL DEFAULT 0\n)", "CREATE INDEX TILESET_LAYER ON ${schema}TILESET(LAYER_NAME)"));
            this.put("TILEPAGE", Arrays.asList("CREATE TABLE ${schema}TILEPAGE (\n KEY VARCHAR(320) PRIMARY KEY,\n TILESET_ID VARCHAR(320) REFERENCES ${schema}TILESET(KEY) ON DELETE CASCADE,\n PAGE_Z SMALLINT,\n PAGE_X INTEGER,\n PAGE_Y INTEGER,\n CREATION_TIME_MINUTES INTEGER,\n FREQUENCY_OF_USE FLOAT,\n LAST_ACCESS_TIME_MINUTES INTEGER,\n FILL_FACTOR FLOAT,\n NUM_HITS NUMERIC(64)\n)", "CREATE INDEX TILEPAGE_TILESET ON ${schema}TILEPAGE(TILESET_ID, FILL_FACTOR)", "CREATE INDEX TILEPAGE_FREQUENCY ON ${schema}TILEPAGE(FREQUENCY_OF_USE DESC)", "CREATE INDEX TILEPAGE_LAST_ACCESS ON ${schema}TILEPAGE(LAST_ACCESS_TIME_MINUTES DESC)"));
        }
    };

    public void initializeTables(String schema, SimpleJdbcTemplate template) {
        Object prefix = schema == null ? "" : schema + ".";
        for (String table : this.TABLE_CREATION_MAP.keySet()) {
            if (this.tableExists(template, schema, table)) continue;
            for (String command : this.TABLE_CREATION_MAP.get(table)) {
                command = command.replace("${schema}", (CharSequence)prefix);
                template.getJdbcOperations().execute(command);
            }
        }
    }

    private boolean tableExists(SimpleJdbcTemplate template, String schema, String tableName) {
        try {
            DataSource ds = ((JdbcAccessor)template.getJdbcOperations()).getDataSource();
            if (ds == null) {
                return false;
            }
            return (Boolean)JdbcUtils.extractDatabaseMetaData((DataSource)ds, dbmd -> {
                try (ResultSet rs = dbmd.getTables(null, schema, tableName.toLowerCase(), null);){
                    boolean exists = rs.next();
                    rs.close();
                    if (exists) {
                        Boolean bl = true;
                        return bl;
                    }
                }
                rs = dbmd.getTables(null, schema, tableName, null);
                try {
                    Boolean bl = rs.next();
                    return bl;
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
            });
        }
        catch (MetaDataAccessException e) {
            return false;
        }
    }

    public String getAllLayersQuery(String schema) {
        StringBuilder sb = new StringBuilder("SELECT DISTINCT(LAYER_NAME) FROM ");
        if (schema != null) {
            sb.append(schema).append(".");
        }
        sb.append("TILESET WHERE KEY <> '___GLOBAL_QUOTA___'");
        return sb.toString();
    }

    public String getLayerDeletionStatement(String schema, String layerNameParam) {
        StringBuilder sb = new StringBuilder("DELETE FROM ");
        if (schema != null) {
            sb.append(schema).append(".");
        }
        sb.append("TILESET WHERE LAYER_NAME = :").append(layerNameParam);
        return sb.toString();
    }

    public String getLayerGridDeletionStatement(String schema, String layerNameParam, String gridsetIdParam) {
        StringBuilder sb = new StringBuilder("DELETE FROM ");
        if (schema != null) {
            sb.append(schema).append(".");
        }
        sb.append("TILESET WHERE LAYER_NAME = :").append(layerNameParam);
        sb.append(" AND GRIDSET_ID = :").append(gridsetIdParam);
        return sb.toString();
    }

    public String getLayerParametersDeletionStatement(String schema, String layerNameParam, String parametersIdParam) {
        StringBuilder sb = new StringBuilder("DELETE FROM ");
        if (schema != null) {
            sb.append(schema).append(".");
        }
        sb.append("TILESET WHERE LAYER_NAME = :").append(layerNameParam);
        sb.append(" AND PARAMETERS_ID = :").append(parametersIdParam);
        return sb.toString();
    }

    public String getTileSetsQuery(String schema) {
        StringBuilder sb = new StringBuilder("SELECT KEY, LAYER_NAME, GRIDSET_ID, BLOB_FORMAT, PARAMETERS_ID FROM ");
        if (schema != null) {
            sb.append(schema).append(".");
        }
        sb.append("TILESET");
        return sb.toString();
    }

    public String getTileSetQuery(String schema, String keyParam) {
        StringBuilder sb = new StringBuilder("SELECT KEY, LAYER_NAME, GRIDSET_ID, BLOB_FORMAT, PARAMETERS_ID FROM ");
        if (schema != null) {
            sb.append(schema).append(".");
        }
        sb.append("TILESET WHERE KEY = :" + keyParam);
        return sb.toString();
    }

    public String getCreateTileSetQuery(String schema, String keyParam, String layerNameParam, String gridSetIdParam, String blobFormatParam, String paramIdParam) {
        StringBuilder sb = new StringBuilder("INSERT INTO ");
        if (schema != null) {
            sb.append(schema).append(".");
        }
        sb.append("TILESET select :").append(keyParam);
        sb.append(", :").append(layerNameParam);
        sb.append(", :").append(gridSetIdParam);
        sb.append(", :").append(blobFormatParam);
        sb.append(", :").append(paramIdParam);
        sb.append(", 0 ");
        this.addEmtpyTableReference(sb);
        sb.append(" WHERE NOT EXISTS(SELECT 1 FROM ");
        if (schema != null) {
            sb.append(schema).append(".");
        }
        sb.append("TILESET WHERE KEY = :").append(keyParam).append(")");
        return sb.toString();
    }

    protected void addEmtpyTableReference(StringBuilder sb) {
    }

    public String getUsedQuotaByTileSetId(String schema, String keyParam) {
        StringBuilder sb = new StringBuilder("SELECT BYTES FROM ");
        if (schema != null) {
            sb.append(schema).append(".");
        }
        sb.append("TILESET WHERE KEY = :" + keyParam);
        return sb.toString();
    }

    public String getUsedQuotaByGridSetId(String schema, String gridsetIdParam) {
        StringBuilder sb = new StringBuilder("SELECT SUM(BYTES) FROM ");
        if (schema != null) {
            sb.append(schema).append(".");
        }
        sb.append("TILESET WHERE GRIDSET_ID = :").append(gridsetIdParam);
        return sb.toString();
    }

    public String getUsedQuotaByParametersId(String schema, String parametersIdParam) {
        StringBuilder sb = new StringBuilder("SELECT SUM(BYTES) FROM ");
        if (schema != null) {
            sb.append(schema).append(".");
        }
        sb.append("TILESET WHERE PARAMETERS_ID = :").append(parametersIdParam);
        return sb.toString();
    }

    public String getUsedQuotaByLayerName(String schema, String layerNameParam) {
        StringBuilder sb = new StringBuilder("SELECT SUM(BYTES) FROM ");
        if (schema != null) {
            sb.append(schema).append(".");
        }
        sb.append("TILESET WHERE TILESET.LAYER_NAME = :").append(layerNameParam);
        return sb.toString();
    }

    public String getUsedQuotaByLayerGridset(String schema, String layerNameParam, String gridSetParam) {
        StringBuilder sb = new StringBuilder("SELECT SUM(BYTES) FROM ");
        if (schema != null) {
            sb.append(schema).append(".");
        }
        sb.append("TILESET WHERE TILESET.LAYER_NAME = :").append(layerNameParam);
        sb.append(" AND TILESET.GRIDSET_ID = :").append(gridSetParam);
        return sb.toString();
    }

    public String getRenameLayerStatement(String schema, String oldLayerName, String newLayerName) {
        StringBuilder sb = new StringBuilder("UPDATE ");
        if (schema != null) {
            sb.append(schema).append(".");
        }
        sb.append("TILESET SET LAYER_NAME = :").append(newLayerName).append(" WHERE LAYER_NAME = :").append(oldLayerName);
        return sb.toString();
    }

    public String getUpdateQuotaStatement(String schema, String tileSetIdParam, String bytesParam) {
        StringBuilder sb = new StringBuilder("UPDATE ");
        if (schema != null) {
            sb.append(schema).append(".");
        }
        sb.append("TILESET SET BYTES = BYTES + (:").append(bytesParam).append(")");
        sb.append(" WHERE KEY = :").append(tileSetIdParam);
        return sb.toString();
    }

    public String getPageStats(String schema, String keyParam) {
        StringBuilder sb = new StringBuilder("SELECT FREQUENCY_OF_USE, LAST_ACCESS_TIME_MINUTES, FILL_FACTOR, NUM_HITS FROM ");
        if (schema != null) {
            sb.append(schema).append(".");
        }
        sb.append("TILEPAGE WHERE KEY = :").append(keyParam);
        return sb.toString();
    }

    public String contionalTilePageInsertStatement(String schema, String keyParam, String tileSetIdParam, String zParam, String xParam, String yParam, String creationParam, String frequencyParam, String lastAccessParam, String fillFactorParam, String numHitsParam) {
        StringBuilder sb = new StringBuilder("INSERT INTO ");
        if (schema != null) {
            sb.append(schema).append(".");
        }
        sb.append("TILEPAGE SELECT :").append(keyParam).append(", ");
        sb.append(":").append(tileSetIdParam).append(", ");
        sb.append(":").append(zParam).append(", ");
        sb.append(":").append(xParam).append(", ");
        sb.append(":").append(yParam).append(", ");
        sb.append(":").append(creationParam).append(", ");
        sb.append(":").append(frequencyParam).append(", ");
        sb.append(":").append(lastAccessParam).append(", ");
        sb.append(":").append(fillFactorParam).append(", ");
        sb.append(":").append(numHitsParam).append(" ");
        this.addEmtpyTableReference(sb);
        sb.append(" WHERE NOT EXISTS(SELECT 1 FROM ");
        if (schema != null) {
            sb.append(schema).append(".");
        }
        sb.append("TILEPAGE WHERE KEY = :").append(keyParam).append(")");
        return sb.toString();
    }

    public String conditionalUpdatePageStatsFillFactor(String schema, String keyParam, String newfillFactorParam, String oldFillFactorParam) {
        StringBuilder sb = new StringBuilder("UPDATE ");
        if (schema != null) {
            sb.append(schema).append(".");
        }
        sb.append("TILEPAGE SET FILL_FACTOR = :").append(newfillFactorParam);
        sb.append(" WHERE KEY = :").append(keyParam);
        sb.append(" AND FILL_FACTOR = :").append(oldFillFactorParam);
        return sb.toString();
    }

    public String updatePageStatsFillFactor(String schema, String keyParam, String newfillFactorParam) {
        StringBuilder sb = new StringBuilder("UPDATE ");
        if (schema != null) {
            sb.append(schema).append(".");
        }
        sb.append("TILEPAGE SET FILL_FACTOR = :").append(newfillFactorParam);
        sb.append(" WHERE KEY = :").append(keyParam);
        return sb.toString();
    }

    public String updatePageStats(String schema, String keyParam, String newHitsParam, String oldHitsParam, String newFrequencyParam, String oldFrequencyParam, String newLastAccessTimeParam, String oldLastAccessTimeParam) {
        StringBuilder sb = new StringBuilder("UPDATE ");
        if (schema != null) {
            sb.append(schema).append(".");
        }
        sb.append("TILEPAGE SET NUM_HITS = :").append(newHitsParam);
        sb.append(", FREQUENCY_OF_USE = :").append(newFrequencyParam);
        sb.append(", LAST_ACCESS_TIME_MINUTES = :").append(newLastAccessTimeParam);
        sb.append(" WHERE KEY = :").append(keyParam);
        sb.append(" AND NUM_HITS = :").append(oldHitsParam);
        sb.append(" AND FREQUENCY_OF_USE = :").append(oldFrequencyParam);
        sb.append(" AND LAST_ACCESS_TIME_MINUTES = :").append(oldLastAccessTimeParam);
        return sb.toString();
    }

    public String getLeastFrequentlyUsedPage(String schema, List<String> layerParamNames) {
        StringBuilder sb = new StringBuilder("SELECT TILESET_ID, PAGE_X, PAGE_Y, PAGE_Z, CREATION_TIME_MINUTES FROM ");
        if (schema != null) {
            sb.append(schema).append(".");
        }
        sb.append("TILEPAGE WHERE FILL_FACTOR > 0 ");
        sb.append("AND TILESET_ID IN (");
        sb.append("SELECT KEY FROM ");
        if (schema != null) {
            sb.append(schema).append(".");
        }
        sb.append("TILESET WHERE LAYER_NAME IN (");
        for (int i = 0; i < layerParamNames.size(); ++i) {
            sb.append(":" + layerParamNames.get(i));
            if (i >= layerParamNames.size() - 1) continue;
            sb.append(", ");
        }
        sb.append(")) ");
        sb.append("ORDER BY FREQUENCY_OF_USE ASC LIMIT 1");
        return sb.toString();
    }

    public String getLeastRecentlyUsedPage(String schema, List<String> layerParamNames) {
        StringBuilder sb = new StringBuilder("SELECT TILESET_ID, PAGE_X, PAGE_Y, PAGE_Z, CREATION_TIME_MINUTES FROM ");
        if (schema != null) {
            sb.append(schema).append(".");
        }
        sb.append("TILEPAGE WHERE FILL_FACTOR > 0 ");
        sb.append("AND TILESET_ID IN (");
        sb.append("SELECT KEY FROM ");
        if (schema != null) {
            sb.append(schema).append(".");
        }
        sb.append("TILESET WHERE LAYER_NAME IN (");
        for (int i = 0; i < layerParamNames.size(); ++i) {
            sb.append(":" + layerParamNames.get(i));
            if (i >= layerParamNames.size() - 1) continue;
            sb.append(", ");
        }
        sb.append(")) ");
        sb.append("ORDER BY LAST_ACCESS_TIME_MINUTES ASC LIMIT 1");
        return sb.toString();
    }
}

